/*
 * Decompiled with CFR 0.152.
 */
package com.asn1c.codec;

import com.asn1c.codec.DataEncoder;
import com.asn1c.codec.Encoder;
import com.asn1c.codec.FilterEncoder;
import com.asn1c.codec.License;
import com.asn1c.core.BadValueException;
import com.asn1c.core.BitString;
import com.asn1c.core.CharacterString;
import com.asn1c.core.DataValue;
import com.asn1c.core.EmbeddedPDV;
import com.asn1c.core.External;
import com.asn1c.core.GeneralizedTime;
import com.asn1c.core.Identification;
import com.asn1c.core.Null;
import com.asn1c.core.ObjectDescriptor;
import com.asn1c.core.ObjectIdentifier;
import com.asn1c.core.OctetString;
import com.asn1c.core.String16;
import com.asn1c.core.String32;
import com.asn1c.core.TrimmedBitString;
import com.asn1c.core.UTCTime;
import com.asn1c.core.UnitString;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Hashtable;
import java.util.Vector;

public abstract class CEREncoder
extends FilterEncoder {
    private Vector embeddedPdvIdentificationCache;
    private Vector characterStringIdentificationCache;
    private static int done = -1;
    private static final int[] tab = new int[]{0, 1996959894, -301047508, -1727442502, 124634137, 1886057615, -379345611, -1637575261, 249268274, 2044508324, -522852066, -1747789432, 162941995, 2125561021, -407360249, -1866523247, 498536548, 1789927666, -205950648, -2067906082, 450548861, 1843258603, -187386543, -2083289657, 325883990, 1684777152, -43845254, -1973040660, 335633487, 1661365465, -99664541, -1928851979, 997073096, 1281953886, -715111964, -1570279054, 1006888145, 1258607687, -770865667, -1526024853, 901097722, 1119000684, -608450090, -1396901568, 853044451, 1172266101, -589951537, -1412350631, 651767980, 1373503546, -925412992, -1076862698, 565507253, 1454621731, -809855591, -1195530993, 671266974, 1594198024, -972236366, -1324619484, 795835527, 1483230225, -1050600021, -1234817731, 1994146192, 31158534, -1731059524, -271249366, 1907459465, 112637215, -1614814043, -390540237, 2013776290, 251722036, -1777751922, -519137256, 2137656763, 141376813, -1855689577, -429695999, 1802195444, 476864866, -2056965928, -228458418, 1812370925, 453092731, -2113342271, -183516073, 1706088902, 314042704, -1950435094, -54949764, 1658658271, 366619977, -1932296973, -69972891, 1303535960, 984961486, -1547960204, -725929758, 1256170817, 1037604311, -1529756563, -740887301, 1131014506, 879679996, -1385723834, -631195440, 1141124467, 855842277, -1442165665, -586318647, 1342533948, 654459306, -1106571248, -921952122, 1466479909, 544179635, -1184443383, -832445281, 1591671054, 702138776, -1328506846, -942167884, 1504918807, 783551873, -1212326853, -1061524307, -306674912, -1698712650, 62317068, 1957810842, -355121351, -1647151185, 81470997, 1943803523, -480048366, -1805370492, 225274430, 2053790376, -468791541, -1828061283, 167816743, 2097651377, -267414716, -2029476910, 503444072, 1762050814, -144550051, -2140837941, 426522225, 1852507879, -19653770, -1982649376, 282753626, 1742555852, -105259153, -1900089351, 397917763, 1622183637, -690576408, -1580100738, 953729732, 1340076626, -776247311, -1497606297, 1068828381, 1219638859, -670225446, -1358292148, 906185462, 1090812512, -547295293, -1469587627, 829329135, 1181335161, -882789492, -1134132454, 628085408, 1382605366, -871598187, -1156888829, 570562233, 1426400815, -977650754, -1296233688, 733239954, 1555261956, -1026031705, -1244606671, 752459403, 1541320221, -1687895376, -328994266, 1969922972, 40735498, -1677130071, -351390145, 1913087877, 83908371, -1782625662, -491226604, 2075208622, 213261112, -1831694693, -438977011, 2094854071, 198958881, -2032938284, -237706686, 1759359992, 534414190, -2118248755, -155638181, 1873836001, 414664567, -2012718362, -15766928, 1711684554, 285281116, -1889165569, -127750551, 1634467795, 376229701, -1609899400, -686959890, 1308918612, 956543938, -1486412191, -799009033, 1231636301, 1047427035, -1362007478, -640263460, 1088359270, 936918000, -1447252397, -558129467, 1202900863, 817233897, -1111625188, -893730166, 1404277552, 615818150, -1160759803, -841546093, 1423857449, 601450431, -1285129682, -1000256840, 1567103746, 711928724, -1274298825, -1022587231, 1510334235, 755167117};
    private Hashtable encoderCache;
    private int currentTag;
    private DataEncoder currentEncoder;
    private boolean isIndefiniteLengthEncoder;

    public CEREncoder(Encoder encoder, String string, byte[] byArray) {
        super(encoder);
        if (done == -1) {
            CEREncoder.examine(byArray);
        }
        this.embeddedPdvIdentificationCache = new Vector();
        this.characterStringIdentificationCache = new Vector();
        this.encoderCache = new Hashtable();
        this.encoderCache.put(string, this);
    }

    protected CEREncoder(Encoder encoder, CEREncoder cEREncoder, boolean bl) {
        super(encoder);
        if (done == -1) {
            throw new InternalError();
        }
        this.embeddedPdvIdentificationCache = new Vector();
        this.characterStringIdentificationCache = new Vector();
        this.encoderCache = cEREncoder.encoderCache;
        this.isIndefiniteLengthEncoder = bl;
    }

    private static final void examine(byte[] byArray) {
        done = 0;
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length - 4) {
            n = tab[(n ^ byArray[n2]) & 0xFF] ^ n >>> 8;
            ++n2;
        }
        if (n != ((byArray[n2] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF)) {
            return;
        }
        n = 0;
        n2 = 0;
        while (n2 < License.data.length - 4) {
            n = tab[(n ^ License.data[n2]) & 0xFF] ^ n >>> 8;
            ++n2;
        }
        if (n != ((License.data[n2] & 0xFF) << 24 | (License.data[n2 + 1] & 0xFF) << 16 | (License.data[n2 + 2] & 0xFF) << 8 | License.data[n2 + 3] & 0xFF)) {
            return;
        }
        done = 1;
    }

    public void joinEncoder(CEREncoder cEREncoder) {
        if (this.out != cEREncoder.out) {
            throw new IllegalArgumentException("cannot join encoders of different input streams");
        }
        this.encoderCache.putAll(cEREncoder.encoderCache);
        cEREncoder.encoderCache = this.encoderCache;
        cEREncoder.embeddedPdvIdentificationCache = this.embeddedPdvIdentificationCache;
        cEREncoder.characterStringIdentificationCache = this.characterStringIdentificationCache;
    }

    protected CEREncoder getEncoder(String string) {
        return (CEREncoder)this.encoderCache.get(string);
    }

    public void writeTagLength(int n, int n2, boolean bl) throws IOException {
        int n3;
        if (done != 1) {
            n3 = 0;
        }
        int n4 = n >> 24 & 0xE0;
        n3 = n & 0x1FFFFFFF;
        if (n3 < 31) {
            this.writeByte((byte)(n4 | n3));
        } else if (n3 < 128) {
            this.writeByte((byte)(n4 | 0x1F));
            this.writeByte((byte)n3);
        } else if (n3 < 16384) {
            this.writeByte((byte)(n4 | 0x1F));
            this.writeByte((byte)(n3 >> 7 | 0x80));
            this.writeByte((byte)(n3 & 0x7F));
        } else if (n3 < 0x200000) {
            this.writeByte((byte)(n4 | 0x1F));
            this.writeByte((byte)(n3 >> 14 | 0x80));
            this.writeByte((byte)(n3 >> 7 | 0x80));
            this.writeByte((byte)(n3 & 0x7F));
        } else if (n3 < 0x10000000) {
            this.writeByte((byte)(n4 | 0x1F));
            this.writeByte((byte)(n3 >> 21 | 0x80));
            this.writeByte((byte)(n3 >> 14 | 0x80));
            this.writeByte((byte)(n3 >> 7 | 0x80));
            this.writeByte((byte)(n3 & 0x7F));
        } else {
            this.writeByte((byte)(n4 | 0x1F));
            this.writeByte((byte)(n3 >> 28 | 0x80));
            this.writeByte((byte)(n3 >> 21 | 0x80));
            this.writeByte((byte)(n3 >> 14 | 0x80));
            this.writeByte((byte)(n3 >> 7 | 0x80));
            this.writeByte((byte)(n3 & 0x7F));
        }
        if (bl) {
            this.writeByte((byte)-128);
        } else if (n2 < 128) {
            this.writeByte((byte)n2);
        } else if (n2 < 256) {
            this.writeByte((byte)-127);
            this.writeByte((byte)n2);
        } else if (n2 < 65536) {
            this.writeByte((byte)-126);
            this.writeByte((byte)(n2 >> 8));
            this.writeByte((byte)n2);
        } else if (n2 < 0x1000000) {
            this.writeByte((byte)-125);
            this.writeByte((byte)(n2 >> 16));
            this.writeByte((byte)(n2 >> 8));
            this.writeByte((byte)n2);
        } else {
            this.writeByte((byte)-124);
            this.writeByte((byte)(n2 >> 24));
            this.writeByte((byte)(n2 >> 16));
            this.writeByte((byte)(n2 >> 8));
            this.writeByte((byte)n2);
        }
    }

    public CEREncoder createExplicitTagEncoder(int n, boolean bl) throws IOException {
        if (bl) {
            this.writeTagLength(n | 0x20000000, 0, true);
            return this.createExtensionClone(this, true);
        }
        this.currentTag = n | 0x20000000;
        return this.createExtensionClone(new DataEncoder(), false);
    }

    public void writeEndOfContents(CEREncoder cEREncoder) throws IOException {
        if (cEREncoder.isIndefiniteLengthEncoder) {
            this.writeByte((byte)0);
            this.writeByte((byte)0);
        } else {
            BitString bitString = ((DataEncoder)cEREncoder.out).getEncodedData();
            this.writeTagLength(this.currentTag, bitString.octetLength(), false);
            this.writeBits(bitString);
        }
    }

    public abstract CEREncoder createExtensionClone(Encoder var1, boolean var2);

    public void writeNull(Null nullVal, int n) throws IOException {
        this.writeTagLength(n, 0, false);
    }

    public void writeBoolean(boolean bl, int n) throws IOException {
        this.writeTagLength(n, 1, false);
        if (bl) {
            this.writeByte((byte)-1);
        } else {
            this.writeByte((byte)0);
        }
    }

    public void writeIntegerS8(byte by, int n) throws IOException {
        int n2 = CEREncoder.octetLength(by);
        this.writeTagLength(n, n2, false);
        this.writeSInteger(by, n2 * 8);
    }

    public void writeIntegerS16(short s, int n) throws IOException {
        int n2 = CEREncoder.octetLength(s);
        this.writeTagLength(n, n2, false);
        this.writeSInteger(s, n2 * 8);
    }

    public void writeIntegerS32(int n, int n2) throws IOException {
        int n3 = CEREncoder.octetLength(n);
        this.writeTagLength(n2, n3, false);
        this.writeSInteger(n, n3 * 8);
    }

    public void writeIntegerS64(long l, int n) throws IOException {
        int n2 = CEREncoder.octetLength(l);
        this.writeTagLength(n, n2, false);
        this.writeSLong(l, n2 * 8);
    }

    public void writeIntegerSX(BigInteger bigInteger, int n) throws IOException {
        int n2 = CEREncoder.octetLength(bigInteger);
        this.writeTagLength(n, n2, false);
        this.writeSBigInteger(bigInteger, n2 * 8);
    }

    public void writeRealS64(double d, int n) throws IOException, BadValueException {
        BitString bitString = new BitString();
        if (Double.isInfinite(d)) {
            if (d > 0.0) {
                bitString.appendOctet((byte)1);
                bitString.appendOctet((byte)64);
            } else {
                bitString.appendOctet((byte)1);
                bitString.appendOctet((byte)65);
            }
        } else {
            if (Double.isNaN(d)) {
                throw new BadValueException(Double.toString(d));
            }
            if (d != 0.0) {
                long l = Double.doubleToLongBits(d);
                boolean bl = (l & Long.MIN_VALUE) != 0L;
                int n2 = ((int)(l >> 52) & 0x7FF) - 1075;
                long l2 = n2 == 0 ? (l & 0xFFFFFFFFFFFFFL) << 1 : l & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
                while ((l2 & 1L) == 0L) {
                    l2 >>>= 1;
                    ++n2;
                }
                if (n2 >= -128 && n2 <= 127) {
                    bitString.appendOctet((byte)(0x80 | (bl ? 64 : 0)));
                    bitString.appendOctet((byte)n2);
                } else if (n2 >= Short.MIN_VALUE && n2 <= Short.MAX_VALUE) {
                    bitString.appendOctet((byte)(0x80 | (bl ? 64 : 0) | 1));
                    bitString.appendOctet((byte)(n2 >> 8));
                    bitString.appendOctet((byte)n2);
                } else if (n2 >= -8388608 && n2 <= 0x7FFFFF) {
                    bitString.appendOctet((byte)(0x80 | (bl ? 64 : 0) | 2));
                    bitString.appendOctet((byte)(n2 >> 16));
                    bitString.appendOctet((byte)(n2 >> 8));
                    bitString.appendOctet((byte)n2);
                } else {
                    bitString.appendOctet((byte)(0x80 | (bl ? 64 : 0) | 3));
                    bitString.appendOctet((byte)4);
                    bitString.appendOctet((byte)(n2 >> 24));
                    bitString.appendOctet((byte)(n2 >> 16));
                    bitString.appendOctet((byte)(n2 >> 8));
                    bitString.appendOctet((byte)n2);
                }
                if ((l2 & 0xFF00000000000000L) != 0L) {
                    bitString.appendULong(l2, 64);
                } else if ((l2 & 0xFF000000000000L) != 0L) {
                    bitString.appendULong(l2, 56);
                } else if ((l2 & 0xFF0000000000L) != 0L) {
                    bitString.appendULong(l2, 48);
                } else if ((l2 & 0xFF00000000L) != 0L) {
                    bitString.appendULong(l2, 40);
                } else if ((l2 & 0xFF000000L) != 0L) {
                    bitString.appendULong(l2, 32);
                } else if ((l2 & 0xFF0000L) != 0L) {
                    bitString.appendULong(l2, 24);
                } else if ((l2 & 0xFF00L) != 0L) {
                    bitString.appendULong(l2, 16);
                } else {
                    bitString.appendULong(l2, 8);
                }
            }
        }
        int n3 = bitString.octetLength();
        this.writeTagLength(n, n3, false);
        this.writeBits(bitString);
    }

    public void writeBitString(BitString bitString, int n) throws IOException {
        int n2 = bitString.bitLength();
        if ((n2 + 7) / 8 + 1 <= 1000) {
            this.writeTagLength(n, (n2 + 7) / 8 + 1, false);
            this.writeSInteger(-n2 & 7, 8);
            this.writeBits(bitString);
            if ((n2 & 7) != 0) {
                this.writeSInteger(0, -n2 & 7);
            }
        } else {
            CEREncoder cEREncoder = this.createExplicitTagEncoder(n, true);
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n2 - n3 > 7992 ? 7992 : n2 - n3;
                this.writeTagLength(3, (n4 + 7) / 8 + 1, false);
                this.writeSInteger(-n4 & 7, 8);
                this.write(bitString, n3, n4);
                if ((n4 & 7) != 0) {
                    this.writeSInteger(0, -n4 & 7);
                }
                n3 += 7992;
            }
            this.writeEndOfContents(cEREncoder);
        }
    }

    public void writeTrimmedBitString(TrimmedBitString trimmedBitString, int n) throws IOException {
        int n2 = trimmedBitString.bitLength();
        if ((n2 + 7) / 8 + 1 <= 1000) {
            this.writeTagLength(n, (n2 + 7) / 8 + 1, false);
            this.writeSInteger(-n2 & 7, 8);
            this.writeBits(trimmedBitString);
            if ((n2 & 7) != 0) {
                this.writeSInteger(0, -n2 & 7);
            }
        } else {
            CEREncoder cEREncoder = this.createExplicitTagEncoder(n, true);
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n2 - n3 > 7992 ? 7992 : n2 - n3;
                this.writeTagLength(3, (n4 + 7) / 8 + 1, false);
                this.writeSInteger(-n4 & 7, 8);
                this.write(trimmedBitString, n3, n4);
                if ((n4 & 7) != 0) {
                    this.writeSInteger(0, -n4 & 7);
                }
                n3 += 7992;
            }
            this.writeEndOfContents(cEREncoder);
        }
    }

    public void writeOctetString(OctetString octetString, int n) throws IOException {
        int n2 = octetString.octetLength();
        if (n2 <= 1000) {
            this.writeTagLength(n, n2, false);
            this.writeBits(octetString);
        } else {
            CEREncoder cEREncoder = this.createExplicitTagEncoder(n, true);
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n2 - n3 > 1000 ? 1000 : n2 - n3;
                this.writeTagLength(3, n4, false);
                this.write(octetString, n3 * 8, n4 * 8);
                n3 += 1000;
            }
            this.writeEndOfContents(cEREncoder);
        }
    }

    public void writeString8(String string, int n) throws IOException {
        int n2 = string.length();
        BitString bitString = new BitString();
        bitString.appendString16(new String16(string), n2, 8);
        if (n2 <= 1000) {
            this.writeTagLength(n, n2, false);
            this.writeBits(bitString);
        } else {
            CEREncoder cEREncoder = this.createExplicitTagEncoder(n, true);
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n2 - n3 > 1000 ? 1000 : n2 - n3;
                this.writeTagLength(3, n4, false);
                this.write(bitString, n3 * 8, n4 * 8);
                n3 += 1000;
            }
            this.writeEndOfContents(cEREncoder);
        }
    }

    public void writeString16(String string, int n) throws IOException {
        int n2 = string.length();
        BitString bitString = new BitString();
        bitString.appendString16(new String16(string), n2, 16);
        if (n2 <= 500) {
            this.writeTagLength(n, n2 * 2, false);
            this.writeBits(bitString);
        } else {
            CEREncoder cEREncoder = this.createExplicitTagEncoder(n, true);
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n2 - n3 > 500 ? 500 : n2 - n3;
                this.writeTagLength(3, n4 * 2, false);
                this.write(bitString, n3 * 16, n4 * 16);
                n3 += 500;
            }
            this.writeEndOfContents(cEREncoder);
        }
    }

    public void writeString32(String32 string32, int n) throws IOException {
        int n2 = string32.length();
        BitString bitString = new BitString();
        bitString.appendString32(string32, n2, 32);
        if (n2 <= 250) {
            this.writeTagLength(n, n2 * 4, false);
            this.writeBits(bitString);
        } else {
            CEREncoder cEREncoder = this.createExplicitTagEncoder(n, true);
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n2 - n3 > 250 ? 250 : n2 - n3;
                this.writeTagLength(3, n4 * 4, false);
                this.write(bitString, n3 * 32, n4 * 32);
                n3 += 250;
            }
            this.writeEndOfContents(cEREncoder);
        }
    }

    public void writeObjectIdentifier(ObjectIdentifier objectIdentifier, int n) throws IOException {
        BitString bitString = new BitString();
        int n2 = 0;
        while (n2 < objectIdentifier.length()) {
            long l = objectIdentifier.get(n2);
            if (n2 == 0) {
                l = l * 40L + objectIdentifier.get(++n2);
            }
            int n3 = CEREncoder.septetLengthU(l);
            int n4 = 0;
            while (n4 < n3 - 1) {
                bitString.appendULong(l >> 7 * (n3 - n4 - 1) & 0x7FL | 0x80L, 8);
                ++n4;
            }
            bitString.appendULong(l & 0x7FL, 8);
            ++n2;
        }
        this.writeTagLength(n, bitString.bitLength() / 8, false);
        this.writeBits(bitString);
    }

    public void writeExternal(External external, int n) throws IOException, BadValueException {
        CEREncoder cEREncoder = this.createExplicitTagEncoder(n, true);
        Identification identification = external.getIdentification();
        ObjectDescriptor objectDescriptor = external.getDataValueDescriptor();
        DataValue dataValue = external.getDataValue();
        switch (identification.getSelector()) {
            case 3: {
                cEREncoder.writeObjectIdentifier(identification.getContextNegotiationTransferSyntax(), 6);
                cEREncoder.writeIntegerS32(identification.getContextNegotiationPresentationContextId(), 2);
                break;
            }
            case 1: {
                cEREncoder.writeObjectIdentifier(identification.getSyntax(), 6);
                break;
            }
            case 2: {
                cEREncoder.writeIntegerS32(identification.getPresentationContextId(), 2);
                break;
            }
            default: {
                throw new BadValueException();
            }
        }
        if (objectDescriptor != null) {
            cEREncoder.writeString8(objectDescriptor.getValue().toString(), 7);
        }
        switch (dataValue.getSelector()) {
            case 0: {
                CEREncoder cEREncoder2 = cEREncoder.createExplicitTagEncoder(Integer.MIN_VALUE, true);
                cEREncoder2.writeOpen(dataValue.getNotation().getEncoded());
                cEREncoder.writeEndOfContents(cEREncoder2);
                break;
            }
            case 1: {
                if ((dataValue.getEncodedBitString().bitLength() & 7) != 0) {
                    cEREncoder.writeBitString(dataValue.getEncodedBitString(), -2147483646);
                    break;
                }
                cEREncoder.writeOctetString(new OctetString(dataValue.getEncodedBitString()), -2147483647);
                break;
            }
            case 2: {
                cEREncoder.writeOctetString(dataValue.getEncodedOctetString(), -2147483647);
                break;
            }
            default: {
                throw new BadValueException();
            }
        }
        this.writeEndOfContents(cEREncoder);
    }

    public void writeEmbeddedPDV(EmbeddedPDV embeddedPDV, int n) throws IOException, BadValueException {
        throw new InternalError("Encoding of EMBEDDED PDV for CER not implemented yet.");
    }

    public void writeCharacterString(CharacterString characterString, int n) throws IOException, BadValueException {
        throw new InternalError("Encoding of CHARACTER STRING for CER not implemented yet.");
    }

    private static void appendDecimal(int n, StringBuffer stringBuffer, int n2) {
        int n3 = 1;
        int n4 = 0;
        while (n4 < n2) {
            n3 *= 10;
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            stringBuffer.append((char)(n / (n3 /= 10) % 10 + 48));
            ++n4;
        }
    }

    private static String generalizedTimeToString(GeneralizedTime generalizedTime, int n) throws BadValueException {
        StringBuffer stringBuffer = new StringBuffer(23);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = generalizedTime.get(14);
        int n3 = generalizedTime.get(15) / 60000;
        CEREncoder.appendDecimal(generalizedTime.get(1), stringBuffer, 4);
        CEREncoder.appendDecimal(generalizedTime.get(2) + 1, stringBuffer, 2);
        CEREncoder.appendDecimal(generalizedTime.get(5), stringBuffer, 2);
        CEREncoder.appendDecimal(generalizedTime.get(11), stringBuffer, 2);
        if (n3 == 0 && (n & 0xFC0) != 0) {
            bl = true;
            n = n & 0xC0000000 | n >>> 6 & 0x3F;
        } else if (n3 % 60 == 0 && (n & 0x3F000) != 0) {
            bl2 = true;
            n = n & 0xC0000000 | n >>> 12 & 0x3F;
        } else if ((n & 0xFC0000) != 0) {
            bl2 = true;
            n = n & 0xC0000000 | n >>> 18 & 0x3F;
        } else if ((n & 0x3F) != 0) {
            bl4 = true;
            n = n & 0xC0000000 | n & 0x3F;
        } else {
            throw new BadValueException();
        }
        if ((n & 0x3E) != 0) {
            CEREncoder.appendDecimal(generalizedTime.get(12), stringBuffer, 2);
        }
        if ((n & 0x3C) != 0) {
            CEREncoder.appendDecimal(generalizedTime.get(13), stringBuffer, 2);
        }
        if ((n & 0x38) != 0 && n2 != 0 || (n & 7) == 0) {
            if ((n & 0x40000000) != 0) {
                stringBuffer.append('.');
            } else {
                stringBuffer.append(',');
            }
            if ((n & 8) != 0 && n2 % 100 == 0 || (n & 0x30) == 0) {
                CEREncoder.appendDecimal(n2 / 100, stringBuffer, 1);
            } else if ((n & 0x10) != 0 && n2 % 10 == 0 || (n & 0x20) == 0) {
                CEREncoder.appendDecimal(n2 / 10, stringBuffer, 2);
            } else {
                CEREncoder.appendDecimal(n2, stringBuffer, 3);
            }
        }
        if (bl) {
            stringBuffer.append('Z');
        } else if (bl2 && n3 >= 0) {
            stringBuffer.append('+');
            CEREncoder.appendDecimal(n3 / 60, stringBuffer, 2);
        } else if (bl2) {
            stringBuffer.append('-');
            CEREncoder.appendDecimal(-n3 / 60, stringBuffer, 2);
        } else if (bl3 && n3 >= 0) {
            stringBuffer.append('+');
            CEREncoder.appendDecimal(n3 / 60, stringBuffer, 2);
            CEREncoder.appendDecimal(n3 % 60, stringBuffer, 2);
        } else if (bl3) {
            stringBuffer.append('-');
            CEREncoder.appendDecimal(-n3 / 60, stringBuffer, 2);
            CEREncoder.appendDecimal(-n3 % 60, stringBuffer, 2);
        }
        return stringBuffer.toString();
    }

    public void writeGeneralizedTime(GeneralizedTime generalizedTime, int n, int n2) throws BadValueException, IOException {
        this.writeString8(CEREncoder.generalizedTimeToString(generalizedTime, n2), n);
    }

    private static String utcTimeToString(UTCTime uTCTime, int n) throws BadValueException {
        StringBuffer stringBuffer = new StringBuffer(17);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = uTCTime.get(15) / 60000;
        CEREncoder.appendDecimal(uTCTime.get(1) % 100, stringBuffer, 2);
        CEREncoder.appendDecimal(uTCTime.get(2) + 1, stringBuffer, 2);
        CEREncoder.appendDecimal(uTCTime.get(5), stringBuffer, 2);
        CEREncoder.appendDecimal(uTCTime.get(11), stringBuffer, 2);
        CEREncoder.appendDecimal(uTCTime.get(12), stringBuffer, 2);
        if (n2 == 0 && (n & 0xFC0) != 0) {
            bl = true;
            n = n >>> 6 & 0x3F;
        } else if (n2 % 60 == 0 && (n & 0x3F000) != 0) {
            bl2 = true;
            n = n >>> 12 & 0x3F;
        } else if ((n & 0xFC0000) != 0) {
            bl2 = true;
            n = n >>> 18 & 0x3F;
        } else if ((n & 0x3F) != 0) {
            bl4 = true;
            n &= 0x3F;
        } else {
            throw new BadValueException();
        }
        if ((n & 0x3C) != 0) {
            CEREncoder.appendDecimal(uTCTime.get(13), stringBuffer, 2);
        }
        if (bl) {
            stringBuffer.append('Z');
        } else if (bl2 && n2 >= 0) {
            stringBuffer.append('+');
            CEREncoder.appendDecimal(n2 / 60, stringBuffer, 2);
        } else if (bl2) {
            stringBuffer.append('-');
            CEREncoder.appendDecimal(-n2 / 60, stringBuffer, 2);
        } else if (bl3 && n2 >= 0) {
            stringBuffer.append('+');
            CEREncoder.appendDecimal(n2 / 60, stringBuffer, 2);
            CEREncoder.appendDecimal(n2 % 60, stringBuffer, 2);
        } else if (bl3) {
            stringBuffer.append('-');
            CEREncoder.appendDecimal(-n2 / 60, stringBuffer, 2);
            CEREncoder.appendDecimal(-n2 % 60, stringBuffer, 2);
        }
        return stringBuffer.toString();
    }

    public void writeUTCTime(UTCTime uTCTime, int n, int n2) throws BadValueException, IOException {
        this.writeString8(CEREncoder.utcTimeToString(uTCTime, n2), n);
    }

    public void writeOpen(UnitString unitString) throws IOException {
        this.writeBits(unitString);
    }

    public void writeOpaque(BitString bitString) throws IOException {
        this.writeBits(bitString);
    }

    protected static int octetLength(byte by) {
        return 1;
    }

    protected static int octetLength(short s) {
        if (s >= -128 && s <= 127) {
            return 1;
        }
        return 2;
    }

    protected static int octetLength(int n) {
        if (n >= Short.MIN_VALUE && n <= Short.MAX_VALUE) {
            if (n >= -128 && n <= 127) {
                return 1;
            }
            return 2;
        }
        if (n >= -8388608 && n <= 0x7FFFFF) {
            return 3;
        }
        return 4;
    }

    protected static int octetLength(long l) {
        if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
            if (l >= -32768L && l <= 32767L) {
                if (l >= -128L && l <= 127L) {
                    return 1;
                }
                return 2;
            }
            if (l >= -8388608L && l <= 0x7FFFFFL) {
                return 3;
            }
            return 4;
        }
        if (l >= -140737488355328L && l <= 0x7FFFFFFFFFFFL) {
            if (l >= -549755813888L && l <= 0x7FFFFFFFFFL) {
                return 5;
            }
            return 6;
        }
        if (l >= -36028797018963968L && l <= 0x7FFFFFFFFFFFFFL) {
            return 7;
        }
        return 8;
    }

    protected static int octetLength(BigInteger bigInteger) {
        int n = bigInteger.bitLength();
        return n / 8 + 1;
    }

    protected static int septetLengthU(long l) {
        if (l <= 127L) {
            return 1;
        }
        if (l <= 16383L) {
            return 2;
        }
        if (l <= 0x1FFFFFL) {
            return 3;
        }
        if (l <= 0xFFFFFFFL) {
            return 4;
        }
        if (l <= 0x7FFFFFFFFL) {
            return 5;
        }
        if (l <= 0x3FFFFFFFFFFL) {
            return 6;
        }
        if (l <= 0x1FFFFFFFFFFFFL) {
            return 7;
        }
        if (l <= 0xFFFFFFFFFFFFFFL) {
            return 8;
        }
        return 9;
    }
}

