/*
 * Decompiled with CFR 0.152.
 */
package com.asn1c.codec;

import com.asn1c.codec.BaseTypeFactory;
import com.asn1c.codec.DataDecoder;
import com.asn1c.codec.Decoder;
import com.asn1c.codec.Factory;
import com.asn1c.codec.FactoryMap;
import com.asn1c.codec.FilterDecoder;
import com.asn1c.codec.License;
import com.asn1c.core.BadDataException;
import com.asn1c.core.BitString;
import com.asn1c.core.CharacterString;
import com.asn1c.core.DataValue;
import com.asn1c.core.EmbeddedPDV;
import com.asn1c.core.External;
import com.asn1c.core.GeneralizedTime;
import com.asn1c.core.Identification;
import com.asn1c.core.Null;
import com.asn1c.core.ObjectDescriptor;
import com.asn1c.core.ObjectIdentifier;
import com.asn1c.core.OctetString;
import com.asn1c.core.Open;
import com.asn1c.core.Real64;
import com.asn1c.core.String32;
import com.asn1c.core.String32Buffer;
import com.asn1c.core.TrimmedBitString;
import com.asn1c.core.UTCTime;
import com.asn1c.core.ValueTooLargeException;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public abstract class DERDecoder
extends FilterDecoder {
    private Vector embeddedPdvIdentificationCache;
    private Vector characterStringIdentificationCache;
    private HashMap decoderMap;
    private FactoryMap factoryMap;
    protected BaseTypeFactory baseTypeFactory;
    private boolean isIndefiniteLengthDecoder;
    private boolean tagLengthCached = false;
    private int currentTag;
    private int currentLength;
    private boolean currentIndefiniteLength;
    private byte[] currentTagLengthOctets = new byte[16];
    private int currentTagLengthLength;
    private static int done = -1;
    private static final int[] tab = new int[]{0, 1996959894, -301047508, -1727442502, 124634137, 1886057615, -379345611, -1637575261, 249268274, 2044508324, -522852066, -1747789432, 162941995, 2125561021, -407360249, -1866523247, 498536548, 1789927666, -205950648, -2067906082, 450548861, 1843258603, -187386543, -2083289657, 325883990, 1684777152, -43845254, -1973040660, 335633487, 1661365465, -99664541, -1928851979, 997073096, 1281953886, -715111964, -1570279054, 1006888145, 1258607687, -770865667, -1526024853, 901097722, 1119000684, -608450090, -1396901568, 853044451, 1172266101, -589951537, -1412350631, 651767980, 1373503546, -925412992, -1076862698, 565507253, 1454621731, -809855591, -1195530993, 671266974, 1594198024, -972236366, -1324619484, 795835527, 1483230225, -1050600021, -1234817731, 1994146192, 31158534, -1731059524, -271249366, 1907459465, 112637215, -1614814043, -390540237, 2013776290, 251722036, -1777751922, -519137256, 2137656763, 141376813, -1855689577, -429695999, 1802195444, 476864866, -2056965928, -228458418, 1812370925, 453092731, -2113342271, -183516073, 1706088902, 314042704, -1950435094, -54949764, 1658658271, 366619977, -1932296973, -69972891, 1303535960, 984961486, -1547960204, -725929758, 1256170817, 1037604311, -1529756563, -740887301, 1131014506, 879679996, -1385723834, -631195440, 1141124467, 855842277, -1442165665, -586318647, 1342533948, 654459306, -1106571248, -921952122, 1466479909, 544179635, -1184443383, -832445281, 1591671054, 702138776, -1328506846, -942167884, 1504918807, 783551873, -1212326853, -1061524307, -306674912, -1698712650, 62317068, 1957810842, -355121351, -1647151185, 81470997, 1943803523, -480048366, -1805370492, 225274430, 2053790376, -468791541, -1828061283, 167816743, 2097651377, -267414716, -2029476910, 503444072, 1762050814, -144550051, -2140837941, 426522225, 1852507879, -19653770, -1982649376, 282753626, 1742555852, -105259153, -1900089351, 397917763, 1622183637, -690576408, -1580100738, 953729732, 1340076626, -776247311, -1497606297, 1068828381, 1219638859, -670225446, -1358292148, 906185462, 1090812512, -547295293, -1469587627, 829329135, 1181335161, -882789492, -1134132454, 628085408, 1382605366, -871598187, -1156888829, 570562233, 1426400815, -977650754, -1296233688, 733239954, 1555261956, -1026031705, -1244606671, 752459403, 1541320221, -1687895376, -328994266, 1969922972, 40735498, -1677130071, -351390145, 1913087877, 83908371, -1782625662, -491226604, 2075208622, 213261112, -1831694693, -438977011, 2094854071, 198958881, -2032938284, -237706686, 1759359992, 534414190, -2118248755, -155638181, 1873836001, 414664567, -2012718362, -15766928, 1711684554, 285281116, -1889165569, -127750551, 1634467795, 376229701, -1609899400, -686959890, 1308918612, 956543938, -1486412191, -799009033, 1231636301, 1047427035, -1362007478, -640263460, 1088359270, 936918000, -1447252397, -558129467, 1202900863, 817233897, -1111625188, -893730166, 1404277552, 615818150, -1160759803, -841546093, 1423857449, 601450431, -1285129682, -1000256840, 1567103746, 711928724, -1274298825, -1022587231, 1510334235, 755167117};

    public DERDecoder(Decoder decoder, String string, FactoryMap factoryMap, byte[] byArray) {
        super(decoder);
        if (done == -1) {
            DERDecoder.examine(byArray);
        }
        this.embeddedPdvIdentificationCache = new Vector();
        this.characterStringIdentificationCache = new Vector();
        this.factoryMap = factoryMap == null ? new FactoryMap() : factoryMap;
        this.baseTypeFactory = (BaseTypeFactory)this.factoryMap.get(null);
        if (this.baseTypeFactory == null) {
            this.baseTypeFactory = new BaseTypeFactory();
        }
        this.decoderMap = new HashMap();
        this.decoderMap.put(string, this);
        this.isIndefiniteLengthDecoder = false;
    }

    protected DERDecoder(Decoder decoder, DERDecoder dERDecoder, boolean bl) {
        super(decoder);
        if (done == -1) {
            throw new InternalError();
        }
        this.embeddedPdvIdentificationCache = new Vector();
        this.characterStringIdentificationCache = new Vector();
        this.decoderMap = dERDecoder.decoderMap;
        this.factoryMap = dERDecoder.factoryMap;
        this.baseTypeFactory = dERDecoder.baseTypeFactory;
        this.isIndefiniteLengthDecoder = bl;
    }

    protected Factory getFactory(String string) {
        return this.factoryMap.get(string);
    }

    private static final void examine(byte[] byArray) {
        done = 0;
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length - 4) {
            n = tab[(n ^ byArray[n2]) & 0xFF] ^ n >>> 8;
            ++n2;
        }
        if (n != ((byArray[n2] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF)) {
            return;
        }
        n = 0;
        n2 = 0;
        while (n2 < License.data.length - 4) {
            n = tab[(n ^ License.data[n2]) & 0xFF] ^ n >>> 8;
            ++n2;
        }
        if (n != ((License.data[n2] & 0xFF) << 24 | (License.data[n2 + 1] & 0xFF) << 16 | (License.data[n2 + 2] & 0xFF) << 8 | License.data[n2 + 3] & 0xFF)) {
            return;
        }
        done = 1;
    }

    protected FactoryMap getFactoryMap() {
        return this.factoryMap;
    }

    protected DERDecoder getDecoder(String string) {
        return (DERDecoder)this.decoderMap.get(string);
    }

    public void startup() {
        Collection collection = this.decoderMap.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            DERDecoder dERDecoder = (DERDecoder)iterator.next();
            dERDecoder.tagLengthCached = false;
        }
    }

    public void readTagLength() throws BadDataException, IOException {
        if (this.tagLengthCached) {
            return;
        }
        this.currentTagLengthLength = 0;
        int n = this.readUInteger(8);
        this.currentTagLengthOctets[this.currentTagLengthLength++] = (byte)n;
        int n2 = n & 0xE0;
        int n3 = n & 0x1F;
        if (n3 == 31) {
            n3 = 0;
            do {
                n = this.readUInteger(8);
                this.currentTagLengthOctets[this.currentTagLengthLength++] = (byte)n;
                if ((n3 & 0xE0000000) != 0) {
                    throw new BadDataException();
                }
                n3 = n3 << 7 | n & 0x7F;
            } while ((n & 0xFFFFFF80) != 0);
        }
        this.currentTag = n2 << 24 | n3;
        n = this.readUInteger(8);
        this.currentTagLengthOctets[this.currentTagLengthLength++] = (byte)n;
        if (n < 128) {
            this.currentLength = n;
            this.currentIndefiniteLength = false;
        } else if (n == 128 && (this.currentTag & 0x20000000) != 0) {
            this.currentLength = 0;
            this.currentIndefiniteLength = true;
        } else if (n >= 129 && n <= 132) {
            try {
                this.currentLength = this.readUInteger((n - 128) * 8);
            }
            catch (ValueTooLargeException valueTooLargeException) {
                throw new BadDataException();
            }
            this.currentIndefiniteLength = false;
            switch (n) {
                case -124: {
                    this.currentTagLengthOctets[this.currentTagLengthLength++] = (byte)(this.currentLength >> 24);
                }
                case -125: {
                    this.currentTagLengthOctets[this.currentTagLengthLength++] = (byte)(this.currentLength >> 16);
                }
                case -126: {
                    this.currentTagLengthOctets[this.currentTagLengthLength++] = (byte)(this.currentLength >> 8);
                }
                case -127: {
                    this.currentTagLengthOctets[this.currentTagLengthLength++] = (byte)this.currentLength;
                }
            }
        } else {
            throw new BadDataException();
        }
        this.tagLengthCached = true;
        if (done != 1) {
            n3 = 0;
        }
    }

    protected void checkTag(int n, boolean bl) throws BadDataException, IOException {
        this.readTagLength();
        if (bl ? this.currentTag != n : (this.currentTag & 0xDFFFFFFF) != (n & 0xDFFFFFFF)) {
            throw new BadDataException();
        }
    }

    public int peekTag() throws BadDataException, IOException {
        if (this.notEndOfContents()) {
            this.readTagLength();
            return this.currentTag & 0xDFFFFFFF;
        }
        return 0;
    }

    public DERDecoder createExplicitTagDecoder(int n) throws BadDataException, IOException {
        this.checkTag(n | 0x20000000, true);
        if (this.currentIndefiniteLength) {
            return this.createExtensionClone(this, true);
        }
        BitString bitString = this.readBits(this.currentLength * 8);
        return this.createExtensionClone(new DataDecoder(bitString), false);
    }

    public void readEndOfContents(DERDecoder dERDecoder) throws BadDataException, IOException {
        if (dERDecoder.isIndefiniteLengthDecoder) {
            dERDecoder.checkTag(0, true);
        } else {
            dERDecoder.flushIn();
        }
        this.tagLengthCached = false;
    }

    public abstract DERDecoder createExtensionClone(Decoder var1, boolean var2);

    public boolean notEndOfContents() throws BadDataException, IOException {
        if (this.isIndefiniteLengthDecoder) {
            this.readTagLength();
            return this.currentTag != 0 || this.currentLength != 0;
        }
        return !this.checkEndOfData();
    }

    public void skip() throws BadDataException, IOException {
        this.readTagLength();
        super.skip(this.currentLength * 8);
        this.tagLengthCached = false;
    }

    public Null readNull(int n) throws BadDataException, IOException {
        this.checkTag(n, true);
        if (this.currentLength != 0) {
            throw new BadDataException();
        }
        this.tagLengthCached = false;
        return Null.NULL;
    }

    public boolean readBoolean(int n) throws BadDataException, IOException {
        this.checkTag(n, true);
        if (this.currentLength != 1) {
            throw new BadDataException();
        }
        byte by = (byte)this.readSInteger(8);
        this.tagLengthCached = false;
        return by != 0;
    }

    public byte readIntegerS8(int n) throws BadDataException, IOException, ValueTooLargeException {
        this.checkTag(n, true);
        this.tagLengthCached = false;
        return (byte)this.readSInteger(this.currentLength * 8);
    }

    public short readIntegerS16(int n) throws BadDataException, IOException, ValueTooLargeException {
        this.checkTag(n, true);
        this.tagLengthCached = false;
        return (short)this.readSInteger(this.currentLength * 8);
    }

    public int readIntegerS32(int n) throws BadDataException, IOException, ValueTooLargeException {
        this.checkTag(n, true);
        this.tagLengthCached = false;
        return this.readSInteger(this.currentLength * 8);
    }

    public long readIntegerS64(int n) throws BadDataException, IOException, ValueTooLargeException {
        this.checkTag(n, true);
        this.tagLengthCached = false;
        return this.readSLong(this.currentLength * 8);
    }

    public BigInteger readIntegerSX(int n) throws BadDataException, IOException {
        this.checkTag(n, true);
        this.tagLengthCached = false;
        return this.readSBigInteger(this.currentLength * 8);
    }

    public double readRealS64(int n) throws BadDataException, IOException, ValueTooLargeException {
        this.checkTag(n, true);
        this.tagLengthCached = false;
        BitString bitString = this.readBits(this.currentLength * 8);
        if (bitString.bitLength() == 0) {
            return 0.0;
        }
        if (bitString.getBit(0)) {
            int n2;
            int n3;
            int n4;
            boolean bl = bitString.getBit(1);
            if (bitString.getBit(2)) {
                if (bitString.getBit(3)) {
                    throw new BadDataException();
                }
                n4 = 4;
            } else {
                n4 = bitString.getBit(3) ? 3 : 1;
            }
            int n5 = bitString.getUInteger(4, 2);
            if (bitString.getBit(6)) {
                if (bitString.getBit(7)) {
                    int n6 = bitString.getUInteger(8, 8);
                    n3 = bitString.getSInteger(16, (n6 + 1) * 8);
                    n2 = 24 + n6 * 8;
                } else {
                    n3 = bitString.getSInteger(8, 24);
                    n2 = 32;
                }
            } else if (bitString.getBit(7)) {
                n3 = bitString.getSInteger(8, 16);
                n2 = 24;
            } else {
                n3 = bitString.getSInteger(8, 8);
                n2 = 16;
            }
            n3 = n3 * n4 + n5;
            return bl ? (double)(-bitString.getULong(n2, bitString.bitLength() - n2)) * Math.pow(2.0, n3) : (double)bitString.getULong(n2, bitString.bitLength() - n2) * Math.pow(2.0, n3);
        }
        if (bitString.getBit(1)) {
            if (bitString.bitLength() != 8) {
                throw new BadDataException();
            }
            switch (bitString.getUInteger(2, 6)) {
                case 0: {
                    return Double.POSITIVE_INFINITY;
                }
                case 1: {
                    return Double.NEGATIVE_INFINITY;
                }
            }
            throw new BadDataException();
        }
        String string = bitString.getString(8, bitString.bitLength() / 8 - 1, 8);
        string = string.replace(',', '.');
        try {
            return Real64.valueOf(string).doubleValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw new BadDataException();
        }
    }

    public BitString readBitString(int n) throws BadDataException, IOException {
        this.readTagLength();
        if ((this.currentTag & 0x20000000) != 0) {
            DERDecoder dERDecoder = this.createExplicitTagDecoder(n);
            this.tagLengthCached = false;
            BitString bitString = new BitString();
            while (dERDecoder.notEndOfContents()) {
                bitString.append(dERDecoder.readBitString(3));
            }
            this.readEndOfContents(dERDecoder);
            return bitString;
        }
        this.checkTag(n, true);
        this.tagLengthCached = false;
        byte by = (byte)this.readSInteger(8);
        if (by < 0 || by > 7) {
            throw new BadDataException();
        }
        BitString bitString = this.readBits(this.currentLength * 8 - by - 8);
        super.skip(by);
        return bitString;
    }

    public TrimmedBitString readTrimmedBitString(int n) throws BadDataException, IOException {
        return new TrimmedBitString(this.readBitString(n));
    }

    public OctetString readOctetString(int n) throws BadDataException, IOException {
        this.readTagLength();
        if ((this.currentTag & 0x20000000) != 0) {
            DERDecoder dERDecoder = this.createExplicitTagDecoder(n);
            this.tagLengthCached = false;
            OctetString octetString = new OctetString();
            while (dERDecoder.notEndOfContents()) {
                octetString.append(dERDecoder.readOctetString(4));
            }
            this.readEndOfContents(dERDecoder);
            return octetString;
        }
        this.checkTag(n, true);
        this.tagLengthCached = false;
        BitString bitString = this.readBits(this.currentLength * 8);
        return bitString.getOctets(0, this.currentLength);
    }

    public String readString8(int n) throws BadDataException, IOException {
        this.readTagLength();
        if ((this.currentTag & 0x20000000) != 0) {
            DERDecoder dERDecoder = this.createExplicitTagDecoder(n);
            this.tagLengthCached = false;
            StringBuffer stringBuffer = new StringBuffer();
            while (dERDecoder.notEndOfContents()) {
                stringBuffer.append(dERDecoder.readString8(4));
            }
            this.readEndOfContents(dERDecoder);
            return stringBuffer.toString();
        }
        this.checkTag(n, true);
        this.tagLengthCached = false;
        BitString bitString = this.readBits(this.currentLength * 8);
        return bitString.getString(0, bitString.bitLength() / 8, 8);
    }

    public String readString16(int n) throws BadDataException, IOException {
        this.readTagLength();
        if ((this.currentTag & 0x20000000) != 0) {
            DERDecoder dERDecoder = this.createExplicitTagDecoder(n);
            this.tagLengthCached = false;
            StringBuffer stringBuffer = new StringBuffer();
            while (dERDecoder.notEndOfContents()) {
                stringBuffer.append(dERDecoder.readString16(4));
            }
            this.readEndOfContents(dERDecoder);
            return stringBuffer.toString();
        }
        this.checkTag(n, true);
        this.tagLengthCached = false;
        BitString bitString = this.readBits(this.currentLength * 8);
        return bitString.getString(0, bitString.bitLength() / 16, 16);
    }

    public String32 readString32(int n) throws BadDataException, IOException {
        this.readTagLength();
        if ((this.currentTag & 0x20000000) != 0) {
            DERDecoder dERDecoder = this.createExplicitTagDecoder(n);
            this.tagLengthCached = false;
            String32Buffer string32Buffer = new String32Buffer();
            while (dERDecoder.notEndOfContents()) {
                string32Buffer.append(dERDecoder.readString32(4));
            }
            this.readEndOfContents(dERDecoder);
            return new String32(string32Buffer);
        }
        this.checkTag(n, true);
        this.tagLengthCached = false;
        BitString bitString = this.readBits(this.currentLength * 8);
        return bitString.getString32(0, bitString.bitLength() / 32, 32);
    }

    public ObjectIdentifier readObjectIdentifier(int n) throws BadDataException, IOException, ValueTooLargeException {
        this.checkTag(n, true);
        this.tagLengthCached = false;
        BitString bitString = this.readBits(this.currentLength * 8);
        int n2 = bitString.bitLength();
        int n3 = 0;
        ObjectIdentifier objectIdentifier = new ObjectIdentifier();
        int n4 = 0;
        while (n3 < n2) {
            long l = 0L;
            do {
                if (n3 >= n2) {
                    throw new BadDataException();
                }
                if (l > 0xFFFFFFFFFFFFFFL) {
                    throw new ValueTooLargeException();
                }
                l = l << 7 | (long)bitString.getUInteger(n3 + 1, 7);
            } while (bitString.getBit((n3 += 8) - 8));
            if (n4 == 0) {
                if (l < 80L) {
                    objectIdentifier.set(n4++, l / 40L);
                    objectIdentifier.set(n4++, l % 40L);
                    continue;
                }
                objectIdentifier.set(n4++, 2L);
                objectIdentifier.set(n4++, l - 80L);
                continue;
            }
            objectIdentifier.set(n4++, l);
        }
        return objectIdentifier;
    }

    public External readExternal(int n) throws BadDataException, IOException, ValueTooLargeException {
        DataValue dataValue;
        Identification identification;
        DERDecoder dERDecoder = this.createExplicitTagDecoder(n);
        dERDecoder.readTagLength();
        if (dERDecoder.currentTag == 6) {
            ObjectIdentifier objectIdentifier = dERDecoder.readObjectIdentifier(6);
            dERDecoder.readTagLength();
            if (dERDecoder.currentTag == 2) {
                int n2 = dERDecoder.readIntegerS32(2);
                identification = new Identification(3, n2, objectIdentifier);
            } else {
                identification = new Identification(1, objectIdentifier);
            }
        } else if (dERDecoder.currentTag == 2) {
            int n3 = dERDecoder.readIntegerS32(2);
            identification = new Identification(2, n3);
        } else {
            throw new BadDataException();
        }
        dERDecoder.readTagLength();
        ObjectDescriptor objectDescriptor = dERDecoder.currentTag == 7 ? new ObjectDescriptor(dERDecoder.readString8(7)) : null;
        dERDecoder.readTagLength();
        switch (dERDecoder.currentTag & 0xDFFFFFFF) {
            case -2147483648: {
                DERDecoder dERDecoder2 = dERDecoder.createExplicitTagDecoder(Integer.MIN_VALUE);
                Open open = new Open(dERDecoder2.readOpen());
                dERDecoder.readEndOfContents(dERDecoder2);
                dataValue = new DataValue(0, open);
                break;
            }
            case -2147483647: {
                OctetString octetString = dERDecoder.readOctetString(-2147483647);
                dataValue = new DataValue(1, new BitString(octetString));
                break;
            }
            case -2147483646: {
                BitString bitString = dERDecoder.readBitString(-2147483646);
                dataValue = new DataValue(1, bitString);
                break;
            }
            default: {
                throw new BadDataException();
            }
        }
        this.readEndOfContents(dERDecoder);
        return new External(identification, objectDescriptor, dataValue);
    }

    public EmbeddedPDV readEmbeddedPDV(int n) throws BadDataException, IOException {
        throw new InternalError("Decoding of EMBEDDED PDV for DER not implemented yet.");
    }

    public CharacterString readCharacterString(int n) throws BadDataException, IOException {
        throw new InternalError("Decoding of CHARACTER STRING for DER not implemented yet.");
    }

    private static int parseDecimal(String string) throws BadDataException, IOException {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            if (c < '0' || c > '9') {
                throw new BadDataException();
            }
            n2 = 10 * n2 + (c - 48);
            ++n3;
        }
        return n2;
    }

    private static double parseFraction(String string) throws BadDataException, IOException {
        int n = string.length();
        double d = 0.0;
        int n2 = n;
        while (n2-- > 0) {
            char c = string.charAt(n2);
            if (c < '0' || c > '9') {
                throw new BadDataException();
            }
            d = (d + (double)(c - 48)) / 10.0;
        }
        return d;
    }

    public GeneralizedTime stringToGeneralizedTime(String string, int n) throws IOException, EOFException, BadDataException {
        char c;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = string.length();
        if (string.length() < 10) {
            throw new BadDataException();
        }
        int n7 = DERDecoder.parseDecimal(string.substring(0, 4));
        int n8 = DERDecoder.parseDecimal(string.substring(4, 6)) - 1;
        int n9 = DERDecoder.parseDecimal(string.substring(6, 8));
        int n10 = DERDecoder.parseDecimal(string.substring(8, 10));
        if (n6 > 11) {
            c = string.charAt(10);
            if (c == '.' || c == ',') {
                int n11 = 11;
                while (n11 < n6) {
                    if (string.charAt(n11) < '0' || string.charAt(n11) > '9') break;
                    ++n11;
                }
                double d = DERDecoder.parseFraction(string.substring(11, n11));
                n2 = (int)(d *= 60.0);
                n3 = (int)(d *= 60.0);
                n4 = (int)(d *= 1000.0);
                string = string.substring(n11);
                n6 -= n11;
            } else if (c >= '0' && c <= '9') {
                n2 = DERDecoder.parseDecimal(string.substring(10, 12));
                if (n6 > 13) {
                    c = string.charAt(12);
                    if (c == '.' || c == ',') {
                        int n12 = 13;
                        while (n12 < n6) {
                            if (string.charAt(n12) < '0' || string.charAt(n12) > '9') break;
                            ++n12;
                        }
                        double d = DERDecoder.parseFraction(string.substring(13, n12));
                        n3 = (int)(d *= 60.0);
                        n4 = (int)(d *= 1000.0);
                        string = string.substring(n12);
                        n6 -= n12;
                    } else if (c >= '0' && c <= '9') {
                        n3 = DERDecoder.parseDecimal(string.substring(12, 14));
                        if (n6 > 15) {
                            c = string.charAt(14);
                            if (c == '.' || c == ',') {
                                int n13 = 15;
                                while (n13 < n6) {
                                    if (string.charAt(n13) < '0' || string.charAt(n13) > '9') break;
                                    ++n13;
                                }
                                double d = DERDecoder.parseFraction(string.substring(15, n13));
                                n4 = (int)(d *= 1000.0);
                                string = string.substring(n13);
                                n6 -= n13;
                            } else {
                                string = string.substring(14);
                                n6 -= 14;
                            }
                        } else {
                            string = string.substring(14);
                            n6 -= 14;
                        }
                    } else {
                        string = string.substring(12);
                        n6 -= 12;
                    }
                } else {
                    string = string.substring(12);
                    n6 -= 12;
                }
            } else {
                string = string.substring(10);
                n6 -= 10;
            }
        } else {
            string = string.substring(10);
            n6 -= 10;
        }
        if (n6 > 0) {
            c = string.charAt(0);
            if (c == 'Z') {
                if (n6 != 1) {
                    throw new BadDataException();
                }
                return new GeneralizedTime(n7, n8, n9, n10, n2, n3, n4, true);
            }
            if (n6 != 3 && n6 != 5 || c != '+' && c != '-') {
                throw new BadDataException();
            }
            int n14 = DERDecoder.parseDecimal(string.substring(1, 3));
            if (n6 == 5) {
                n5 = DERDecoder.parseDecimal(string.substring(3, 5));
            }
            if (c == '-') {
                n14 = -n14;
                n5 = -n5;
            }
            return new GeneralizedTime(n7, n8, n9, n10, n2, n3, n4, (n14 * 60 + n5) * 60000);
        }
        return new GeneralizedTime(n7, n8, n9, n10, n2, n3, n4);
    }

    public GeneralizedTime readGeneralizedTime(int n, int n2) throws BadDataException, IOException {
        String string = this.readString8(n);
        return this.stringToGeneralizedTime(string, n2);
    }

    public UTCTime stringToUTCTime(String string, int n) throws IOException, EOFException, BadDataException {
        char c;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        if (string.length() < 10) {
            throw new BadDataException();
        }
        int n5 = DERDecoder.parseDecimal(string.substring(0, 2));
        int n6 = DERDecoder.parseDecimal(string.substring(2, 4)) - 1;
        int n7 = DERDecoder.parseDecimal(string.substring(4, 6));
        int n8 = DERDecoder.parseDecimal(string.substring(6, 8));
        int n9 = DERDecoder.parseDecimal(string.substring(8, 10));
        if (n4 > 11) {
            c = string.charAt(10);
            if (c >= '0' && c <= '9') {
                n2 = DERDecoder.parseDecimal(string.substring(10, 12));
                string = string.substring(12);
                n4 -= 12;
            } else {
                string = string.substring(10);
                n4 -= 10;
            }
        } else {
            string = string.substring(10);
            n4 -= 10;
        }
        if (n4 > 0) {
            c = string.charAt(0);
            if (c == 'Z') {
                if (n4 != 1) {
                    throw new BadDataException();
                }
                return new UTCTime(n5, n6, n7, n8, n9, n2, true);
            }
            if (n4 != 3 && n4 != 5 || c != '+' && c != '-') {
                throw new BadDataException();
            }
            int n10 = DERDecoder.parseDecimal(string.substring(1, 3));
            if (n4 == 5) {
                n3 = DERDecoder.parseDecimal(string.substring(3, 5));
            }
            if (c == '-') {
                n10 = -n10;
                n3 = -n3;
            }
            return new UTCTime(n5, n6, n7, n8, n9, n2, (n10 * 60 + n3) * 60000);
        }
        return new UTCTime(n5, n6, n7, n8, n9, n2);
    }

    public UTCTime readUTCTime(int n, int n2) throws BadDataException, IOException {
        String string = this.readString8(n);
        return this.stringToUTCTime(string, n2);
    }

    public OctetString readOpen() throws BadDataException, IOException {
        this.readTagLength();
        OctetString octetString = new OctetString(this.currentTagLengthOctets, 0, this.currentTagLengthLength);
        if ((this.currentTag & 0x20000000) != 0) {
            DERDecoder dERDecoder = this.createExplicitTagDecoder(this.currentTag);
            this.tagLengthCached = false;
            while (dERDecoder.notEndOfContents()) {
                octetString.append(dERDecoder.readOpen());
            }
            this.readEndOfContents(dERDecoder);
            if (this.isIndefiniteLengthDecoder) {
                octetString.appendOctet((byte)0);
                octetString.appendOctet((byte)0);
            }
            return octetString;
        }
        this.checkTag(this.currentTag, true);
        this.tagLengthCached = false;
        BitString bitString = this.readBits(this.currentLength * 8);
        octetString.append(bitString.getOctets(0, this.currentLength));
        return octetString;
    }

    public void checkMandatoryComponents(TrimmedBitString trimmedBitString, int n) throws BadDataException {
        trimmedBitString.getOnes(0, n);
    }
}

