/*
 * Decompiled with CFR 0.152.
 */
package com.asn1c.codec;

import com.asn1c.codec.Decoder;
import com.asn1c.core.BitString;
import com.asn1c.core.SuperfluousDataException;
import com.asn1c.core.UnitString;
import com.asn1c.core.ValueTooLargeException;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigInteger;

public class DataDecoder
extends Decoder {
    protected UnitString bs;
    protected int len;
    protected int pos;

    public DataDecoder() {
        this.bs = new BitString();
        this.len = 0;
        this.pos = 0;
    }

    public DataDecoder(UnitString unitString) {
        this.bs = unitString;
        this.len = unitString.bitLength();
        this.pos = 0;
    }

    public void setEncodedData(UnitString unitString) {
        this.bs = unitString;
        this.len = unitString.bitLength();
        this.pos = 0;
    }

    public long getBitsRead() {
        return this.pos;
    }

    public void read(BitString bitString, int n, int n2) throws IOException, EOFException {
        if (this.pos + n2 > this.len) {
            throw new EOFException();
        }
        bitString.setBits(this.bs, this.pos, n, n2);
        this.pos += n2;
    }

    public int getBitsToAlignment() {
        return -this.pos & 7;
    }

    public boolean checkEndOfData() {
        return this.pos >= this.len;
    }

    public void flushIn() throws IOException, EOFException, SuperfluousDataException {
        if (this.pos < this.len) {
            throw new SuperfluousDataException();
        }
    }

    public void skip(long l) throws IOException, EOFException {
        if ((long)this.pos + l > (long)this.len) {
            throw new EOFException();
        }
        this.pos = (int)((long)this.pos + l);
    }

    public void close() throws IOException {
    }

    public boolean readBit() throws IOException, EOFException {
        if (this.pos >= this.len) {
            throw new EOFException();
        }
        return this.bs.getBit(this.pos++);
    }

    public BitString readBits(int n) throws IOException, EOFException {
        if (this.pos + n > this.len) {
            throw new EOFException();
        }
        BitString bitString = this.bs.getBits(this.pos, n);
        this.pos += n;
        return bitString;
    }

    public int readSInteger(int n) throws IOException, EOFException, ValueTooLargeException {
        if (this.pos + n > this.len) {
            throw new EOFException();
        }
        int n2 = this.bs.getSInteger(this.pos, n);
        this.pos += n;
        return n2;
    }

    public int readUInteger(int n) throws IOException, EOFException, ValueTooLargeException {
        if (this.pos + n > this.len) {
            throw new EOFException();
        }
        int n2 = this.bs.getUInteger(this.pos, n);
        this.pos += n;
        return n2;
    }

    public long readSLong(int n) throws IOException, EOFException, ValueTooLargeException {
        if (this.pos + n > this.len) {
            throw new EOFException();
        }
        long l = this.bs.getSLong(this.pos, n);
        this.pos += n;
        return l;
    }

    public long readULong(int n) throws IOException, EOFException, ValueTooLargeException {
        if (this.pos + n > this.len) {
            throw new EOFException();
        }
        long l = this.bs.getULong(this.pos, n);
        this.pos += n;
        return l;
    }

    public BigInteger readSBigInteger(int n) throws IOException, EOFException {
        if (this.pos + n > this.len) {
            throw new EOFException();
        }
        BigInteger bigInteger = this.bs.getSBigInteger(this.pos, n);
        this.pos += n;
        return bigInteger;
    }

    public BigInteger readUBigInteger(int n) throws IOException, EOFException {
        if (this.pos + n > this.len) {
            throw new EOFException();
        }
        BigInteger bigInteger = this.bs.getUBigInteger(this.pos, n);
        this.pos += n;
        return bigInteger;
    }
}

