/*
 * Decompiled with CFR 0.152.
 */
package com.asn1c.codec;

import com.asn1c.codec.License;
import com.asn1c.core.BadDataException;
import com.asn1c.core.BitString;
import com.asn1c.core.ValueTooLargeException;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigInteger;

public abstract class Decoder {
    private static final int maxSkipBufferSize = 65536;
    private BitString skipBuffer = null;

    protected Decoder() {
        License.checkLicense();
    }

    public abstract void read(BitString var1, int var2, int var3) throws IOException, EOFException;

    public abstract int getBitsToAlignment();

    public abstract long getBitsRead();

    public abstract boolean checkEndOfData();

    public abstract void flushIn() throws IOException, EOFException, BadDataException;

    public void skip(long l) throws IOException, EOFException {
        if (this.skipBuffer == null) {
            this.skipBuffer = new BitString(65536);
        }
        long l2 = l;
        while (l2 > 0L) {
            this.read(this.skipBuffer, 0, (int)Math.min(65536L, l2));
            l2 -= Math.min(65536L, l2);
        }
    }

    public abstract void close() throws IOException;

    public boolean readBit() throws IOException, EOFException {
        BitString bitString = new BitString(1);
        this.read(bitString, 0, 1);
        return bitString.getBit(0);
    }

    public BitString readBits(int n) throws IOException, EOFException {
        BitString bitString = new BitString(n);
        this.read(bitString, 0, n);
        return bitString;
    }

    public int readSInteger(int n) throws IOException, EOFException, ValueTooLargeException {
        BitString bitString = new BitString(n);
        this.read(bitString, 0, n);
        return bitString.getSInteger(0, n);
    }

    public int readUInteger(int n) throws IOException, EOFException, ValueTooLargeException {
        BitString bitString = new BitString(n);
        this.read(bitString, 0, n);
        return bitString.getUInteger(0, n);
    }

    public long readSLong(int n) throws IOException, EOFException, ValueTooLargeException {
        BitString bitString = new BitString(n);
        this.read(bitString, 0, n);
        return bitString.getSLong(0, n);
    }

    public long readULong(int n) throws IOException, EOFException, ValueTooLargeException {
        BitString bitString = new BitString(n);
        this.read(bitString, 0, n);
        return bitString.getULong(0, n);
    }

    public BigInteger readSBigInteger(int n) throws IOException, EOFException {
        BitString bitString = new BitString(n);
        this.read(bitString, 0, n);
        return bitString.getSBigInteger(0, n);
    }

    public BigInteger readUBigInteger(int n) throws IOException, EOFException {
        BitString bitString = new BitString(n);
        this.read(bitString, 0, n);
        return bitString.getUBigInteger(0, n);
    }
}

