/*
 * Decompiled with CFR 0.152.
 */
package com.asn1c.codec;

import com.asn1c.codec.License;
import com.asn1c.core.BitString;
import com.asn1c.core.UnitString;
import java.io.IOException;
import java.math.BigInteger;

public abstract class Encoder {
    protected Encoder() {
        License.checkLicense();
    }

    public abstract void write(UnitString var1, int var2, int var3) throws IOException;

    public abstract int getBitsToAlignment();

    public abstract long getBitsWritten();

    public abstract void flushOut() throws IOException;

    public abstract void close() throws IOException;

    public void writeBit(boolean bl) throws IOException {
        BitString bitString = new BitString(1);
        bitString.setBit(0, bl);
        this.write(bitString, 0, 1);
    }

    public void writeBits(UnitString unitString) throws IOException {
        this.write(unitString, 0, unitString.bitLength());
    }

    public void writeByte(byte by) throws IOException {
        BitString bitString = new BitString();
        bitString.appendByte(by);
        this.write(bitString, 0, 8);
    }

    public void writeSInteger(int n, int n2) throws IOException {
        BitString bitString = new BitString();
        bitString.appendSInteger(n, n2);
        this.write(bitString, 0, n2);
    }

    public void writeUInteger(int n, int n2) throws IOException {
        BitString bitString = new BitString();
        bitString.appendUInteger(n, n2);
        this.write(bitString, 0, n2);
    }

    public void writeSLong(long l, int n) throws IOException {
        BitString bitString = new BitString();
        bitString.appendSLong(l, n);
        this.write(bitString, 0, n);
    }

    public void writeULong(long l, int n) throws IOException {
        BitString bitString = new BitString();
        bitString.appendULong(l, n);
        this.write(bitString, 0, n);
    }

    public void writeSBigInteger(BigInteger bigInteger, int n) throws IOException {
        BitString bitString = new BitString();
        bitString.appendSBigInteger(bigInteger, n);
        this.write(bitString, 0, n);
    }

    public void writeUBigInteger(BigInteger bigInteger, int n) throws IOException {
        BitString bitString = new BitString();
        bitString.appendUBigInteger(bigInteger, n);
        this.write(bitString, 0, n);
    }
}

