/*
 * Decompiled with CFR 0.152.
 */
package com.asn1c.codec;

import com.asn1c.codec.Decoder;
import com.asn1c.core.BitString;
import com.asn1c.core.SuperfluousDataException;
import com.asn1c.core.ValueTooLargeException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class InputStreamDecoder
extends Decoder {
    protected InputStream in;
    private BitString buffer;
    private int pos;
    private long dropped;
    private byte[] byteBuffer = null;
    private static final int maxByteBufferSize = 8192;
    private static final int maxOffset = 65536;
    private static final int maxSkipBufferSize = 65536;

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("stream closed");
        }
    }

    private void ensureBuffered(int n) throws IOException, EOFException {
        int n2 = this.buffer.bitLength() - this.pos;
        if (n2 >= n) {
            return;
        }
        if (n2 == 0) {
            this.dropped += (long)this.pos;
            this.pos = 0;
            this.buffer.setBitLength(0);
        } else if (this.pos >= 65536) {
            this.buffer.setBits(this.buffer, this.pos & 7, this.pos, n2);
            this.dropped += (long)(this.pos & 0xFFFFFFF8);
            this.pos &= 7;
            this.buffer.setBitLength(this.pos + n2);
        }
        int n3 = n - n2;
        if (this.byteBuffer == null) {
            this.byteBuffer = new byte[8192];
        }
        while (n3 > 0) {
            int n4 = this.in.read(this.byteBuffer, 0, Math.min((n3 + 7) / 8, 8192));
            if (n4 < 0) {
                throw new EOFException();
            }
            this.buffer.appendOctetsFromByteArray(this.byteBuffer, 0, n4);
            n3 -= n4 * 8;
        }
    }

    public InputStreamDecoder(InputStream inputStream) {
        this.in = inputStream;
        this.buffer = new BitString();
        this.pos = 0;
        this.dropped = 0L;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public void setInputStream(InputStream inputStream) {
        this.in = inputStream;
        this.buffer.setBitLength(0);
        this.pos = 0;
        this.dropped = 0L;
    }

    public void read(BitString bitString, int n, int n2) throws IOException, EOFException {
        this.ensureOpen();
        this.ensureBuffered(n2);
        bitString.setBits(this.buffer, this.pos, n, n2);
        this.pos += n2;
    }

    public int getBitsToAlignment() {
        return -this.pos & 7;
    }

    public long getBitsRead() {
        return this.dropped + (long)this.pos;
    }

    public boolean checkEndOfData() {
        return false;
    }

    public void flushIn() throws IOException, EOFException, SuperfluousDataException {
    }

    public void skip(long l) throws IOException, EOFException {
        long l2 = l;
        this.ensureOpen();
        while (l2 > 0L) {
            int n = (int)Math.min(l2, 65536L);
            this.ensureBuffered(n);
            this.pos += n;
            l2 -= (long)n;
        }
    }

    public void close() throws IOException {
        if (this.in == null) {
            return;
        }
        this.in.close();
        this.in = null;
        this.buffer.setBitLength(0);
    }

    public boolean readBit() throws IOException, EOFException {
        this.ensureOpen();
        this.ensureBuffered(1);
        return this.buffer.getBit(this.pos++);
    }

    public BitString readBits(int n) throws IOException, EOFException {
        BitString bitString = new BitString(n);
        this.read(bitString, 0, n);
        return bitString;
    }

    public int readSInteger(int n) throws IOException, EOFException, ValueTooLargeException {
        this.ensureBuffered(n);
        int n2 = this.buffer.getSInteger(this.pos, n);
        this.pos += n;
        return n2;
    }

    public int readUInteger(int n) throws IOException, EOFException, ValueTooLargeException {
        this.ensureBuffered(n);
        int n2 = this.buffer.getUInteger(this.pos, n);
        this.pos += n;
        return n2;
    }

    public long readSLong(int n) throws IOException, EOFException, ValueTooLargeException {
        this.ensureBuffered(n);
        long l = this.buffer.getSLong(this.pos, n);
        this.pos += n;
        return l;
    }

    public long readULong(int n) throws IOException, EOFException, ValueTooLargeException {
        this.ensureBuffered(n);
        long l = this.buffer.getULong(this.pos, n);
        this.pos += n;
        return l;
    }

    public BigInteger readSBigInteger(int n) throws IOException, EOFException {
        this.ensureBuffered(n);
        BigInteger bigInteger = this.buffer.getSBigInteger(this.pos, n);
        this.pos += n;
        return bigInteger;
    }

    public BigInteger readUBigInteger(int n) throws IOException, EOFException {
        this.ensureBuffered(n);
        BigInteger bigInteger = this.buffer.getUBigInteger(this.pos, n);
        this.pos += n;
        return bigInteger;
    }
}

