/*
 * Decompiled with CFR 0.152.
 */
package com.asn1c.codec;

import com.asn1c.codec.Encoder;
import com.asn1c.core.BitString;
import com.asn1c.core.UnitString;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public class OutputStreamEncoder
extends Encoder {
    protected OutputStream out;
    private static final int maxBufferSize = 65536;
    private BitString buffer;
    private long dropped;
    private byte[] byteBuffer = null;

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("stream closed");
        }
    }

    private void ensureToBuffer(int n) throws IOException {
        if (this.buffer.bitLength() + n > 65536 && this.buffer.bitLength() > 0) {
            this.flushOut();
        }
    }

    public OutputStreamEncoder(OutputStream outputStream) {
        this.out = outputStream;
        this.buffer = new BitString();
        this.dropped = 0L;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
        this.buffer.setBitLength(0);
        this.dropped = 0L;
    }

    public void write(UnitString unitString, int n, int n2) throws IOException {
        this.ensureOpen();
        this.ensureToBuffer(n2);
        this.buffer.appendBits(unitString, n, n2);
    }

    public int getBitsToAlignment() {
        return -this.buffer.bitLength() & 7;
    }

    public long getBitsWritten() {
        return this.dropped + (long)this.buffer.bitLength();
    }

    public void flushOut() throws IOException {
        this.ensureOpen();
        int n = this.buffer.bitLength() & 0xFFFFFFF8;
        int n2 = this.buffer.bitLength() & 7;
        this.out.write(this.buffer.getInternalByteArray(), 0, n / 8);
        this.buffer.setBits(this.buffer, 0, n, n2);
        this.buffer.setBitLength(n2);
        this.dropped += (long)n;
    }

    public void close() throws IOException {
        if (this.out == null) {
            return;
        }
        this.out.close();
        this.out = null;
        this.buffer.setBitLength(0);
    }

    public void writeBit(boolean bl) throws IOException {
        this.ensureOpen();
        this.ensureToBuffer(1);
        this.buffer.appendBit(bl);
    }

    public void writeByte(byte by) throws IOException {
        this.ensureOpen();
        this.ensureToBuffer(8);
        this.buffer.appendByte(by);
    }

    public void writeSInteger(int n, int n2) throws IOException {
        this.ensureOpen();
        this.ensureToBuffer(n2);
        this.buffer.appendSInteger(n, n2);
    }

    public void writeUInteger(int n, int n2) throws IOException {
        this.ensureOpen();
        this.ensureToBuffer(n2);
        this.buffer.appendUInteger(n, n2);
    }

    public void writeSLong(long l, int n) throws IOException {
        this.ensureOpen();
        this.ensureToBuffer(n);
        this.buffer.appendSLong(l, n);
    }

    public void writeULong(long l, int n) throws IOException {
        this.ensureOpen();
        this.ensureToBuffer(n);
        this.buffer.appendULong(l, n);
    }

    public void writeSBigInteger(BigInteger bigInteger, int n) throws IOException {
        this.ensureOpen();
        this.ensureToBuffer(n);
        this.buffer.appendSBigInteger(bigInteger, n);
    }

    public void writeUBigInteger(BigInteger bigInteger, int n) throws IOException {
        this.ensureOpen();
        this.ensureToBuffer(n);
        this.buffer.appendUBigInteger(bigInteger, n);
    }
}

