/*
 * Decompiled with CFR 0.152.
 */
package com.asn1c.codec;

import com.asn1c.codec.BaseTypeFactory;
import com.asn1c.codec.DataDecoder;
import com.asn1c.codec.Decoder;
import com.asn1c.codec.Factory;
import com.asn1c.codec.FactoryMap;
import com.asn1c.codec.FilterDecoder;
import com.asn1c.codec.License;
import com.asn1c.core.BadDataException;
import com.asn1c.core.BitString;
import com.asn1c.core.CharacterString;
import com.asn1c.core.DataValue;
import com.asn1c.core.EmbeddedPDV;
import com.asn1c.core.External;
import com.asn1c.core.GeneralizedTime;
import com.asn1c.core.Identification;
import com.asn1c.core.Null;
import com.asn1c.core.ObjectDescriptor;
import com.asn1c.core.ObjectIdentifier;
import com.asn1c.core.OctetString;
import com.asn1c.core.Open;
import com.asn1c.core.Real64;
import com.asn1c.core.String16Table;
import com.asn1c.core.String32;
import com.asn1c.core.String32Buffer;
import com.asn1c.core.String32Table;
import com.asn1c.core.TrimmedBitString;
import com.asn1c.core.UTCTime;
import com.asn1c.core.ValueTooLargeException;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Vector;

public abstract class UPERDecoder
extends FilterDecoder {
    protected static final int maxSkipBufferSize = 65536;
    protected BitString skipBuffer = null;
    protected Vector embeddedPdvIdentificationCache;
    protected Vector characterStringIdentificationCache;
    protected HashMap decoderMap;
    private FactoryMap factoryMap;
    protected BaseTypeFactory baseTypeFactory;
    private static int done = -1;
    private static final int[] tab = new int[]{0, 1996959894, -301047508, -1727442502, 124634137, 1886057615, -379345611, -1637575261, 249268274, 2044508324, -522852066, -1747789432, 162941995, 2125561021, -407360249, -1866523247, 498536548, 1789927666, -205950648, -2067906082, 450548861, 1843258603, -187386543, -2083289657, 325883990, 1684777152, -43845254, -1973040660, 335633487, 1661365465, -99664541, -1928851979, 997073096, 1281953886, -715111964, -1570279054, 1006888145, 1258607687, -770865667, -1526024853, 901097722, 1119000684, -608450090, -1396901568, 853044451, 1172266101, -589951537, -1412350631, 651767980, 1373503546, -925412992, -1076862698, 565507253, 1454621731, -809855591, -1195530993, 671266974, 1594198024, -972236366, -1324619484, 795835527, 1483230225, -1050600021, -1234817731, 1994146192, 31158534, -1731059524, -271249366, 1907459465, 112637215, -1614814043, -390540237, 2013776290, 251722036, -1777751922, -519137256, 2137656763, 141376813, -1855689577, -429695999, 1802195444, 476864866, -2056965928, -228458418, 1812370925, 453092731, -2113342271, -183516073, 1706088902, 314042704, -1950435094, -54949764, 1658658271, 366619977, -1932296973, -69972891, 1303535960, 984961486, -1547960204, -725929758, 1256170817, 1037604311, -1529756563, -740887301, 1131014506, 879679996, -1385723834, -631195440, 1141124467, 855842277, -1442165665, -586318647, 1342533948, 654459306, -1106571248, -921952122, 1466479909, 544179635, -1184443383, -832445281, 1591671054, 702138776, -1328506846, -942167884, 1504918807, 783551873, -1212326853, -1061524307, -306674912, -1698712650, 62317068, 1957810842, -355121351, -1647151185, 81470997, 1943803523, -480048366, -1805370492, 225274430, 2053790376, -468791541, -1828061283, 167816743, 2097651377, -267414716, -2029476910, 503444072, 1762050814, -144550051, -2140837941, 426522225, 1852507879, -19653770, -1982649376, 282753626, 1742555852, -105259153, -1900089351, 397917763, 1622183637, -690576408, -1580100738, 953729732, 1340076626, -776247311, -1497606297, 1068828381, 1219638859, -670225446, -1358292148, 906185462, 1090812512, -547295293, -1469587627, 829329135, 1181335161, -882789492, -1134132454, 628085408, 1382605366, -871598187, -1156888829, 570562233, 1426400815, -977650754, -1296233688, 733239954, 1555261956, -1026031705, -1244606671, 752459403, 1541320221, -1687895376, -328994266, 1969922972, 40735498, -1677130071, -351390145, 1913087877, 83908371, -1782625662, -491226604, 2075208622, 213261112, -1831694693, -438977011, 2094854071, 198958881, -2032938284, -237706686, 1759359992, 534414190, -2118248755, -155638181, 1873836001, 414664567, -2012718362, -15766928, 1711684554, 285281116, -1889165569, -127750551, 1634467795, 376229701, -1609899400, -686959890, 1308918612, 956543938, -1486412191, -799009033, 1231636301, 1047427035, -1362007478, -640263460, 1088359270, 936918000, -1447252397, -558129467, 1202900863, 817233897, -1111625188, -893730166, 1404277552, 615818150, -1160759803, -841546093, 1423857449, 601450431, -1285129682, -1000256840, 1567103746, 711928724, -1274298825, -1022587231, 1510334235, 755167117};

    public UPERDecoder(Decoder decoder, String string, FactoryMap factoryMap, byte[] byArray) {
        super(decoder);
        if (done == -1) {
            UPERDecoder.examine(byArray);
        }
        this.embeddedPdvIdentificationCache = new Vector();
        this.characterStringIdentificationCache = new Vector();
        this.factoryMap = factoryMap == null ? new FactoryMap() : factoryMap;
        this.baseTypeFactory = (BaseTypeFactory)this.factoryMap.get(null);
        if (this.baseTypeFactory == null) {
            this.baseTypeFactory = new BaseTypeFactory();
        }
        this.decoderMap = new HashMap();
        this.decoderMap.put(string, this);
    }

    protected UPERDecoder(Decoder decoder, UPERDecoder uPERDecoder) {
        super(decoder);
        if (done == -1) {
            throw new InternalError();
        }
        this.embeddedPdvIdentificationCache = new Vector();
        this.characterStringIdentificationCache = new Vector();
        this.decoderMap = uPERDecoder.decoderMap;
        this.factoryMap = uPERDecoder.factoryMap;
        this.baseTypeFactory = uPERDecoder.baseTypeFactory;
    }

    private static final void examine(byte[] byArray) {
        done = 0;
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length - 4) {
            n = tab[(n ^ byArray[n2]) & 0xFF] ^ n >>> 8;
            ++n2;
        }
        if (n != ((byArray[n2] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF)) {
            return;
        }
        n = 0;
        n2 = 0;
        while (n2 < License.data.length - 4) {
            n = tab[(n ^ License.data[n2]) & 0xFF] ^ n >>> 8;
            ++n2;
        }
        if (n != ((License.data[n2] & 0xFF) << 24 | (License.data[n2 + 1] & 0xFF) << 16 | (License.data[n2 + 2] & 0xFF) << 8 | License.data[n2 + 3] & 0xFF)) {
            return;
        }
        done = 1;
    }

    protected Factory getFactory(String string) {
        return this.factoryMap.get(string);
    }

    protected FactoryMap getFactoryMap() {
        return this.factoryMap;
    }

    protected UPERDecoder getDecoder(String string) {
        return (UPERDecoder)this.decoderMap.get(string);
    }

    public int readFragmentLength() throws IOException, EOFException, BadDataException {
        try {
            int n = this.readUInteger(8);
            if (done != 1) {
                n = 0;
            }
            if (n < 128) {
                return n;
            }
            if (n < 192) {
                return (n << 8 | this.readUInteger(8)) & 0x3FFF;
            }
            switch (n) {
                case 193: {
                    return 16384;
                }
                case 194: {
                    return 32768;
                }
                case 195: {
                    return 49152;
                }
                case 196: {
                    return 65536;
                }
            }
            throw new BadDataException();
        }
        catch (ValueTooLargeException valueTooLargeException) {
            throw new InternalError();
        }
    }

    protected BitString readFragmented(int n) throws IOException, EOFException, BadDataException {
        int n2;
        BitString bitString = new BitString();
        int n3 = 0;
        do {
            n2 = this.readFragmentLength();
            bitString.setBitLength(n3 + n2 * n);
            this.read(bitString, n3, n2 * n);
            n3 += n2 * n;
        } while (n2 >= 16384);
        return bitString;
    }

    protected void skipFragmented(int n) throws IOException, EOFException, BadDataException {
        int n2;
        do {
            n2 = this.readFragmentLength();
            this.skip(n2 * n);
        } while (n2 >= 16384);
    }

    public void skipToAlignment() throws IOException, EOFException, BadDataException {
        int n = this.getBitsToAlignment();
        try {
            if (n > 0 && this.readUInteger(n) != 0) {
                throw new BadDataException();
            }
        }
        catch (ValueTooLargeException valueTooLargeException) {
            throw new InternalError();
        }
    }

    public void flushIn() throws IOException, EOFException, BadDataException {
        this.skipToAlignment();
        if (this.getBitsRead() == 0L) {
            try {
                if (this.readUInteger(8) != 0) {
                    throw new BadDataException();
                }
            }
            catch (ValueTooLargeException valueTooLargeException) {
                throw new InternalError();
            }
        }
        super.flushIn();
    }

    public Null readNull() throws IOException, EOFException {
        return Null.NULL;
    }

    public void skipNull() throws IOException, EOFException {
    }

    public boolean readBoolean() throws IOException, EOFException {
        return this.readBit();
    }

    public void skipBoolean() throws IOException, EOFException {
        this.skip(1L);
    }

    public byte readConstrainedByteB(int n, byte by) throws IOException, EOFException, ValueTooLargeException {
        return (byte)(this.readUInteger(n) + by);
    }

    public short readConstrainedShortB(int n, short s) throws IOException, EOFException, ValueTooLargeException {
        return (short)(this.readUInteger(n) + s);
    }

    public int readConstrainedIntegerB(int n, int n2) throws IOException, EOFException, ValueTooLargeException {
        return this.readUInteger(n) + n2;
    }

    public long readConstrainedLongB(int n, long l) throws IOException, EOFException, ValueTooLargeException {
        return this.readULong(n) + l;
    }

    public BigInteger readConstrainedBigIntegerB(int n, BigInteger bigInteger) throws IOException, EOFException {
        return this.readUBigInteger(n).add(bigInteger);
    }

    public void skipConstrainedIntegerB(int n) throws IOException, EOFException, ValueTooLargeException {
        this.skip(n);
    }

    public int readConstrainedIntegerBB(int n, int n2) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        int n3 = this.readUInteger(n);
        if (n3 > 0xFFFFFFE) {
            throw new ValueTooLargeException();
        }
        return this.readUInteger((n3 + 1) * 8) + n2;
    }

    public long readConstrainedLongBB(int n, long l) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        int n2 = this.readUInteger(n);
        if (n2 > 0xFFFFFFE) {
            throw new ValueTooLargeException();
        }
        return this.readULong((n2 + 1) * 8) + l;
    }

    public BigInteger readConstrainedBigIntegerBB(int n, BigInteger bigInteger) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        int n2 = this.readUInteger(n);
        if (n2 > 0xFFFFFFE) {
            throw new ValueTooLargeException();
        }
        return this.readUBigInteger((n2 + 1) * 8).add(bigInteger);
    }

    public void skipConstrainedIntegerBB(int n) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        int n2 = this.readUInteger(n);
        if (n2 > 0xFFFFFFE) {
            throw new ValueTooLargeException();
        }
        this.skip((n2 + 1) * 8);
    }

    public BigInteger readConstrainedBigIntegerFBB(BigInteger bigInteger) throws IOException, EOFException, BadDataException {
        BitString bitString = this.readFragmented(8);
        return bitString.getUBigInteger(0, bitString.bitLength()).add(bigInteger);
    }

    public void skipConstrainedIntegerFBB() throws IOException, EOFException, BadDataException {
        this.skipFragmented(8);
    }

    public byte readSemiconstrainedByteFBB(byte by) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        BitString bitString = this.readFragmented(8);
        return (byte)(bitString.getUInteger(0, bitString.bitLength()) + by);
    }

    public short readSemiconstrainedShortFBB(short s) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        BitString bitString = this.readFragmented(8);
        return (short)(bitString.getUInteger(0, bitString.bitLength()) + s);
    }

    public int readSemiconstrainedIntegerFBB(int n) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        BitString bitString = this.readFragmented(8);
        return bitString.getUInteger(0, bitString.bitLength()) + n;
    }

    public long readSemiconstrainedLongFBB(long l) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        BitString bitString = this.readFragmented(8);
        return bitString.getULong(0, bitString.bitLength()) + l;
    }

    public BigInteger readSemiconstrainedBigIntegerFBB(BigInteger bigInteger) throws IOException, EOFException, BadDataException {
        BitString bitString = this.readFragmented(8);
        return bitString.getUBigInteger(0, bitString.bitLength()).add(bigInteger);
    }

    public void skipSemiconstrainedIntegerFBB() throws IOException, EOFException, BadDataException {
        this.skipFragmented(8);
    }

    public byte readSemiconstrainedByteSB(byte by) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        return this.readBit() ? this.readSemiconstrainedByteFBB(by) : (byte)(this.readUInteger(6) + by);
    }

    public short readSemiconstrainedShortSB(short s) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        return this.readBit() ? this.readSemiconstrainedShortFBB(s) : (short)(this.readUInteger(6) + s);
    }

    public int readSemiconstrainedIntegerSB(int n) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        return this.readBit() ? this.readSemiconstrainedIntegerFBB(n) : this.readUInteger(6) + n;
    }

    public long readSemiconstrainedLongSB(long l) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        return this.readBit() ? this.readSemiconstrainedLongFBB(l) : this.readULong(6) + l;
    }

    public BigInteger readSemiconstrainedBigIntegerSB(BigInteger bigInteger) throws IOException, EOFException, BadDataException {
        return this.readBit() ? this.readSemiconstrainedBigIntegerFBB(bigInteger) : this.readUBigInteger(6).add(bigInteger);
    }

    public void skipSemiconstrainedIntegerSB() throws IOException, EOFException, BadDataException {
        if (this.readBit()) {
            this.skipFragmented(8);
        } else {
            this.skip(6L);
        }
    }

    public byte readUnconstrainedByteFBB() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        BitString bitString = this.readFragmented(8);
        return (byte)bitString.getSInteger(0, bitString.bitLength());
    }

    public short readUnconstrainedShortFBB() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        BitString bitString = this.readFragmented(8);
        return (short)bitString.getSInteger(0, bitString.bitLength());
    }

    public int readUnconstrainedIntegerFBB() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        BitString bitString = this.readFragmented(8);
        return bitString.getSInteger(0, bitString.bitLength());
    }

    public long readUnconstrainedLongFBB() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        BitString bitString = this.readFragmented(8);
        return bitString.getSLong(0, bitString.bitLength());
    }

    public BigInteger readUnconstrainedBigIntegerFBB() throws IOException, EOFException, BadDataException {
        BitString bitString = this.readFragmented(8);
        return bitString.getSBigInteger(0, bitString.bitLength());
    }

    public void skipUnconstrainedIntegerFBB() throws IOException, EOFException, BadDataException {
        this.skipFragmented(8);
    }

    public double readRealDouble() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        BitString bitString = this.readFragmented(8);
        if (bitString.bitLength() == 0) {
            return 0.0;
        }
        if (bitString.getBit(0)) {
            int n;
            int n2;
            int n3;
            boolean bl = bitString.getBit(1);
            if (bitString.getBit(2)) {
                if (bitString.getBit(3)) {
                    throw new BadDataException();
                }
                n3 = 4;
            } else {
                n3 = bitString.getBit(3) ? 3 : 1;
            }
            int n4 = bitString.getUInteger(4, 2);
            if (bitString.getBit(6)) {
                if (bitString.getBit(7)) {
                    int n5 = bitString.getUInteger(8, 8);
                    n2 = bitString.getSInteger(16, (n5 + 1) * 8);
                    n = 24 + n5 * 8;
                } else {
                    n2 = bitString.getSInteger(8, 24);
                    n = 32;
                }
            } else if (bitString.getBit(7)) {
                n2 = bitString.getSInteger(8, 16);
                n = 24;
            } else {
                n2 = bitString.getSInteger(8, 8);
                n = 16;
            }
            n2 = n2 * n3 + n4;
            return bl ? (double)(-bitString.getULong(n, bitString.bitLength() - n)) * Math.pow(2.0, n2) : (double)bitString.getULong(n, bitString.bitLength() - n) * Math.pow(2.0, n2);
        }
        if (bitString.getBit(1)) {
            if (bitString.bitLength() != 8) {
                throw new BadDataException();
            }
            switch (bitString.getUInteger(2, 6)) {
                case 0: {
                    return Double.POSITIVE_INFINITY;
                }
                case 1: {
                    return Double.NEGATIVE_INFINITY;
                }
            }
            throw new BadDataException();
        }
        String string = bitString.getString(8, bitString.bitLength() / 8 - 1, 8);
        string = string.replace(',', '.');
        try {
            return Real64.valueOf(string).doubleValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw new BadDataException();
        }
    }

    public void skipReal() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        this.skipFragmented(8);
    }

    public BitString readConstrainedBitStringB(int n) throws IOException, EOFException {
        return this.readBits(n);
    }

    public TrimmedBitString readConstrainedTrimmedBitStringB(int n) throws IOException, EOFException {
        return new TrimmedBitString(this.readBits(n));
    }

    public void skipConstrainedBitStringB(int n) throws IOException, EOFException {
        this.skip(n);
    }

    public void skipConstrainedTrimmedBitStringB(int n) throws IOException, EOFException {
        this.skip(n);
    }

    public BitString readConstrainedBitStringBB(int n, int n2) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        int n3 = this.readUInteger(n) + n2;
        return this.readBits(n3);
    }

    public TrimmedBitString readConstrainedTrimmedBitStringBB(int n, int n2) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        int n3 = this.readUInteger(n) + n2;
        return new TrimmedBitString(this.readBits(n3));
    }

    public void skipConstrainedBitStringBB(int n, int n2) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        int n3 = this.readUInteger(n) + n2;
        this.skip(n3);
    }

    public void skipConstrainedTrimmedBitStringBB(int n, int n2) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        int n3 = this.readUInteger(n) + n2;
        this.skip(n3);
    }

    public BitString readConstrainedBitStringFBB() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        return this.readFragmented(1);
    }

    public TrimmedBitString readConstrainedTrimmedBitStringFBB() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        return new TrimmedBitString(this.readFragmented(1));
    }

    public void skipConstrainedBitStringFBB() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        this.skipFragmented(1);
    }

    public void skipConstrainedTrimmedBitStringFBB() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        this.skipFragmented(1);
    }

    public BitString readSemiconstrainedBitStringFBB() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        return this.readFragmented(1);
    }

    public TrimmedBitString readSemiconstrainedTrimmedBitStringFBB() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        return new TrimmedBitString(this.readFragmented(1));
    }

    public void skipSemiconstrainedBitStringFBB() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        this.skipFragmented(1);
    }

    public void skipSemiconstrainedTrimmedBitStringFBB() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        this.skipFragmented(1);
    }

    public BitString readUnconstrainedBitStringFBB() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        return this.readFragmented(1);
    }

    public TrimmedBitString readUnconstrainedTrimmedBitStringFBB() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        return new TrimmedBitString(this.readFragmented(1));
    }

    public void skipUnconstrainedBitStringFBB() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        this.skipFragmented(1);
    }

    public void skipUnconstrainedTrimmedBitStringFBB() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        this.skipFragmented(1);
    }

    public OctetString readConstrainedOctetStringB(int n) throws IOException, EOFException {
        return this.readBits(n * 8).getOctets(0, n);
    }

    public void skipConstrainedOctetStringB(int n) throws IOException, EOFException {
        this.skip(n * 8);
    }

    public OctetString readConstrainedOctetStringBB(int n, int n2) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        int n3 = this.readUInteger(n) + n2;
        return this.readBits(n3 * 8).getOctets(0, n3);
    }

    public void skipConstrainedOctetStringBB(int n, int n2) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        int n3 = this.readUInteger(n) + n2;
        this.skip(n3 * 8);
    }

    public OctetString readConstrainedOctetStringFBB() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        BitString bitString = this.readFragmented(8);
        return bitString.getOctets(0, bitString.bitLength() / 8);
    }

    public void skipConstrainedOctetStringFBB() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        this.skipFragmented(8);
    }

    public OctetString readSemiconstrainedOctetStringFBB() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        BitString bitString = this.readFragmented(8);
        return bitString.getOctets(0, bitString.bitLength() / 8);
    }

    public void skipSemiconstrainedOctetStringFBB() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        this.skipFragmented(8);
    }

    public OctetString readUnconstrainedOctetStringFBB() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        BitString bitString = this.readFragmented(8);
        return bitString.getOctets(0, bitString.bitLength() / 8);
    }

    public void skipUnconstrainedOctetStringFBB() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        this.skipFragmented(8);
    }

    public ObjectIdentifier readObjectIdentifier() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        ObjectIdentifier objectIdentifier = new ObjectIdentifier();
        BitString bitString = this.readFragmented(8);
        int n = bitString.bitLength();
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            long l = 0L;
            do {
                if (n2 >= n) {
                    throw new BadDataException();
                }
                if (l > 0xFFFFFFFFFFFFFFL) {
                    throw new ValueTooLargeException();
                }
                l = l << 7 | (long)bitString.getUInteger(n2 + 1, 7);
            } while (bitString.getBit((n2 += 8) - 8));
            if (n3 == 0) {
                if (l < 80L) {
                    objectIdentifier.set(n3++, l / 40L);
                    objectIdentifier.set(n3++, l % 40L);
                    continue;
                }
                objectIdentifier.set(n3++, 2L);
                objectIdentifier.set(n3++, l - 80L);
                continue;
            }
            objectIdentifier.set(n3++, l);
        }
        return objectIdentifier;
    }

    public void skipObjectIdentifier() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        this.skipFragmented(8);
    }

    protected String applyTable(String string, String16Table string16Table) throws BadDataException {
        if (string16Table == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        stringBuffer.setLength(string.length());
        int n = stringBuffer.length();
        while (n-- > 0) {
            stringBuffer.setCharAt(n, string16Table.mapToChar(string.charAt(n)));
        }
        return stringBuffer.toString();
    }

    protected String32 applyTable(String32 string32, String32Table string32Table) throws BadDataException {
        if (string32Table == null) {
            return string32;
        }
        String32Buffer string32Buffer = new String32Buffer(string32.length());
        string32Buffer.setLength(string32.length());
        int n = string32Buffer.length();
        while (n-- > 0) {
            string32Buffer.setCharAt(n, string32Table.mapToChar(string32.charAt(n)));
        }
        return string32Buffer.toString32();
    }

    public String readConstrainedStringB(int n, int n2, String16Table string16Table) throws IOException, EOFException, BadDataException {
        return this.applyTable(this.readBits(n * n2).getString(0, n, n2), string16Table);
    }

    public String32 readConstrainedString32B(int n, int n2, String32Table string32Table) throws IOException, EOFException, BadDataException {
        return this.applyTable(this.readBits(n * n2).getString32(0, n, n2), string32Table);
    }

    public void skipConstrainedStringB(int n, int n2) throws IOException, EOFException, BadDataException {
        this.skip(n * n2);
    }

    public String readConstrainedStringBB(int n, int n2, int n3, String16Table string16Table) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        int n4 = this.readUInteger(n) + n2;
        return this.applyTable(this.readBits(n4 * n3).getString(0, n4, n3), string16Table);
    }

    public String32 readConstrainedString32BB(int n, int n2, int n3, String32Table string32Table) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        int n4 = this.readUInteger(n) + n2;
        return this.applyTable(this.readBits(n4 * n3).getString32(0, n4, n3), string32Table);
    }

    public void skipConstrainedStringBB(int n, int n2, int n3) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        int n4 = this.readUInteger(n) + n2;
        this.skip(n4 * n3);
    }

    public String readConstrainedStringFBB(int n, String16Table string16Table) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        BitString bitString = this.readFragmented(n);
        return this.applyTable(bitString.getString(0, bitString.bitLength() / n, n), string16Table);
    }

    public String32 readConstrainedString32FBB(int n, String32Table string32Table) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        BitString bitString = this.readFragmented(n);
        return this.applyTable(bitString.getString32(0, bitString.bitLength() / n, n), string32Table);
    }

    public void skipConstrainedStringFBB(int n) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        this.skipFragmented(n);
    }

    public String readSemiconstrainedStringFBB(int n, String16Table string16Table) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        BitString bitString = this.readFragmented(n);
        return this.applyTable(bitString.getString(0, bitString.bitLength() / n, n), string16Table);
    }

    public String32 readSemiconstrainedString32FBB(int n, String32Table string32Table) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        BitString bitString = this.readFragmented(n);
        return this.applyTable(bitString.getString32(0, bitString.bitLength() / n, n), string32Table);
    }

    public void skipSemiconstrainedStringFBB(int n) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        this.skipFragmented(n);
    }

    public String readUnconstrainedStringFBB(int n, String16Table string16Table) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        BitString bitString = this.readFragmented(n);
        return this.applyTable(bitString.getString(0, bitString.bitLength() / n, n), string16Table);
    }

    public String32 readUnconstrainedString32FBB(int n, String32Table string32Table) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        BitString bitString = this.readFragmented(n);
        return this.applyTable(bitString.getString32(0, bitString.bitLength() / n, n), string32Table);
    }

    public void skipUnconstrainedStringFBB(int n) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        this.skipFragmented(n);
    }

    public String readMultibyteString() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        BitString bitString = this.readFragmented(8);
        return bitString.getString(0, bitString.bitLength() / 8, 8);
    }

    public void skipMultibyteString() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        this.skipFragmented(8);
    }

    public String readObjectDescriptor() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        BitString bitString = this.readFragmented(8);
        return bitString.getString(0, bitString.bitLength() / 8, 8);
    }

    public void skipObjectDescriptor() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        this.skipFragmented(8);
    }

    private static int parseDecimal(String string) throws BadDataException {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            if (c < '0' || c > '9') {
                throw new BadDataException();
            }
            n2 = 10 * n2 + (c - 48);
            ++n3;
        }
        return n2;
    }

    private static double parseFraction(String string) throws BadDataException {
        int n = string.length();
        double d = 0.0;
        int n2 = n;
        while (n2-- > 0) {
            char c = string.charAt(n2);
            if (c < '0' || c > '9') {
                throw new BadDataException();
            }
            d = (d + (double)(c - 48)) / 10.0;
        }
        return d;
    }

    public GeneralizedTime stringToGeneralizedTime(String string, int n) throws IOException, EOFException, BadDataException {
        char c;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = string.length();
        if (string.length() < 10) {
            throw new BadDataException();
        }
        int n7 = UPERDecoder.parseDecimal(string.substring(0, 4));
        int n8 = UPERDecoder.parseDecimal(string.substring(4, 6)) - 1;
        int n9 = UPERDecoder.parseDecimal(string.substring(6, 8));
        int n10 = UPERDecoder.parseDecimal(string.substring(8, 10));
        if (n6 > 11) {
            c = string.charAt(10);
            if (c == '.' || c == ',') {
                int n11 = 11;
                while (n11 < n6) {
                    if (string.charAt(n11) < '0' || string.charAt(n11) > '9') break;
                    ++n11;
                }
                double d = UPERDecoder.parseFraction(string.substring(11, n11));
                n2 = (int)(d *= 60.0);
                n3 = (int)(d *= 60.0);
                n4 = (int)(d *= 1000.0);
                string = string.substring(n11);
                n6 -= n11;
            } else if (c >= '0' && c <= '9') {
                n2 = UPERDecoder.parseDecimal(string.substring(10, 12));
                if (n6 > 13) {
                    c = string.charAt(12);
                    if (c == '.' || c == ',') {
                        int n12 = 13;
                        while (n12 < n6) {
                            if (string.charAt(n12) < '0' || string.charAt(n12) > '9') break;
                            ++n12;
                        }
                        double d = UPERDecoder.parseFraction(string.substring(13, n12));
                        n3 = (int)(d *= 60.0);
                        n4 = (int)(d *= 1000.0);
                        string = string.substring(n12);
                        n6 -= n12;
                    } else if (c >= '0' && c <= '9') {
                        n3 = UPERDecoder.parseDecimal(string.substring(12, 14));
                        if (n6 > 15) {
                            c = string.charAt(14);
                            if (c == '.' || c == ',') {
                                int n13 = 15;
                                while (n13 < n6) {
                                    if (string.charAt(n13) < '0' || string.charAt(n13) > '9') break;
                                    ++n13;
                                }
                                double d = UPERDecoder.parseFraction(string.substring(15, n13));
                                n4 = (int)(d *= 1000.0);
                                string = string.substring(n13);
                                n6 -= n13;
                            } else {
                                string = string.substring(14);
                                n6 -= 14;
                            }
                        } else {
                            string = string.substring(14);
                            n6 -= 14;
                        }
                    } else {
                        string = string.substring(12);
                        n6 -= 12;
                    }
                } else {
                    string = string.substring(12);
                    n6 -= 12;
                }
            } else {
                string = string.substring(10);
                n6 -= 10;
            }
        } else {
            string = string.substring(10);
            n6 -= 10;
        }
        if (n6 > 0) {
            c = string.charAt(0);
            if (c == 'Z') {
                if (n6 != 1) {
                    throw new BadDataException();
                }
                return new GeneralizedTime(n7, n8, n9, n10, n2, n3, n4, true);
            }
            if (n6 != 3 && n6 != 5 || c != '+' && c != '-') {
                throw new BadDataException();
            }
            int n14 = UPERDecoder.parseDecimal(string.substring(1, 3));
            if (n6 == 5) {
                n5 = UPERDecoder.parseDecimal(string.substring(3, 5));
            }
            if (c == '-') {
                n14 = -n14;
                n5 = -n5;
            }
            return new GeneralizedTime(n7, n8, n9, n10, n2, n3, n4, (n14 * 60 + n5) * 60000);
        }
        return new GeneralizedTime(n7, n8, n9, n10, n2, n3, n4);
    }

    public GeneralizedTime readConstrainedGeneralizedTimeB(int n, int n2, int n3, String16Table string16Table) throws IOException, EOFException, BadDataException {
        String string = this.readConstrainedStringB(n, n2, string16Table);
        return this.stringToGeneralizedTime(string, n3);
    }

    public GeneralizedTime readConstrainedGeneralizedTimeBB(int n, int n2, int n3, int n4, String16Table string16Table) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        String string = this.readConstrainedStringBB(n, n2, n3, string16Table);
        return this.stringToGeneralizedTime(string, n4);
    }

    public GeneralizedTime readConstrainedGeneralizedTimeFBB(int n, int n2, String16Table string16Table) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        String string = this.readConstrainedStringFBB(n, string16Table);
        return this.stringToGeneralizedTime(string, n2);
    }

    public GeneralizedTime readSemiconstrainedGeneralizedTimeFBB(int n, int n2, String16Table string16Table) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        String string = this.readConstrainedStringFBB(n, string16Table);
        return this.stringToGeneralizedTime(string, n2);
    }

    public GeneralizedTime readUnconstrainedGeneralizedTimeFBB(int n, int n2, String16Table string16Table) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        String string = this.readConstrainedStringFBB(n, string16Table);
        return this.stringToGeneralizedTime(string, n2);
    }

    public UTCTime stringToUTCTime(String string, int n) throws IOException, EOFException, BadDataException {
        char c;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        if (string.length() < 10) {
            throw new BadDataException();
        }
        int n5 = UPERDecoder.parseDecimal(string.substring(0, 2));
        int n6 = UPERDecoder.parseDecimal(string.substring(2, 4)) - 1;
        int n7 = UPERDecoder.parseDecimal(string.substring(4, 6));
        int n8 = UPERDecoder.parseDecimal(string.substring(6, 8));
        int n9 = UPERDecoder.parseDecimal(string.substring(8, 10));
        if (n4 > 11) {
            c = string.charAt(10);
            if (c >= '0' && c <= '9') {
                n2 = UPERDecoder.parseDecimal(string.substring(10, 12));
                string = string.substring(12);
                n4 -= 12;
            } else {
                string = string.substring(10);
                n4 -= 10;
            }
        } else {
            string = string.substring(10);
            n4 -= 10;
        }
        if (n4 > 0) {
            c = string.charAt(0);
            if (c == 'Z') {
                if (n4 != 1) {
                    throw new BadDataException();
                }
                return new UTCTime(n5, n6, n7, n8, n9, n2, true);
            }
            if (n4 != 3 && n4 != 5 || c != '+' && c != '-') {
                throw new BadDataException();
            }
            int n10 = UPERDecoder.parseDecimal(string.substring(1, 3));
            if (n4 == 5) {
                n3 = UPERDecoder.parseDecimal(string.substring(3, 5));
            }
            if (c == '-') {
                n10 = -n10;
                n3 = -n3;
            }
            return new UTCTime(n5, n6, n7, n8, n9, n2, (n10 * 60 + n3) * 60000);
        }
        return new UTCTime(n5, n6, n7, n8, n9, n2);
    }

    public UTCTime readConstrainedUTCTimeB(int n, int n2, int n3, String16Table string16Table) throws IOException, EOFException, BadDataException {
        String string = this.readConstrainedStringB(n, n2, string16Table);
        return this.stringToUTCTime(string, n3);
    }

    public UTCTime readConstrainedUTCTimeBB(int n, int n2, int n3, int n4, String16Table string16Table) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        String string = this.readConstrainedStringBB(n, n2, n3, string16Table);
        return this.stringToUTCTime(string, n4);
    }

    public UTCTime readConstrainedUTCTimeFBB(int n, int n2, String16Table string16Table) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        String string = this.readConstrainedStringFBB(n, string16Table);
        return this.stringToUTCTime(string, n2);
    }

    public UTCTime readSemiconstrainedUTCTimeFBB(int n, int n2, String16Table string16Table) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        String string = this.readConstrainedStringFBB(n, string16Table);
        return this.stringToUTCTime(string, n2);
    }

    public UTCTime readUnconstrainedUTCTimeFBB(int n, int n2, String16Table string16Table) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        String string = this.readConstrainedStringFBB(n, string16Table);
        return this.stringToUTCTime(string, n2);
    }

    public External readExternal() throws IOException, EOFException, BadDataException, ValueTooLargeException {
        DataValue dataValue;
        Identification identification;
        BitString bitString = this.readBits(3);
        if (!bitString.getBit(0)) {
            if (!bitString.getBit(1)) {
                throw new BadDataException();
            }
            int n = this.readUnconstrainedIntegerFBB();
            identification = new Identification(2, n);
        } else if (!bitString.getBit(1)) {
            ObjectIdentifier objectIdentifier = this.readObjectIdentifier();
            identification = new Identification(1, objectIdentifier);
        } else {
            ObjectIdentifier objectIdentifier = this.readObjectIdentifier();
            int n = this.readUnconstrainedIntegerFBB();
            identification = new Identification(3, n, objectIdentifier);
        }
        ObjectDescriptor objectDescriptor = bitString.getBit(2) ? new ObjectDescriptor(this.readObjectDescriptor()) : null;
        switch (this.readUInteger(2)) {
            case 0: {
                Open open = new Open(this.readOpen());
                dataValue = new DataValue(0, open);
                break;
            }
            case 1: {
                BitString bitString2 = this.readFragmented(8);
                dataValue = new DataValue(1, bitString2);
                break;
            }
            case 2: {
                BitString bitString3 = this.readFragmented(1);
                dataValue = new DataValue(1, bitString3);
                break;
            }
            default: {
                throw new BadDataException();
            }
        }
        return new External(identification, objectDescriptor, dataValue);
    }

    public void skipExternal() throws IOException, EOFException, BadDataException, ValueTooLargeException {
        BitString bitString = this.readBits(3);
        if (!bitString.getBit(2)) {
            if (!bitString.getBit(1)) {
                throw new BadDataException();
            }
            this.skipUnconstrainedIntegerFBB();
        } else if (!bitString.getBit(1)) {
            this.skipObjectIdentifier();
        } else {
            this.skipObjectIdentifier();
            this.skipUnconstrainedIntegerFBB();
        }
        if (bitString.getBit(0)) {
            this.skipObjectDescriptor();
        }
        switch (this.readUInteger(2)) {
            case 0: {
                this.skipOpen();
                break;
            }
            case 1: {
                this.skipFragmented(8);
                break;
            }
            case 2: {
                this.skipFragmented(1);
                break;
            }
            default: {
                throw new BadDataException();
            }
        }
    }

    public EmbeddedPDV readEmbeddedPDV() throws IOException, EOFException, BadDataException, ValueTooLargeException {
        Identification identification;
        BitString bitString;
        boolean bl = this.readBit();
        int n = this.readSemiconstrainedIntegerSB(0);
        if (bl) {
            bitString = this.readBits(3);
            if (!bitString.getBit(2)) {
                if (!bitString.getBit(1)) {
                    if (!bitString.getBit(0)) {
                        ObjectIdentifier objectIdentifier = this.readObjectIdentifier();
                        ObjectIdentifier objectIdentifier2 = this.readObjectIdentifier();
                        identification = new Identification(0, objectIdentifier, objectIdentifier2);
                    } else {
                        ObjectIdentifier objectIdentifier = this.readObjectIdentifier();
                        identification = new Identification(1, objectIdentifier);
                    }
                } else if (!bitString.getBit(0)) {
                    int n2 = this.readUnconstrainedIntegerFBB();
                    identification = new Identification(2, n2);
                } else {
                    ObjectIdentifier objectIdentifier = this.readObjectIdentifier();
                    int n3 = this.readUnconstrainedIntegerFBB();
                    identification = new Identification(3, n3, objectIdentifier);
                }
            } else if (!bitString.getBit(1)) {
                if (!bitString.getBit(0)) {
                    ObjectIdentifier objectIdentifier = this.readObjectIdentifier();
                    identification = new Identification(4, objectIdentifier);
                } else {
                    identification = new Identification(5);
                }
            } else {
                throw new BadDataException();
            }
            if (this.embeddedPdvIdentificationCache.size() != n) {
                throw new BadDataException();
            }
            this.embeddedPdvIdentificationCache.addElement(UPERDecoder.dupIdentification(identification));
        } else {
            if (n >= this.embeddedPdvIdentificationCache.size()) {
                throw new BadDataException();
            }
            identification = UPERDecoder.dupIdentification((Identification)this.embeddedPdvIdentificationCache.elementAt(n));
        }
        bitString = this.readFragmented(1);
        DataValue dataValue = new DataValue(1, bitString);
        return new EmbeddedPDV(identification, dataValue);
    }

    public EmbeddedPDV readEmbeddedPDVOpt(Identification identification) throws IOException, EOFException, BadDataException, ValueTooLargeException {
        BitString bitString = this.readFragmented(1);
        DataValue dataValue = new DataValue(1, bitString);
        return new EmbeddedPDV(identification, dataValue);
    }

    public void skipEmbeddedPDV() throws IOException, EOFException, BadDataException, ValueTooLargeException {
        boolean bl = this.readBit();
        int n = this.readSemiconstrainedIntegerSB(0);
        if (bl) {
            Identification identification;
            BitString bitString = this.readBits(3);
            if (!bitString.getBit(2)) {
                if (!bitString.getBit(1)) {
                    if (!bitString.getBit(0)) {
                        ObjectIdentifier objectIdentifier = this.readObjectIdentifier();
                        ObjectIdentifier objectIdentifier2 = this.readObjectIdentifier();
                        identification = new Identification(0, objectIdentifier, objectIdentifier2);
                    } else {
                        ObjectIdentifier objectIdentifier = this.readObjectIdentifier();
                        identification = new Identification(1, objectIdentifier);
                    }
                } else if (!bitString.getBit(0)) {
                    int n2 = this.readUnconstrainedIntegerFBB();
                    identification = new Identification(2, n2);
                } else {
                    ObjectIdentifier objectIdentifier = this.readObjectIdentifier();
                    int n3 = this.readUnconstrainedIntegerFBB();
                    identification = new Identification(3, n3, objectIdentifier);
                }
            } else if (!bitString.getBit(1)) {
                if (!bitString.getBit(0)) {
                    ObjectIdentifier objectIdentifier = this.readObjectIdentifier();
                    identification = new Identification(4, objectIdentifier);
                } else {
                    identification = new Identification(5);
                }
            } else {
                throw new BadDataException();
            }
            if (this.embeddedPdvIdentificationCache.size() != n) {
                throw new BadDataException();
            }
            this.embeddedPdvIdentificationCache.addElement(identification);
        } else if (n >= this.embeddedPdvIdentificationCache.size()) {
            throw new BadDataException();
        }
        this.skipFragmented(8);
    }

    public void skipEmbeddedPDVOpt(Identification identification) throws IOException, EOFException, BadDataException, ValueTooLargeException {
        this.skipFragmented(8);
    }

    public CharacterString readCharacterString() throws IOException, EOFException, BadDataException, ValueTooLargeException {
        Identification identification;
        BitString bitString;
        boolean bl = this.readBit();
        int n = this.readSemiconstrainedIntegerSB(0);
        if (bl) {
            bitString = this.readBits(3);
            if (!bitString.getBit(2)) {
                if (!bitString.getBit(1)) {
                    if (!bitString.getBit(0)) {
                        ObjectIdentifier objectIdentifier = this.readObjectIdentifier();
                        ObjectIdentifier objectIdentifier2 = this.readObjectIdentifier();
                        identification = new Identification(0, objectIdentifier, objectIdentifier2);
                    } else {
                        ObjectIdentifier objectIdentifier = this.readObjectIdentifier();
                        identification = new Identification(1, objectIdentifier);
                    }
                } else if (!bitString.getBit(0)) {
                    int n2 = this.readUnconstrainedIntegerFBB();
                    identification = new Identification(2, n2);
                } else {
                    ObjectIdentifier objectIdentifier = this.readObjectIdentifier();
                    int n3 = this.readUnconstrainedIntegerFBB();
                    identification = new Identification(3, n3, objectIdentifier);
                }
            } else if (!bitString.getBit(1)) {
                if (!bitString.getBit(0)) {
                    ObjectIdentifier objectIdentifier = this.readObjectIdentifier();
                    identification = new Identification(4, objectIdentifier);
                } else {
                    identification = new Identification(5);
                }
            } else {
                throw new BadDataException();
            }
            if (this.characterStringIdentificationCache.size() != n) {
                throw new BadDataException();
            }
            this.characterStringIdentificationCache.addElement(UPERDecoder.dupIdentification(identification));
        } else {
            if (n >= this.characterStringIdentificationCache.size()) {
                throw new BadDataException();
            }
            identification = UPERDecoder.dupIdentification((Identification)this.characterStringIdentificationCache.elementAt(n));
        }
        bitString = this.readFragmented(8);
        OctetString octetString = bitString.getOctets(0, bitString.bitLength() / 8);
        DataValue dataValue = new DataValue(2, octetString);
        return new CharacterString(identification, dataValue);
    }

    public CharacterString readCharacterStringOpt(Identification identification) throws IOException, EOFException, BadDataException, ValueTooLargeException {
        BitString bitString = this.readFragmented(8);
        OctetString octetString = bitString.getOctets(0, bitString.bitLength() / 8);
        DataValue dataValue = new DataValue(2, octetString);
        return new CharacterString(identification, dataValue);
    }

    public void skipCharacterString() throws IOException, EOFException, BadDataException, ValueTooLargeException {
        boolean bl = this.readBit();
        int n = this.readSemiconstrainedIntegerSB(0);
        if (bl) {
            Identification identification;
            BitString bitString = this.readBits(3);
            if (!bitString.getBit(2)) {
                if (!bitString.getBit(1)) {
                    if (!bitString.getBit(0)) {
                        ObjectIdentifier objectIdentifier = this.readObjectIdentifier();
                        ObjectIdentifier objectIdentifier2 = this.readObjectIdentifier();
                        identification = new Identification(0, objectIdentifier, objectIdentifier2);
                    } else {
                        ObjectIdentifier objectIdentifier = this.readObjectIdentifier();
                        identification = new Identification(1, objectIdentifier);
                    }
                } else if (!bitString.getBit(0)) {
                    int n2 = this.readUnconstrainedIntegerFBB();
                    identification = new Identification(2, n2);
                } else {
                    ObjectIdentifier objectIdentifier = this.readObjectIdentifier();
                    int n3 = this.readUnconstrainedIntegerFBB();
                    identification = new Identification(3, n3, objectIdentifier);
                }
            } else if (!bitString.getBit(1)) {
                if (!bitString.getBit(0)) {
                    ObjectIdentifier objectIdentifier = this.readObjectIdentifier();
                    identification = new Identification(4, objectIdentifier);
                } else {
                    identification = new Identification(5);
                }
            } else {
                throw new BadDataException();
            }
            if (this.characterStringIdentificationCache.size() != n) {
                throw new BadDataException();
            }
            this.characterStringIdentificationCache.addElement(identification);
        } else if (n >= this.characterStringIdentificationCache.size()) {
            throw new BadDataException();
        }
        this.skipFragmented(8);
    }

    public void skipCharacterStringOpt(Identification identification) throws IOException, EOFException, BadDataException, ValueTooLargeException {
        this.skipFragmented(8);
    }

    public OctetString readOpen() throws IOException, EOFException, BadDataException, ValueTooLargeException {
        BitString bitString = this.readFragmented(8);
        OctetString octetString = bitString.getOctets(0, bitString.bitLength() / 8);
        return octetString;
    }

    public void skipOpen() throws IOException, EOFException, BadDataException, ValueTooLargeException {
        this.skipFragmented(8);
    }

    public TrimmedBitString readBitFieldB(int n) throws IOException, EOFException {
        return new TrimmedBitString(this.readBits(n));
    }

    public void skipBitFieldB(int n) throws IOException, EOFException {
        this.skip(n);
    }

    public TrimmedBitString readBitFieldFBB() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        return new TrimmedBitString(this.readFragmented(1));
    }

    public void skipBitFieldFBB() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        this.skipFragmented(1);
    }

    public TrimmedBitString readBitFieldSB() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        if (this.readBit()) {
            return new TrimmedBitString(this.readFragmented(1));
        }
        int n = this.readUInteger(6) + 1;
        return new TrimmedBitString(this.readBits(n));
    }

    public void skipBitFieldSB() throws IOException, EOFException, ValueTooLargeException, BadDataException {
        if (this.readBit()) {
            this.skipFragmented(1);
        } else {
            int n = this.readUInteger(6) + 1;
            this.skip(n);
        }
    }

    public BitString readExtension() throws IOException, EOFException, BadDataException {
        return this.readFragmented(8);
    }

    public void skipExtension() throws IOException, EOFException, BadDataException {
        this.skipFragmented(8);
    }

    public void skipExtensions(BitString bitString, int n) throws IOException, EOFException, ValueTooLargeException, BadDataException {
        int n2 = bitString.bitLength();
        while (n < n2) {
            if (!bitString.getBit(n++)) continue;
            this.skipFragmented(8);
        }
    }

    public UPERDecoder createExtensionDecoder() throws IOException, EOFException, BadDataException {
        BitString bitString = this.readFragmented(8);
        DataDecoder dataDecoder = new DataDecoder(bitString);
        return this.createExtensionClone(dataDecoder);
    }

    public void closeExtensionDecoder(UPERDecoder uPERDecoder) throws IOException, EOFException, BadDataException {
        uPERDecoder.flushIn();
    }

    public abstract UPERDecoder createExtensionClone(Decoder var1);

    protected static Identification dupIdentification(Identification identification) {
        switch (identification.getSelector()) {
            case 0: {
                return new Identification(0, (ObjectIdentifier)identification.getSyntaxesAbstract().clone(), (ObjectIdentifier)identification.getSyntaxesTransfer().clone());
            }
            case 1: {
                return new Identification(1, (ObjectIdentifier)identification.getSyntax().clone());
            }
            case 2: {
                return new Identification(2, identification.getPresentationContextId());
            }
            case 3: {
                return new Identification(3, identification.getContextNegotiationPresentationContextId(), (ObjectIdentifier)identification.getContextNegotiationTransferSyntax().clone());
            }
            case 4: {
                return new Identification(4, (ObjectIdentifier)identification.getTransferSyntax().clone());
            }
            case 5: {
                return new Identification(5);
            }
        }
        throw new IllegalStateException("Bad selector in identification");
    }
}

