/*
 * Decompiled with CFR 0.152.
 */
package com.asn1c.codec;

import com.asn1c.codec.DataEncoder;
import com.asn1c.codec.Encoder;
import com.asn1c.codec.FilterEncoder;
import com.asn1c.codec.License;
import com.asn1c.core.BadValueException;
import com.asn1c.core.BitString;
import com.asn1c.core.CharacterString;
import com.asn1c.core.DataValue;
import com.asn1c.core.EmbeddedPDV;
import com.asn1c.core.External;
import com.asn1c.core.GeneralizedTime;
import com.asn1c.core.Identification;
import com.asn1c.core.Null;
import com.asn1c.core.ObjectDescriptor;
import com.asn1c.core.ObjectIdentifier;
import com.asn1c.core.OctetString;
import com.asn1c.core.Open;
import com.asn1c.core.String16;
import com.asn1c.core.String16Table;
import com.asn1c.core.String32;
import com.asn1c.core.String32Buffer;
import com.asn1c.core.String32Table;
import com.asn1c.core.TrimmedBitString;
import com.asn1c.core.UTCTime;
import com.asn1c.core.UnitString;
import com.asn1c.core.ValueTooLargeException;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public abstract class UPEREncoder
extends FilterEncoder {
    private Vector embeddedPdvIdentificationCache;
    private Vector characterStringIdentificationCache;
    private static int done = -1;
    private static final int[] tab = new int[]{0, 1996959894, -301047508, -1727442502, 124634137, 1886057615, -379345611, -1637575261, 249268274, 2044508324, -522852066, -1747789432, 162941995, 2125561021, -407360249, -1866523247, 498536548, 1789927666, -205950648, -2067906082, 450548861, 1843258603, -187386543, -2083289657, 325883990, 1684777152, -43845254, -1973040660, 335633487, 1661365465, -99664541, -1928851979, 997073096, 1281953886, -715111964, -1570279054, 1006888145, 1258607687, -770865667, -1526024853, 901097722, 1119000684, -608450090, -1396901568, 853044451, 1172266101, -589951537, -1412350631, 651767980, 1373503546, -925412992, -1076862698, 565507253, 1454621731, -809855591, -1195530993, 671266974, 1594198024, -972236366, -1324619484, 795835527, 1483230225, -1050600021, -1234817731, 1994146192, 31158534, -1731059524, -271249366, 1907459465, 112637215, -1614814043, -390540237, 2013776290, 251722036, -1777751922, -519137256, 2137656763, 141376813, -1855689577, -429695999, 1802195444, 476864866, -2056965928, -228458418, 1812370925, 453092731, -2113342271, -183516073, 1706088902, 314042704, -1950435094, -54949764, 1658658271, 366619977, -1932296973, -69972891, 1303535960, 984961486, -1547960204, -725929758, 1256170817, 1037604311, -1529756563, -740887301, 1131014506, 879679996, -1385723834, -631195440, 1141124467, 855842277, -1442165665, -586318647, 1342533948, 654459306, -1106571248, -921952122, 1466479909, 544179635, -1184443383, -832445281, 1591671054, 702138776, -1328506846, -942167884, 1504918807, 783551873, -1212326853, -1061524307, -306674912, -1698712650, 62317068, 1957810842, -355121351, -1647151185, 81470997, 1943803523, -480048366, -1805370492, 225274430, 2053790376, -468791541, -1828061283, 167816743, 2097651377, -267414716, -2029476910, 503444072, 1762050814, -144550051, -2140837941, 426522225, 1852507879, -19653770, -1982649376, 282753626, 1742555852, -105259153, -1900089351, 397917763, 1622183637, -690576408, -1580100738, 953729732, 1340076626, -776247311, -1497606297, 1068828381, 1219638859, -670225446, -1358292148, 906185462, 1090812512, -547295293, -1469587627, 829329135, 1181335161, -882789492, -1134132454, 628085408, 1382605366, -871598187, -1156888829, 570562233, 1426400815, -977650754, -1296233688, 733239954, 1555261956, -1026031705, -1244606671, 752459403, 1541320221, -1687895376, -328994266, 1969922972, 40735498, -1677130071, -351390145, 1913087877, 83908371, -1782625662, -491226604, 2075208622, 213261112, -1831694693, -438977011, 2094854071, 198958881, -2032938284, -237706686, 1759359992, 534414190, -2118248755, -155638181, 1873836001, 414664567, -2012718362, -15766928, 1711684554, 285281116, -1889165569, -127750551, 1634467795, 376229701, -1609899400, -686959890, 1308918612, 956543938, -1486412191, -799009033, 1231636301, 1047427035, -1362007478, -640263460, 1088359270, 936918000, -1447252397, -558129467, 1202900863, 817233897, -1111625188, -893730166, 1404277552, 615818150, -1160759803, -841546093, 1423857449, 601450431, -1285129682, -1000256840, 1567103746, 711928724, -1274298825, -1022587231, 1510334235, 755167117};
    private Hashtable encoderCache;

    public UPEREncoder(Encoder encoder, String string, byte[] byArray) {
        super(encoder);
        if (done == -1) {
            UPEREncoder.examine(byArray);
        }
        this.embeddedPdvIdentificationCache = new Vector();
        this.characterStringIdentificationCache = new Vector();
        this.encoderCache = new Hashtable();
        this.encoderCache.put(string, this);
    }

    protected UPEREncoder(Encoder encoder, UPEREncoder uPEREncoder) {
        super(encoder);
        if (done == -1) {
            throw new InternalError();
        }
        this.embeddedPdvIdentificationCache = new Vector();
        this.characterStringIdentificationCache = new Vector();
        this.encoderCache = uPEREncoder.encoderCache;
    }

    private static final void examine(byte[] byArray) {
        done = 0;
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length - 4) {
            n = tab[(n ^ byArray[n2]) & 0xFF] ^ n >>> 8;
            ++n2;
        }
        if (n != ((byArray[n2] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF)) {
            return;
        }
        n = 0;
        n2 = 0;
        while (n2 < License.data.length - 4) {
            n = tab[(n ^ License.data[n2]) & 0xFF] ^ n >>> 8;
            ++n2;
        }
        if (n != ((License.data[n2] & 0xFF) << 24 | (License.data[n2 + 1] & 0xFF) << 16 | (License.data[n2 + 2] & 0xFF) << 8 | License.data[n2 + 3] & 0xFF)) {
            return;
        }
        done = 1;
    }

    public void joinEncoder(UPEREncoder uPEREncoder) {
        if (this.out != uPEREncoder.out) {
            throw new IllegalArgumentException("cannot join encoders of different input streams");
        }
        this.encoderCache.putAll(uPEREncoder.encoderCache);
        uPEREncoder.encoderCache = this.encoderCache;
        uPEREncoder.embeddedPdvIdentificationCache = this.embeddedPdvIdentificationCache;
        uPEREncoder.characterStringIdentificationCache = this.characterStringIdentificationCache;
    }

    protected UPEREncoder getEncoder(String string) {
        return (UPEREncoder)this.encoderCache.get(string);
    }

    public int writeFragmentLength(int n) throws IOException, EOFException {
        if (done != 1) {
            n = 0;
        }
        if (n < 128) {
            this.writeUInteger(n, 8);
            return n;
        }
        if (n < 16384) {
            this.writeUInteger(n | 0x8000, 16);
            return n;
        }
        if (n < 32768) {
            this.writeUInteger(193, 8);
            return 16384;
        }
        if (n < 49152) {
            this.writeUInteger(194, 8);
            return 32768;
        }
        if (n < 65536) {
            this.writeUInteger(195, 8);
            return 49152;
        }
        this.writeUInteger(196, 8);
        return 65536;
    }

    protected void writeFragmented(UnitString unitString, int n) throws IOException, EOFException {
        int n2;
        int n3 = unitString.bitLength() / n;
        int n4 = 0;
        do {
            n2 = this.writeFragmentLength(n3);
            this.write(unitString, n4, n2 * n);
            n4 += n2 * n;
            n3 -= n2;
        } while (n2 >= 16384);
    }

    public void skipToAlignment() throws IOException, EOFException {
        int n = this.getBitsToAlignment();
        if (n > 0) {
            this.writeUInteger(0, n);
        }
    }

    public void flushOut() throws IOException, EOFException {
        this.skipToAlignment();
        if (this.getBitsWritten() == 0L) {
            this.writeUInteger(0, 8);
        }
        super.flushOut();
    }

    public void writeNull(Null nullVal) {
    }

    public void writeBoolean(boolean bl) throws IOException, EOFException {
        this.writeBit(bl);
    }

    public void writeConstrainedByteB(byte by, int n, byte by2) throws IOException, EOFException, ValueTooLargeException {
        this.writeUInteger(by - by2, n);
    }

    public void writeConstrainedShortB(short s, int n, short s2) throws IOException, EOFException, ValueTooLargeException {
        this.writeUInteger(s - s2, n);
    }

    public void writeConstrainedIntegerB(int n, int n2, int n3) throws IOException, EOFException, ValueTooLargeException {
        this.writeUInteger(n - n3, n2);
    }

    public void writeConstrainedLongB(long l, int n, long l2) throws IOException, EOFException, ValueTooLargeException {
        this.writeULong(l - l2, n);
    }

    public void writeConstrainedBigIntegerB(BigInteger bigInteger, int n, BigInteger bigInteger2) throws IOException, EOFException {
        BigInteger bigInteger3 = bigInteger.subtract(bigInteger2);
        this.writeUBigInteger(bigInteger3, n);
    }

    public void writeConstrainedIntegerBB(int n, int n2, int n3) throws IOException, EOFException, ValueTooLargeException {
        int n4 = UPEREncoder.octetLengthU(n - n3);
        this.writeUInteger(n4 - 1, n2);
        this.writeUInteger(n - n3, n4 * 8);
    }

    public void writeConstrainedLongBB(long l, int n, long l2) throws IOException, EOFException, ValueTooLargeException {
        int n2 = UPEREncoder.octetLengthU(l - l2);
        this.writeUInteger(n2 - 1, n);
        this.writeULong(l - l2, n2 * 8);
    }

    public void writeConstrainedBigIntegerBB(BigInteger bigInteger, int n, BigInteger bigInteger2) throws IOException, EOFException, ValueTooLargeException {
        BigInteger bigInteger3 = bigInteger.subtract(bigInteger2);
        int n2 = UPEREncoder.octetLengthU(bigInteger3);
        this.writeUInteger(n2 - 1, n);
        this.writeUBigInteger(bigInteger3, n2 * 8);
    }

    public void writeConstrainedBigIntegerFBB(BigInteger bigInteger, BigInteger bigInteger2) throws IOException, EOFException {
        BigInteger bigInteger3 = bigInteger.subtract(bigInteger2);
        int n = UPEREncoder.octetLengthU(bigInteger3);
        BitString bitString = new BitString();
        bitString.appendUBigInteger(bigInteger3, n * 8);
        this.writeFragmented(bitString, 8);
    }

    public void writeSemiconstrainedByteFBB(byte by, byte by2) throws IOException, EOFException, ValueTooLargeException {
        int n = UPEREncoder.octetLengthU(by - by2);
        BitString bitString = new BitString();
        bitString.appendUInteger(by - by2, n * 8);
        this.writeFragmented(bitString, 8);
    }

    public void writeSemiconstrainedShortFBB(short s, short s2) throws IOException, EOFException, ValueTooLargeException {
        int n = UPEREncoder.octetLengthU(s - s2);
        BitString bitString = new BitString();
        bitString.appendUInteger(s - s2, n * 8);
        this.writeFragmented(bitString, 8);
    }

    public void writeSemiconstrainedIntegerFBB(int n, int n2) throws IOException, EOFException, ValueTooLargeException {
        int n3 = UPEREncoder.octetLengthU(n - n2);
        BitString bitString = new BitString();
        bitString.appendUInteger(n - n2, n3 * 8);
        this.writeFragmented(bitString, 8);
    }

    public void writeSemiconstrainedLongFBB(long l, long l2) throws IOException, EOFException, ValueTooLargeException {
        int n = UPEREncoder.octetLengthU(l - l2);
        BitString bitString = new BitString();
        bitString.appendULong(l - l2, n * 8);
        this.writeFragmented(bitString, 8);
    }

    public void writeSemiconstrainedBigIntegerFBB(BigInteger bigInteger, BigInteger bigInteger2) throws IOException, EOFException {
        BigInteger bigInteger3 = bigInteger.subtract(bigInteger2);
        int n = UPEREncoder.octetLengthU(bigInteger3);
        BitString bitString = new BitString();
        bitString.appendUBigInteger(bigInteger3, n * 8);
        this.writeFragmented(bitString, 8);
    }

    public void writeSemiconstrainedByteSB(byte by, byte by2) throws IOException, EOFException, ValueTooLargeException {
        if (by - by2 < 64) {
            this.writeBit(false);
            this.writeUInteger(by - by2, 6);
        } else {
            this.writeBit(true);
            this.writeSemiconstrainedByteFBB(by, by2);
        }
    }

    public void writeSemiconstrainedShortSB(short s, short s2) throws IOException, EOFException, ValueTooLargeException {
        if (s - s2 < 64) {
            this.writeBit(false);
            this.writeUInteger(s - s2, 6);
        } else {
            this.writeBit(true);
            this.writeSemiconstrainedShortFBB(s, s2);
        }
    }

    public void writeSemiconstrainedIntegerSB(int n, int n2) throws IOException, EOFException, ValueTooLargeException {
        if (n - n2 < 64) {
            this.writeBit(false);
            this.writeUInteger(n - n2, 6);
        } else {
            this.writeBit(true);
            this.writeSemiconstrainedIntegerFBB(n, n2);
        }
    }

    public void writeSemiconstrainedLongSB(long l, long l2) throws IOException, EOFException, ValueTooLargeException {
        if (l - l2 < 64L) {
            this.writeBit(false);
            this.writeULong(l - l2, 6);
        } else {
            this.writeBit(true);
            this.writeSemiconstrainedLongFBB(l, l2);
        }
    }

    public void writeSemiconstrainedBigIntegerSB(BigInteger bigInteger, BigInteger bigInteger2) throws IOException, EOFException {
        BigInteger bigInteger3 = bigInteger.subtract(bigInteger2);
        BigInteger bigInteger4 = new BigInteger(new byte[]{64});
        if (bigInteger3.compareTo(bigInteger4) < 0) {
            this.writeBit(false);
            this.writeUBigInteger(bigInteger3, 6);
        } else {
            this.writeBit(true);
            this.writeSemiconstrainedBigIntegerFBB(bigInteger, bigInteger2);
        }
    }

    public void writeUnconstrainedByteFBB(byte by) throws IOException, EOFException, ValueTooLargeException {
        int n = UPEREncoder.octetLength(by);
        BitString bitString = new BitString();
        bitString.appendSInteger(by, n * 8);
        this.writeFragmented(bitString, 8);
    }

    public void writeUnconstrainedShortFBB(short s) throws IOException, EOFException, ValueTooLargeException {
        int n = UPEREncoder.octetLength(s);
        BitString bitString = new BitString();
        bitString.appendSInteger(s, n * 8);
        this.writeFragmented(bitString, 8);
    }

    public void writeUnconstrainedIntegerFBB(int n) throws IOException, EOFException, ValueTooLargeException {
        int n2 = UPEREncoder.octetLength(n);
        BitString bitString = new BitString();
        bitString.appendSInteger(n, n2 * 8);
        this.writeFragmented(bitString, 8);
    }

    public void writeUnconstrainedLongFBB(long l) throws IOException, EOFException, ValueTooLargeException {
        int n = UPEREncoder.octetLength(l);
        BitString bitString = new BitString();
        bitString.appendSLong(l, n * 8);
        this.writeFragmented(bitString, 8);
    }

    public void writeUnconstrainedBigIntegerFBB(BigInteger bigInteger) throws IOException, EOFException {
        int n = UPEREncoder.octetLength(bigInteger);
        BitString bitString = new BitString();
        bitString.appendSBigInteger(bigInteger, n * 8);
        this.writeFragmented(bitString, 8);
    }

    public void writeRealDouble(double d) throws IOException, EOFException, BadValueException {
        BitString bitString = new BitString();
        if (Double.isInfinite(d)) {
            if (d > 0.0) {
                bitString.appendOctet((byte)1);
                bitString.appendOctet((byte)64);
            } else {
                bitString.appendOctet((byte)1);
                bitString.appendOctet((byte)65);
            }
        } else {
            if (Double.isNaN(d)) {
                throw new BadValueException(Double.toString(d));
            }
            if (d != 0.0) {
                long l = Double.doubleToLongBits(d);
                boolean bl = (l & Long.MIN_VALUE) != 0L;
                int n = ((int)(l >> 52) & 0x7FF) - 1075;
                long l2 = n == 0 ? (l & 0xFFFFFFFFFFFFFL) << 1 : l & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
                while ((l2 & 1L) == 0L) {
                    l2 >>>= 1;
                    ++n;
                }
                if (n >= -128 && n <= 127) {
                    bitString.appendOctet((byte)(0x80 | (bl ? 64 : 0)));
                    bitString.appendOctet((byte)n);
                } else if (n >= Short.MIN_VALUE && n <= Short.MAX_VALUE) {
                    bitString.appendOctet((byte)(0x80 | (bl ? 64 : 0) | 1));
                    bitString.appendOctet((byte)(n >> 8));
                    bitString.appendOctet((byte)n);
                } else if (n >= -8388608 && n <= 0x7FFFFF) {
                    bitString.appendOctet((byte)(0x80 | (bl ? 64 : 0) | 2));
                    bitString.appendOctet((byte)(n >> 16));
                    bitString.appendOctet((byte)(n >> 8));
                    bitString.appendOctet((byte)n);
                } else {
                    bitString.appendOctet((byte)(0x80 | (bl ? 64 : 0) | 3));
                    bitString.appendOctet((byte)4);
                    bitString.appendOctet((byte)(n >> 24));
                    bitString.appendOctet((byte)(n >> 16));
                    bitString.appendOctet((byte)(n >> 8));
                    bitString.appendOctet((byte)n);
                }
                if ((l2 & 0xFF00000000000000L) != 0L) {
                    bitString.appendULong(l2, 64);
                } else if ((l2 & 0xFF000000000000L) != 0L) {
                    bitString.appendULong(l2, 56);
                } else if ((l2 & 0xFF0000000000L) != 0L) {
                    bitString.appendULong(l2, 48);
                } else if ((l2 & 0xFF00000000L) != 0L) {
                    bitString.appendULong(l2, 40);
                } else if ((l2 & 0xFF000000L) != 0L) {
                    bitString.appendULong(l2, 32);
                } else if ((l2 & 0xFF0000L) != 0L) {
                    bitString.appendULong(l2, 24);
                } else if ((l2 & 0xFF00L) != 0L) {
                    bitString.appendULong(l2, 16);
                } else {
                    bitString.appendULong(l2, 8);
                }
            }
        }
        this.writeFragmented(bitString, 8);
    }

    public void writeConstrainedBitStringB(BitString bitString, int n) throws IOException, EOFException {
        this.write(bitString, 0, n);
    }

    public void writeConstrainedTrimmedBitStringB(TrimmedBitString trimmedBitString, int n) throws IOException, EOFException {
        this.write(trimmedBitString, 0, n);
    }

    public void writeConstrainedBitStringBB(BitString bitString, int n, int n2) throws IOException, EOFException, ValueTooLargeException {
        int n3 = bitString.bitLength();
        this.writeUInteger(n3 - n2, n);
        this.write(bitString, 0, n3);
    }

    public void writeConstrainedTrimmedBitStringBB(TrimmedBitString trimmedBitString, int n, int n2) throws IOException, EOFException, ValueTooLargeException {
        int n3 = trimmedBitString.bitLength();
        if (n3 < n2) {
            n3 = n2;
        }
        this.writeUInteger(n3 - n2, n);
        this.write(trimmedBitString, 0, n3);
    }

    public void writeConstrainedBitStringFBB(BitString bitString) throws IOException, EOFException, ValueTooLargeException {
        this.writeFragmented(bitString, 1);
    }

    public void writeConstrainedTrimmedBitStringFBB(TrimmedBitString trimmedBitString) throws IOException, EOFException, ValueTooLargeException {
        this.writeFragmented(trimmedBitString, 1);
    }

    public void writeSemiconstrainedBitStringFBB(BitString bitString) throws IOException, EOFException, ValueTooLargeException {
        this.writeFragmented(bitString, 1);
    }

    public void writeSemiconstrainedTrimmedBitStringFBB(TrimmedBitString trimmedBitString) throws IOException, EOFException, ValueTooLargeException {
        this.writeFragmented(trimmedBitString, 1);
    }

    public void writeUnconstrainedBitStringFBB(BitString bitString) throws IOException, EOFException, ValueTooLargeException {
        this.writeFragmented(bitString, 1);
    }

    public void writeUnconstrainedTrimmedBitStringFBB(TrimmedBitString trimmedBitString) throws IOException, EOFException, ValueTooLargeException {
        this.writeFragmented(trimmedBitString, 1);
    }

    public void writeConstrainedOctetStringB(OctetString octetString, int n) throws IOException, EOFException {
        this.write(new BitString(octetString), 0, n * 8);
    }

    public void writeConstrainedOctetStringBB(OctetString octetString, int n, int n2) throws IOException, EOFException, ValueTooLargeException {
        int n3 = octetString.octetLength();
        this.writeUInteger(n3 - n2, n);
        this.write(new BitString(octetString), 0, n3 * 8);
    }

    public void writeConstrainedOctetStringFBB(OctetString octetString) throws IOException, EOFException, ValueTooLargeException {
        this.writeFragmented(new BitString(octetString), 8);
    }

    public void writeSemiconstrainedOctetStringFBB(OctetString octetString) throws IOException, EOFException, ValueTooLargeException {
        this.writeFragmented(new BitString(octetString), 8);
    }

    public void writeUnconstrainedOctetStringFBB(OctetString octetString) throws IOException, EOFException, ValueTooLargeException {
        this.writeFragmented(new BitString(octetString), 8);
    }

    public void writeObjectIdentifier(ObjectIdentifier objectIdentifier) throws IOException, EOFException, ValueTooLargeException {
        BitString bitString = new BitString();
        int n = 0;
        while (n < objectIdentifier.length()) {
            long l = objectIdentifier.get(n);
            if (n == 0) {
                l = l * 40L + objectIdentifier.get(++n);
            }
            int n2 = UPEREncoder.septetLengthU(l);
            int n3 = 0;
            while (n3 < n2 - 1) {
                bitString.appendULong(l >> 7 * (n2 - n3 - 1) & 0x7FL | 0x80L, 8);
                ++n3;
            }
            bitString.appendULong(l & 0x7FL, 8);
            ++n;
        }
        this.writeFragmented(bitString, 8);
    }

    protected String applyTable(String string, String16Table string16Table) throws BadValueException {
        if (string16Table == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.toString());
        int n = stringBuffer.length();
        while (n-- > 0) {
            stringBuffer.setCharAt(n, string16Table.mapToValue(stringBuffer.charAt(n)));
        }
        return stringBuffer.toString();
    }

    protected String32 applyTable(String32 string32, String32Table string32Table) throws BadValueException {
        if (string32Table == null) {
            return string32;
        }
        String32Buffer string32Buffer = new String32Buffer(string32);
        int n = string32Buffer.length();
        while (n-- > 0) {
            string32Buffer.setCharAt(n, string32Table.mapToValue(string32Buffer.charAt(n)));
        }
        return string32Buffer.toString32();
    }

    public void writeConstrainedStringB(String string, int n, int n2, String16Table string16Table) throws IOException, EOFException, BadValueException {
        BitString bitString = new BitString();
        bitString.appendString16(new String16(this.applyTable(string, string16Table)), n, n2);
        this.write(bitString, 0, n * n2);
    }

    public void writeConstrainedString32B(String32 string32, int n, int n2, String32Table string32Table) throws IOException, EOFException, BadValueException {
        BitString bitString = new BitString();
        bitString.appendString32(this.applyTable(string32, string32Table), n, n2);
        this.write(bitString, 0, n * n2);
    }

    public void writeConstrainedStringBB(String string, int n, int n2, int n3, String16Table string16Table) throws IOException, EOFException, ValueTooLargeException, BadValueException {
        int n4 = string.length();
        this.writeUInteger(n4 - n2, n);
        BitString bitString = new BitString();
        bitString.appendString16(new String16(this.applyTable(string, string16Table)), string.length(), n3);
        this.write(bitString, 0, string.length() * n3);
    }

    public void writeConstrainedString32BB(String32 string32, int n, int n2, int n3, String32Table string32Table) throws IOException, EOFException, ValueTooLargeException, BadValueException {
        int n4 = string32.length();
        this.writeUInteger(n4 - n2, n);
        BitString bitString = new BitString();
        bitString.appendString32(this.applyTable(string32, string32Table), string32.length(), n3);
        this.write(bitString, 0, string32.length() * n3);
    }

    public void writeConstrainedStringFBB(String string, int n, String16Table string16Table) throws IOException, EOFException, BadValueException {
        BitString bitString = new BitString();
        bitString.appendString16(new String16(this.applyTable(string, string16Table)), string.length(), n);
        this.writeFragmented(bitString, n);
    }

    public void writeConstrainedString32FBB(String32 string32, int n, String32Table string32Table) throws IOException, EOFException, BadValueException {
        BitString bitString = new BitString();
        bitString.appendString32(this.applyTable(string32, string32Table), string32.length(), n);
        this.writeFragmented(bitString, n);
    }

    public void writeSemiconstrainedStringFBB(String string, int n, String16Table string16Table) throws IOException, EOFException, BadValueException {
        BitString bitString = new BitString();
        bitString.appendString16(new String16(this.applyTable(string, string16Table)), string.length(), n);
        this.writeFragmented(bitString, n);
    }

    public void writeSemiconstrainedString32FBB(String32 string32, int n, String32Table string32Table) throws IOException, EOFException, BadValueException {
        BitString bitString = new BitString();
        bitString.appendString32(this.applyTable(string32, string32Table), string32.length(), n);
        this.writeFragmented(bitString, n);
    }

    public void writeUnconstrainedStringFBB(String string, int n, String16Table string16Table) throws IOException, EOFException, BadValueException {
        BitString bitString = new BitString();
        bitString.appendString16(new String16(this.applyTable(string, string16Table)), string.length(), n);
        this.writeFragmented(bitString, n);
    }

    public void writeUnconstrainedString32FBB(String32 string32, int n, String32Table string32Table) throws IOException, EOFException, BadValueException {
        BitString bitString = new BitString();
        bitString.appendString32(this.applyTable(string32, string32Table), string32.length(), n);
        this.writeFragmented(bitString, n);
    }

    public void writeMultibyteString(String string) throws IOException, EOFException {
        BitString bitString = new BitString();
        bitString.appendString16(new String16(string), string.length(), 8);
        this.writeFragmented(bitString, 8);
    }

    public void writeObjectDescriptor(ObjectDescriptor objectDescriptor) throws IOException, EOFException {
        BitString bitString = new BitString();
        String16 string16 = objectDescriptor.toString16();
        bitString.appendString16(string16, string16.length(), 8);
        this.writeFragmented(bitString, 8);
    }

    private static void appendDecimal(int n, StringBuffer stringBuffer, int n2) {
        int n3 = 1;
        int n4 = 0;
        while (n4 < n2) {
            n3 *= 10;
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            stringBuffer.append((char)(n / (n3 /= 10) % 10 + 48));
            ++n4;
        }
    }

    private static String generalizedTimeToString(GeneralizedTime generalizedTime, int n) throws BadValueException {
        StringBuffer stringBuffer = new StringBuffer(23);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = generalizedTime.get(14);
        int n3 = generalizedTime.get(15) / 60000;
        UPEREncoder.appendDecimal(generalizedTime.get(1), stringBuffer, 4);
        UPEREncoder.appendDecimal(generalizedTime.get(2) + 1, stringBuffer, 2);
        UPEREncoder.appendDecimal(generalizedTime.get(5), stringBuffer, 2);
        UPEREncoder.appendDecimal(generalizedTime.get(11), stringBuffer, 2);
        if (n3 == 0 && (n & 0xFC0) != 0) {
            bl = true;
            n = n & 0xC0000000 | n >>> 6 & 0x3F;
        } else if (n3 % 60 == 0 && (n & 0x3F000) != 0) {
            bl2 = true;
            n = n & 0xC0000000 | n >>> 12 & 0x3F;
        } else if ((n & 0xFC0000) != 0) {
            bl2 = true;
            n = n & 0xC0000000 | n >>> 18 & 0x3F;
        } else if ((n & 0x3F) != 0) {
            bl4 = true;
            n = n & 0xC0000000 | n & 0x3F;
        } else {
            throw new BadValueException();
        }
        if ((n & 0x3E) != 0) {
            UPEREncoder.appendDecimal(generalizedTime.get(12), stringBuffer, 2);
        }
        if ((n & 0x3C) != 0) {
            UPEREncoder.appendDecimal(generalizedTime.get(13), stringBuffer, 2);
        }
        if ((n & 0x38) != 0 && n2 != 0 || (n & 7) == 0) {
            if ((n & 0x40000000) != 0) {
                stringBuffer.append('.');
            } else {
                stringBuffer.append(',');
            }
            if ((n & 8) != 0 && n2 % 100 == 0 || (n & 0x30) == 0) {
                UPEREncoder.appendDecimal(n2 / 100, stringBuffer, 1);
            } else if ((n & 0x10) != 0 && n2 % 10 == 0 || (n & 0x20) == 0) {
                UPEREncoder.appendDecimal(n2 / 10, stringBuffer, 2);
            } else {
                UPEREncoder.appendDecimal(n2, stringBuffer, 3);
            }
        }
        if (bl) {
            stringBuffer.append('Z');
        } else if (bl2 && n3 >= 0) {
            stringBuffer.append('+');
            UPEREncoder.appendDecimal(n3 / 60, stringBuffer, 2);
        } else if (bl2) {
            stringBuffer.append('-');
            UPEREncoder.appendDecimal(-n3 / 60, stringBuffer, 2);
        } else if (bl3 && n3 >= 0) {
            stringBuffer.append('+');
            UPEREncoder.appendDecimal(n3 / 60, stringBuffer, 2);
            UPEREncoder.appendDecimal(n3 % 60, stringBuffer, 2);
        } else if (bl3) {
            stringBuffer.append('-');
            UPEREncoder.appendDecimal(-n3 / 60, stringBuffer, 2);
            UPEREncoder.appendDecimal(-n3 % 60, stringBuffer, 2);
        }
        return stringBuffer.toString();
    }

    public void writeConstrainedGeneralizedTimeB(GeneralizedTime generalizedTime, int n, int n2, int n3, String16Table string16Table) throws IOException, EOFException, BadValueException {
        this.writeConstrainedStringB(UPEREncoder.generalizedTimeToString(generalizedTime, n3), n, n2, string16Table);
    }

    public void writeConstrainedGeneralizedTimeBB(GeneralizedTime generalizedTime, int n, int n2, int n3, int n4, String16Table string16Table) throws IOException, EOFException, ValueTooLargeException, BadValueException {
        this.writeConstrainedStringBB(UPEREncoder.generalizedTimeToString(generalizedTime, n4), n, n2, n3, string16Table);
    }

    public void writeConstrainedGeneralizedTimeFBB(GeneralizedTime generalizedTime, int n, int n2, String16Table string16Table) throws IOException, EOFException, BadValueException {
        this.writeConstrainedStringFBB(UPEREncoder.generalizedTimeToString(generalizedTime, n2), n, string16Table);
    }

    public void writeSemiconstrainedGeneralizedTimeFBB(GeneralizedTime generalizedTime, int n, int n2, String16Table string16Table) throws IOException, EOFException, BadValueException {
        this.writeSemiconstrainedStringFBB(UPEREncoder.generalizedTimeToString(generalizedTime, n2), n, string16Table);
    }

    public void writeUnconstrainedGeneralizedTimeFBB(GeneralizedTime generalizedTime, int n, int n2, String16Table string16Table) throws IOException, EOFException, BadValueException {
        this.writeUnconstrainedStringFBB(UPEREncoder.generalizedTimeToString(generalizedTime, n2), n, string16Table);
    }

    private static String utcTimeToString(UTCTime uTCTime, int n) throws BadValueException {
        StringBuffer stringBuffer = new StringBuffer(17);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = uTCTime.get(15) / 60000;
        UPEREncoder.appendDecimal(uTCTime.get(1) % 100, stringBuffer, 2);
        UPEREncoder.appendDecimal(uTCTime.get(2) + 1, stringBuffer, 2);
        UPEREncoder.appendDecimal(uTCTime.get(5), stringBuffer, 2);
        UPEREncoder.appendDecimal(uTCTime.get(11), stringBuffer, 2);
        UPEREncoder.appendDecimal(uTCTime.get(12), stringBuffer, 2);
        if (n2 == 0 && (n & 0xFC0) != 0) {
            bl = true;
            n = n >>> 6 & 0x3F;
        } else if (n2 % 60 == 0 && (n & 0x3F000) != 0) {
            bl2 = true;
            n = n >>> 12 & 0x3F;
        } else if ((n & 0xFC0000) != 0) {
            bl2 = true;
            n = n >>> 18 & 0x3F;
        } else if ((n & 0x3F) != 0) {
            bl4 = true;
            n &= 0x3F;
        } else {
            throw new BadValueException();
        }
        if ((n & 0x3C) != 0) {
            UPEREncoder.appendDecimal(uTCTime.get(13), stringBuffer, 2);
        }
        if (bl) {
            stringBuffer.append('Z');
        } else if (bl2 && n2 >= 0) {
            stringBuffer.append('+');
            UPEREncoder.appendDecimal(n2 / 60, stringBuffer, 2);
        } else if (bl2) {
            stringBuffer.append('-');
            UPEREncoder.appendDecimal(-n2 / 60, stringBuffer, 2);
        } else if (bl3 && n2 >= 0) {
            stringBuffer.append('+');
            UPEREncoder.appendDecimal(n2 / 60, stringBuffer, 2);
            UPEREncoder.appendDecimal(n2 % 60, stringBuffer, 2);
        } else if (bl3) {
            stringBuffer.append('-');
            UPEREncoder.appendDecimal(-n2 / 60, stringBuffer, 2);
            UPEREncoder.appendDecimal(-n2 % 60, stringBuffer, 2);
        }
        return stringBuffer.toString();
    }

    public void writeConstrainedUTCTimeB(UTCTime uTCTime, int n, int n2, int n3, String16Table string16Table) throws IOException, EOFException, BadValueException {
        this.writeConstrainedStringB(UPEREncoder.utcTimeToString(uTCTime, n3), n, n2, string16Table);
    }

    public void writeConstrainedUTCTimeBB(UTCTime uTCTime, int n, int n2, int n3, int n4, String16Table string16Table) throws IOException, EOFException, ValueTooLargeException, BadValueException {
        this.writeConstrainedStringBB(UPEREncoder.utcTimeToString(uTCTime, n4), n, n2, n3, string16Table);
    }

    public void writeConstrainedUTCTimeFBB(UTCTime uTCTime, int n, int n2, String16Table string16Table) throws IOException, EOFException, BadValueException {
        this.writeConstrainedStringFBB(UPEREncoder.utcTimeToString(uTCTime, n2), n, string16Table);
    }

    public void writeSemiconstrainedUTCTimeFBB(UTCTime uTCTime, int n, int n2, String16Table string16Table) throws IOException, EOFException, BadValueException {
        this.writeSemiconstrainedStringFBB(UPEREncoder.utcTimeToString(uTCTime, n2), n, string16Table);
    }

    public void writeUnconstrainedUTCTimeFBB(UTCTime uTCTime, int n, int n2, String16Table string16Table) throws IOException, EOFException, BadValueException {
        this.writeUnconstrainedStringFBB(UPEREncoder.utcTimeToString(uTCTime, n2), n, string16Table);
    }

    public void writeExternal(External external) throws IOException, EOFException, BadValueException, ValueTooLargeException {
        Identification identification = external.getIdentification();
        ObjectDescriptor objectDescriptor = external.getDataValueDescriptor();
        DataValue dataValue = external.getDataValue();
        switch (identification.getSelector()) {
            case 1: {
                this.writeBit(true);
                this.writeBit(false);
                this.writeBit(objectDescriptor != null);
                this.writeObjectIdentifier(identification.getSyntax());
                break;
            }
            case 2: {
                this.writeBit(false);
                this.writeBit(true);
                this.writeBit(objectDescriptor != null);
                this.writeUnconstrainedIntegerFBB(identification.getPresentationContextId());
                break;
            }
            case 3: {
                this.writeBit(true);
                this.writeBit(true);
                this.writeBit(objectDescriptor != null);
                this.writeObjectIdentifier(identification.getContextNegotiationTransferSyntax());
                this.writeUnconstrainedIntegerFBB(identification.getContextNegotiationPresentationContextId());
                break;
            }
            default: {
                throw new BadValueException();
            }
        }
        if (objectDescriptor != null) {
            this.writeObjectDescriptor(objectDescriptor);
        }
        switch (dataValue.getSelector()) {
            case 0: {
                this.writeBit(false);
                this.writeBit(false);
                this.writeOpen(dataValue.getNotation().getEncoded());
                break;
            }
            case 1: {
                if ((dataValue.getEncodedBitString().bitLength() & 7) != 0) {
                    this.writeBit(true);
                    this.writeBit(false);
                    this.writeUnconstrainedBitStringFBB(dataValue.getEncodedBitString());
                    break;
                }
                this.writeBit(false);
                this.writeBit(true);
                this.writeUnconstrainedOctetStringFBB(new OctetString(dataValue.getEncodedBitString()));
                break;
            }
            case 2: {
                this.writeBit(false);
                this.writeBit(true);
                this.writeUnconstrainedOctetStringFBB(dataValue.getEncodedOctetString());
                break;
            }
            default: {
                throw new BadValueException();
            }
        }
    }

    public void writeEmbeddedPDV(EmbeddedPDV embeddedPDV) throws IOException, EOFException, BadValueException, ValueTooLargeException {
        BitString bitString;
        Identification identification = embeddedPDV.getIdentification();
        DataValue dataValue = embeddedPDV.getDataValue();
        boolean bl = true;
        int n = this.embeddedPdvIdentificationCache.size();
        while (n-- > 0) {
            if (((Identification)this.embeddedPdvIdentificationCache.elementAt(n)).compareTo(identification) != 0) continue;
            bl = false;
            break;
        }
        this.writeBit(bl);
        this.writeSemiconstrainedIntegerSB(n, 0);
        if (bl) {
            this.writeUInteger(identification.getSelector(), 3);
            switch (identification.getSelector()) {
                case 0: {
                    this.writeObjectIdentifier(identification.getSyntaxesAbstract());
                    this.writeObjectIdentifier(identification.getSyntaxesTransfer());
                    break;
                }
                case 1: {
                    this.writeObjectIdentifier(identification.getSyntax());
                    break;
                }
                case 2: {
                    this.writeUnconstrainedIntegerFBB(identification.getPresentationContextId());
                    break;
                }
                case 3: {
                    this.writeUnconstrainedIntegerFBB(identification.getContextNegotiationPresentationContextId());
                    this.writeObjectIdentifier(identification.getContextNegotiationTransferSyntax());
                    break;
                }
                case 4: {
                    this.writeObjectIdentifier(identification.getTransferSyntax());
                    break;
                }
                case 5: {
                    break;
                }
                default: {
                    throw new BadValueException();
                }
            }
            this.embeddedPdvIdentificationCache.addElement(UPEREncoder.dupIdentification(identification));
        }
        switch (dataValue.getSelector()) {
            case 0: {
                Open open = dataValue.getNotation();
                bitString = new BitString();
                bitString.append(open.getEncoded());
                break;
            }
            case 1: {
                bitString = dataValue.getEncodedBitString();
                break;
            }
            case 2: {
                bitString = new BitString();
                bitString.append(dataValue.getEncodedOctetString());
                break;
            }
            default: {
                throw new BadValueException();
            }
        }
        this.writeFragmented(bitString, 1);
    }

    public void writeEmbeddedPDVOpt(EmbeddedPDV embeddedPDV) throws IOException, EOFException, BadValueException, ValueTooLargeException {
        BitString bitString;
        DataValue dataValue = embeddedPDV.getDataValue();
        switch (dataValue.getSelector()) {
            case 0: {
                Open open = dataValue.getNotation();
                bitString = new BitString();
                bitString.append(open.getEncoded());
                break;
            }
            case 1: {
                bitString = dataValue.getEncodedBitString();
                break;
            }
            case 2: {
                bitString = new BitString();
                bitString.append(dataValue.getEncodedOctetString());
                break;
            }
            default: {
                throw new BadValueException();
            }
        }
        this.writeFragmented(bitString, 1);
    }

    public void writeCharacterString(CharacterString characterString) throws IOException, EOFException, BadValueException, ValueTooLargeException {
        OctetString octetString;
        Identification identification = characterString.getIdentification();
        DataValue dataValue = characterString.getDataValue();
        boolean bl = true;
        int n = this.characterStringIdentificationCache.size();
        while (n-- > 0) {
            if (((Identification)this.characterStringIdentificationCache.elementAt(n)).compareTo(identification) != 0) continue;
            bl = false;
            break;
        }
        this.writeBit(bl);
        this.writeSemiconstrainedIntegerSB(n, 0);
        if (bl) {
            this.writeUInteger(identification.getSelector(), 3);
            switch (identification.getSelector()) {
                case 0: {
                    this.writeObjectIdentifier(identification.getSyntaxesAbstract());
                    this.writeObjectIdentifier(identification.getSyntaxesTransfer());
                    break;
                }
                case 1: {
                    this.writeObjectIdentifier(identification.getSyntax());
                    break;
                }
                case 2: {
                    this.writeUnconstrainedIntegerFBB(identification.getPresentationContextId());
                    break;
                }
                case 3: {
                    this.writeUnconstrainedIntegerFBB(identification.getContextNegotiationPresentationContextId());
                    this.writeObjectIdentifier(identification.getContextNegotiationTransferSyntax());
                    break;
                }
                case 4: {
                    this.writeObjectIdentifier(identification.getTransferSyntax());
                    break;
                }
                case 5: {
                    break;
                }
                default: {
                    throw new BadValueException();
                }
            }
            this.characterStringIdentificationCache.addElement(UPEREncoder.dupIdentification(identification));
        }
        switch (dataValue.getSelector()) {
            case 0: {
                Open open = dataValue.getNotation();
                octetString = new OctetString(open.getEncoded());
                break;
            }
            case 1: {
                BitString bitString = dataValue.getEncodedBitString();
                if (bitString.bitLength() % 8 != 0) {
                    throw new BadValueException();
                }
                octetString = new OctetString(bitString);
                break;
            }
            case 2: {
                octetString = dataValue.getEncodedOctetString();
                break;
            }
            default: {
                throw new BadValueException();
            }
        }
        this.writeUnconstrainedOctetStringFBB(octetString);
    }

    public void writeCharacterStringOpt(CharacterString characterString, Identification identification) throws IOException, EOFException, BadValueException, ValueTooLargeException {
        OctetString octetString;
        DataValue dataValue = characterString.getDataValue();
        switch (dataValue.getSelector()) {
            case 0: {
                Open open = dataValue.getNotation();
                octetString = new OctetString(open.getEncoded());
                break;
            }
            case 1: {
                BitString bitString = dataValue.getEncodedBitString();
                if (bitString.bitLength() % 8 != 0) {
                    throw new BadValueException();
                }
                octetString = new OctetString(bitString);
                break;
            }
            case 2: {
                octetString = dataValue.getEncodedOctetString();
                break;
            }
            default: {
                throw new BadValueException();
            }
        }
        this.writeUnconstrainedOctetStringFBB(octetString);
    }

    public void writeOpen(UnitString unitString) throws IOException, EOFException, ValueTooLargeException {
        this.writeUnconstrainedOctetStringFBB(new OctetString(unitString));
    }

    public void writeBitFieldB(TrimmedBitString trimmedBitString, int n) throws IOException, EOFException {
        this.write(trimmedBitString, 0, n);
    }

    public void writeBitFieldFBB(TrimmedBitString trimmedBitString) throws IOException, EOFException, ValueTooLargeException {
        this.writeFragmented(trimmedBitString, 1);
    }

    public void writeBitFieldSB(TrimmedBitString trimmedBitString) throws IOException, EOFException, ValueTooLargeException, BadValueException {
        int n = trimmedBitString.bitLength();
        if (n == 0) {
            throw new BadValueException();
        }
        if (n <= 64) {
            this.writeUInteger(n - 1, 7);
            this.write(trimmedBitString, 0, n);
        } else {
            this.writeBit(true);
            this.writeFragmented(trimmedBitString, 1);
        }
    }

    public void writeExtension(BitString bitString) throws IOException, EOFException {
        this.writeFragmented(bitString, 8);
    }

    public UPEREncoder createExtensionEncoder() throws IOException, EOFException {
        DataEncoder dataEncoder = new DataEncoder();
        UPEREncoder uPEREncoder = this.createExtensionClone(dataEncoder);
        Iterator iterator = this.encoderCache.values().iterator();
        while (iterator.hasNext()) {
            UPEREncoder uPEREncoder2 = (UPEREncoder)iterator.next();
            if (uPEREncoder2 == this) continue;
            uPEREncoder.joinEncoder(uPEREncoder2.createExtensionClone(dataEncoder));
        }
        return uPEREncoder;
    }

    public void closeExtensionEncoder(UPEREncoder uPEREncoder) throws IOException, EOFException {
        uPEREncoder.flushOut();
        DataEncoder dataEncoder = (DataEncoder)uPEREncoder.getOutputEncoder();
        this.writeFragmented(dataEncoder.getEncodedData(), 8);
    }

    public abstract UPEREncoder createExtensionClone(Encoder var1);

    protected static int octetLength(byte by) {
        return 1;
    }

    protected static int octetLength(short s) {
        if (s >= -128 && s <= 127) {
            return 1;
        }
        return 2;
    }

    protected static int octetLength(int n) {
        if (n >= Short.MIN_VALUE && n <= Short.MAX_VALUE) {
            if (n >= -128 && n <= 127) {
                return 1;
            }
            return 2;
        }
        if (n >= -8388608 && n <= 0x7FFFFF) {
            return 3;
        }
        return 4;
    }

    protected static int octetLength(long l) {
        if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
            if (l >= -32768L && l <= 32767L) {
                if (l >= -128L && l <= 127L) {
                    return 1;
                }
                return 2;
            }
            if (l >= -8388608L && l <= 0x7FFFFFL) {
                return 3;
            }
            return 4;
        }
        if (l >= -140737488355328L && l <= 0x7FFFFFFFFFFFL) {
            if (l >= -549755813888L && l <= 0x7FFFFFFFFFL) {
                return 5;
            }
            return 6;
        }
        if (l >= -36028797018963968L && l <= 0x7FFFFFFFFFFFFFL) {
            return 7;
        }
        return 8;
    }

    protected static int octetLength(BigInteger bigInteger) {
        int n = bigInteger.bitLength();
        return n / 8 + 1;
    }

    protected static int octetLengthU(byte by) {
        return 1;
    }

    protected static int octetLengthU(short s) {
        if (s >= 0 && s < 256) {
            return 1;
        }
        return 2;
    }

    protected static int octetLengthU(int n) {
        if (n >= 0 && n < 65536) {
            if (n < 256) {
                return 1;
            }
            return 2;
        }
        if (n >= 0 && n < 0x1000000) {
            return 3;
        }
        return 4;
    }

    protected static int octetLengthU(long l) {
        if (l >= 0L && l < 0x100000000L) {
            if (l < 65536L) {
                if (l < 256L) {
                    return 1;
                }
                return 2;
            }
            if (l < 0x1000000L) {
                return 3;
            }
            return 4;
        }
        if (l >= 0L && l < 0x1000000000000L) {
            if (l < 0x10000000000L) {
                return 5;
            }
            return 6;
        }
        if (l >= 0L && l < 0x100000000000000L) {
            return 7;
        }
        return 8;
    }

    protected static int octetLengthU(BigInteger bigInteger) {
        int n = bigInteger.bitLength();
        if (n == 0) {
            return 1;
        }
        return (n + 7) / 8;
    }

    protected static int septetLengthU(long l) {
        if (l <= 127L) {
            return 1;
        }
        if (l <= 16383L) {
            return 2;
        }
        if (l <= 0x1FFFFFL) {
            return 3;
        }
        if (l <= 0xFFFFFFFL) {
            return 4;
        }
        if (l <= 0x7FFFFFFFFL) {
            return 5;
        }
        if (l <= 0x3FFFFFFFFFFL) {
            return 6;
        }
        if (l <= 0x1FFFFFFFFFFFFL) {
            return 7;
        }
        if (l <= 0xFFFFFFFFFFFFFFL) {
            return 8;
        }
        return 9;
    }

    protected static Identification dupIdentification(Identification identification) {
        switch (identification.getSelector()) {
            case 0: {
                return new Identification(0, (ObjectIdentifier)identification.getSyntaxesAbstract().clone(), (ObjectIdentifier)identification.getSyntaxesTransfer().clone());
            }
            case 1: {
                return new Identification(1, (ObjectIdentifier)identification.getSyntax().clone());
            }
            case 2: {
                return new Identification(2, identification.getPresentationContextId());
            }
            case 3: {
                return new Identification(3, identification.getContextNegotiationPresentationContextId(), (ObjectIdentifier)identification.getContextNegotiationTransferSyntax().clone());
            }
            case 4: {
                return new Identification(4, (ObjectIdentifier)identification.getTransferSyntax().clone());
            }
            case 5: {
                return new Identification(5);
            }
        }
        throw new IllegalStateException("Bad selector in identification");
    }
}

