/*
 * Decompiled with CFR 0.152.
 */
package com.asn1c.core;

import com.asn1c.core.ASN1Object;
import com.asn1c.core.BitString;
import com.asn1c.core.OctetString;
import com.asn1c.core.Open;
import com.asn1c.core.String16;
import com.asn1c.core.String32;
import java.io.PrintWriter;

public class DataValue
implements ASN1Object,
Comparable {
    protected int selector;
    public static final int NOTATION_SELECTED = 0;
    public static final int ENCODEDBITSTRING_SELECTED = 1;
    public static final int ENCODEDOCTETSTRING_SELECTED = 2;
    protected ASN1Object dataValue;

    public DataValue(int n, Open open) {
        if (n != 0) {
            throw new IllegalArgumentException();
        }
        this.selector = n;
        this.dataValue = open;
    }

    public DataValue(int n, BitString bitString) {
        if (n != 1) {
            throw new IllegalArgumentException();
        }
        this.selector = n;
        this.dataValue = bitString;
    }

    public DataValue(int n, OctetString octetString) {
        if (n != 2) {
            throw new IllegalArgumentException();
        }
        this.selector = n;
        this.dataValue = octetString;
    }

    public DataValue(DataValue dataValue) {
        this.selector = dataValue.selector;
        switch (this.selector) {
            case 0: {
                this.dataValue = new Open((Open)dataValue.dataValue);
                break;
            }
            case 1: {
                this.dataValue = new BitString((BitString)dataValue.dataValue);
                break;
            }
            case 2: {
                this.dataValue = new OctetString((OctetString)dataValue.dataValue);
            }
        }
    }

    public DataValue() {
        this.selector = -1;
        this.dataValue = null;
    }

    public void setValue(int n, ASN1Object aSN1Object) {
        this.selector = n;
        this.dataValue = aSN1Object;
    }

    public void print(PrintWriter printWriter, String string, String string2, String string3, int n) {
        switch (this.selector) {
            case 0: {
                printWriter.println(string + string2 + "notation:");
                this.dataValue.print(printWriter, string + "    ", "", string3, n);
                break;
            }
            case 1: {
                printWriter.println(string + string2 + "encoded-bit-string:");
                this.dataValue.print(printWriter, string + "    ", "", string3, n);
                break;
            }
            case 2: {
                printWriter.println(string + string2 + "encoded-octet-string:");
                this.dataValue.print(printWriter, string + "    ", "", string3, n);
                break;
            }
            default: {
                printWriter.println(string + string2 + "INVALID" + string3);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.selector) {
            case 0: {
                stringBuffer.append("notation: ");
                stringBuffer.append(this.dataValue);
                break;
            }
            case 1: {
                stringBuffer.append("encoded-bit-string: ");
                stringBuffer.append(this.dataValue);
                break;
            }
            case 2: {
                stringBuffer.append("encoded-octet-string: ");
                stringBuffer.append(this.dataValue);
                break;
            }
            default: {
                stringBuffer.append("INVALID");
            }
        }
        return stringBuffer.toString();
    }

    public String16 toString16() {
        return new String16(this.toString());
    }

    public String32 toString32() {
        return new String32(this.toString());
    }

    public int getSelector() {
        return this.selector;
    }

    public void setSelector(int n) {
        if (this.selector == n) {
            return;
        }
        this.selector = n;
        this.dataValue = null;
    }

    public Open getNotation() {
        if (this.selector != 0) {
            throw new IllegalStateException();
        }
        return (Open)this.dataValue;
    }

    public void setNotation(Open open) {
        this.setSelector(0);
        this.dataValue = open;
    }

    public BitString getEncodedBitString() {
        if (this.selector != 1) {
            throw new IllegalStateException();
        }
        return (BitString)this.dataValue;
    }

    public void setEncodedBitString(BitString bitString) {
        this.setSelector(1);
        this.dataValue = bitString;
    }

    public OctetString getEncodedOctetString() {
        if (this.selector != 2) {
            throw new IllegalStateException();
        }
        return (OctetString)this.dataValue;
    }

    public void setEncodedOctetString(OctetString octetString) {
        this.setSelector(2);
        this.dataValue = octetString;
    }

    public int compareTo(Object object) {
        DataValue dataValue = (DataValue)object;
        if (this.selector != dataValue.selector) {
            return this.selector - dataValue.selector;
        }
        switch (this.selector) {
            case 0: {
                return ((Open)this.dataValue).compareTo((Open)dataValue.dataValue);
            }
            case 1: {
                return ((BitString)this.dataValue).compareTo((BitString)dataValue.dataValue);
            }
            case 2: {
                return ((OctetString)this.dataValue).compareTo((OctetString)dataValue.dataValue);
            }
        }
        return 0;
    }
}

