/*
 * Decompiled with CFR 0.152.
 */
package com.asn1c.core;

import com.asn1c.core.ASN1Object;
import com.asn1c.core.DataValue;
import com.asn1c.core.Identification;
import com.asn1c.core.ObjectDescriptor;
import com.asn1c.core.String16;
import com.asn1c.core.String32;
import java.io.PrintWriter;

public class External
implements ASN1Object,
Comparable {
    protected Identification identification;
    protected ObjectDescriptor dataValueDescriptor;
    protected DataValue dataValue;

    public External() {
        this.identification = null;
        this.dataValueDescriptor = null;
        this.dataValue = null;
    }

    public External(Identification identification, ObjectDescriptor objectDescriptor, DataValue dataValue) {
        int n = identification.getSelector();
        if (n == 0 || n == 4 || n == 5) {
            throw new IllegalArgumentException();
        }
        this.identification = identification;
        this.dataValueDescriptor = objectDescriptor;
        this.dataValue = dataValue;
    }

    public External(External external) {
        this.identification = external.identification;
        this.dataValueDescriptor = external.dataValueDescriptor;
        this.dataValue = external.dataValue;
    }

    public void setValue(Identification identification, ObjectDescriptor objectDescriptor, DataValue dataValue) {
        int n = identification.getSelector();
        if (n == 0 || n == 4 || n == 5) {
            throw new IllegalArgumentException();
        }
        this.identification = identification;
        this.dataValueDescriptor = objectDescriptor;
        this.dataValue = dataValue;
    }

    public void setValue(External external) {
        this.identification = new Identification(external.identification);
        this.dataValueDescriptor = external.dataValueDescriptor != null ? new ObjectDescriptor(external.dataValueDescriptor) : null;
        this.dataValue = new DataValue(external.dataValue);
    }

    public int compareTo(Object object) {
        External external = (External)object;
        int n = this.identification.compareTo(external.identification);
        if (n != 0) {
            return n;
        }
        if (this.dataValueDescriptor != null && external.dataValueDescriptor == null) {
            return 1;
        }
        if (this.dataValueDescriptor == null && external.dataValueDescriptor != null) {
            return -1;
        }
        if (this.dataValueDescriptor != null && external.dataValueDescriptor != null && (n = this.dataValueDescriptor.compareTo(external.dataValueDescriptor)) != 0) {
            return n;
        }
        return this.dataValue.compareTo(external.dataValue);
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public void print(PrintWriter printWriter, String string, String string2, String string3, int n) {
        printWriter.println(string + string2 + "{");
        this.identification.print(printWriter, string + "    ", "identification ", ",", n);
        if (this.dataValueDescriptor != null) {
            this.dataValueDescriptor.print(printWriter, string + "    ", "data-value-descriptor ", ",", n);
        }
        this.dataValue.print(printWriter, string + "    ", "data-value ", ",", n);
        printWriter.println(string + "}" + string3);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ identification = ");
        stringBuffer.append(this.identification);
        if (this.dataValueDescriptor != null) {
            stringBuffer.append(", dataValueDescriptor = ");
            stringBuffer.append(this.dataValueDescriptor);
        }
        stringBuffer.append(", data-value = ");
        stringBuffer.append(this.dataValue);
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    public String16 toString16() {
        return new String16(this.toString());
    }

    public String32 toString32() {
        return new String32(this.toString());
    }

    public Identification getIdentification() {
        return this.identification;
    }

    public void setIdentification(Identification identification) {
        int n = identification.getSelector();
        if (n == 0 || n == 4 || n == 5) {
            throw new IllegalArgumentException();
        }
        this.identification = identification;
    }

    public ObjectDescriptor getDataValueDescriptor() {
        return this.dataValueDescriptor;
    }

    public void setDataValueDescriptor(ObjectDescriptor objectDescriptor) {
        this.dataValueDescriptor = objectDescriptor;
    }

    public DataValue getDataValue() {
        return this.dataValue;
    }

    public void setDataValue(DataValue dataValue) {
        this.dataValue = dataValue;
    }
}

