/*
 * Decompiled with CFR 0.152.
 */
package com.asn1c.core;

import com.asn1c.core.ASN1Object;
import com.asn1c.core.ObjectIdentifier;
import com.asn1c.core.String16;
import com.asn1c.core.String32;
import java.io.PrintWriter;

public class Identification
implements ASN1Object,
Comparable {
    protected int selector;
    public static final int SYNTAXES_SELECTED = 0;
    public static final int SYNTAX_SELECTED = 1;
    public static final int PRESENTATIONCONTEXTID_SELECTED = 2;
    public static final int CONTEXTNEGOTIATION_SELECTED = 3;
    public static final int TRANSFERSYNTAX_SELECTED = 4;
    public static final int FIXED_SELECTED = 5;
    protected ObjectIdentifier abstractOI;
    protected ObjectIdentifier syntax;
    protected int contextId;

    public Identification(int n, ObjectIdentifier objectIdentifier, ObjectIdentifier objectIdentifier2) {
        if (n != 0) {
            throw new IllegalArgumentException();
        }
        this.selector = n;
        this.abstractOI = objectIdentifier;
        this.syntax = objectIdentifier2;
    }

    public Identification(int n, ObjectIdentifier objectIdentifier) {
        if (n != 1 && n != 4) {
            throw new IllegalArgumentException();
        }
        this.selector = n;
        this.syntax = objectIdentifier;
    }

    public Identification(int n, int n2) {
        if (n != 2) {
            throw new IllegalArgumentException();
        }
        this.selector = n;
        this.contextId = n2;
    }

    public Identification(int n, int n2, ObjectIdentifier objectIdentifier) {
        if (n != 3) {
            throw new IllegalArgumentException();
        }
        this.selector = n;
        this.contextId = n2;
        this.syntax = objectIdentifier;
    }

    public Identification(int n) {
        if (n != 5) {
            throw new IllegalArgumentException();
        }
        this.selector = n;
    }

    public Identification(Identification identification) {
        this.selector = identification.selector;
        this.abstractOI = identification.abstractOI != null ? new ObjectIdentifier(identification.abstractOI) : null;
        this.syntax = identification.syntax != null ? new ObjectIdentifier(identification.syntax) : null;
        this.contextId = identification.contextId;
    }

    public Identification() {
        this.selector = -1;
    }

    void setValue(Identification identification) {
        this.selector = identification.selector;
        this.abstractOI = identification.abstractOI != null ? new ObjectIdentifier(identification.abstractOI) : null;
        this.syntax = identification.syntax != null ? new ObjectIdentifier(identification.syntax) : null;
        this.contextId = identification.contextId;
    }

    public void print(PrintWriter printWriter, String string, String string2, String string3, int n) {
        switch (this.selector) {
            case 0: {
                printWriter.println(string + string2 + "syntaxes: {");
                this.abstractOI.print(printWriter, string + "    ", "abstract ", ",", n);
                this.syntax.print(printWriter, string + "    ", "transfer ", "", n);
                printWriter.println(string + "}" + string3);
                break;
            }
            case 1: {
                this.syntax.print(printWriter, string, string2 + "syntax: ", string3, n);
                break;
            }
            case 2: {
                printWriter.println(string + string2 + "presentation-context-id: " + this.contextId + string3);
                break;
            }
            case 3: {
                printWriter.println(string + string2 + "context-negotiation: {");
                printWriter.println(string + "    presentation-context-id: " + this.contextId + string3);
                this.syntax.print(printWriter, string + "    ", "transfer-syntax ", "", n);
                printWriter.println(string + "}" + string3);
                break;
            }
            case 4: {
                this.syntax.print(printWriter, string, string2 + "transfer-syntax: ", string3, n);
                break;
            }
            case 5: {
                printWriter.println(string + string2 + "fixed: NULL" + string3);
                break;
            }
            default: {
                printWriter.println(string + string2 + "INVALID" + string3);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.selector) {
            case 0: {
                stringBuffer.append("syntaxes: { abstract = ");
                stringBuffer.append(this.abstractOI);
                stringBuffer.append(", transfer = ");
                stringBuffer.append(this.syntax);
                stringBuffer.append(" }");
                break;
            }
            case 1: {
                stringBuffer.append("syntax: ");
                stringBuffer.append(this.syntax);
                break;
            }
            case 2: {
                stringBuffer.append("presentation-context-id: ");
                stringBuffer.append(this.contextId);
                break;
            }
            case 3: {
                stringBuffer.append("context-negotiation: { presentation-context-id = ");
                stringBuffer.append(this.contextId);
                stringBuffer.append(", transfer-syntax = ");
                stringBuffer.append(this.syntax);
                stringBuffer.append(" }");
                break;
            }
            case 4: {
                stringBuffer.append("transfer-syntax: ");
                stringBuffer.append(this.syntax);
                break;
            }
            case 5: {
                stringBuffer.append("fixed");
                break;
            }
            default: {
                stringBuffer.append("INVALID");
            }
        }
        return stringBuffer.toString();
    }

    public String16 toString16() {
        return new String16(this.toString());
    }

    public String32 toString32() {
        return new String32(this.toString());
    }

    public int getSelector() {
        return this.selector;
    }

    protected void setSelector(int n) {
        if (this.selector == n) {
            return;
        }
        this.selector = n;
        this.abstractOI = null;
        this.syntax = null;
        this.contextId = 0;
    }

    public ObjectIdentifier getSyntaxesAbstract() {
        if (this.selector != 0) {
            throw new IllegalStateException();
        }
        return this.abstractOI;
    }

    public ObjectIdentifier getSyntaxesTransfer() {
        if (this.selector != 0) {
            throw new IllegalStateException();
        }
        return this.syntax;
    }

    public void setSyntaxesAbstract(ObjectIdentifier objectIdentifier) {
        this.setSelector(0);
        this.abstractOI = objectIdentifier;
    }

    public void setSyntaxesTransfer(ObjectIdentifier objectIdentifier) {
        this.setSelector(0);
        this.syntax = objectIdentifier;
    }

    public void setSyntaxes(ObjectIdentifier objectIdentifier, ObjectIdentifier objectIdentifier2) {
        this.setSelector(0);
        this.abstractOI = objectIdentifier;
        this.syntax = objectIdentifier2;
    }

    public ObjectIdentifier getSyntax() {
        if (this.selector != 1) {
            throw new IllegalStateException();
        }
        return this.syntax;
    }

    public void setSyntax(ObjectIdentifier objectIdentifier) {
        this.setSelector(1);
        this.syntax = objectIdentifier;
    }

    public int getPresentationContextId() {
        if (this.selector != 2) {
            throw new IllegalStateException();
        }
        return this.contextId;
    }

    public void setPresentationContextId(int n) {
        this.setSelector(2);
        this.contextId = n;
    }

    public int getContextNegotiationPresentationContextId() {
        if (this.selector != 3) {
            throw new IllegalStateException();
        }
        return this.contextId;
    }

    public ObjectIdentifier getContextNegotiationTransferSyntax() {
        if (this.selector != 3) {
            throw new IllegalStateException();
        }
        return this.syntax;
    }

    public void setContextNegotiationPresentationContextId(int n) {
        this.setSelector(3);
        this.contextId = n;
    }

    public void setContextNegotiationTransferSyntax(ObjectIdentifier objectIdentifier) {
        this.setSelector(3);
        this.syntax = objectIdentifier;
    }

    public void setContextNegotiation(int n, ObjectIdentifier objectIdentifier) {
        this.setSelector(3);
        this.contextId = n;
        this.syntax = objectIdentifier;
    }

    public ObjectIdentifier getTransferSyntax() {
        if (this.selector != 4) {
            throw new IllegalStateException();
        }
        return this.syntax;
    }

    public void setTransferSyntax(ObjectIdentifier objectIdentifier) {
        this.setSelector(4);
        this.syntax = objectIdentifier;
    }

    public void setFixed() {
        this.setSelector(5);
    }

    public int compareTo(Object object) {
        Identification identification = (Identification)object;
        if (this.selector != identification.selector) {
            return this.selector - identification.selector;
        }
        switch (this.selector) {
            case 0: {
                if (this.abstractOI.compareTo(identification.abstractOI) != 0) {
                    return this.abstractOI.compareTo(identification.abstractOI);
                }
                return this.syntax.compareTo(identification.syntax);
            }
            case 1: 
            case 4: {
                return this.syntax.compareTo(identification.syntax);
            }
            case 2: {
                return this.contextId - identification.contextId;
            }
            case 3: {
                if (this.contextId != identification.contextId) {
                    return this.contextId - identification.contextId;
                }
                return this.syntax.compareTo(identification.syntax);
            }
            case 5: {
                return 0;
            }
        }
        return 0;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }
}

