/*
 * Decompiled with CFR 0.152.
 */
package com.asn1c.core;

import com.asn1c.core.ASN1Object;
import com.asn1c.core.String16;
import com.asn1c.core.String32;
import java.io.PrintWriter;

public class Int32
extends Number
implements Comparable,
ASN1Object {
    public static final int MIN_VALUE = Integer.MIN_VALUE;
    public static final int MAX_VALUE = Integer.MAX_VALUE;
    protected int value;

    public Int32() {
        this.value = 0;
    }

    public Int32(int n) {
        this.value = n;
    }

    public Int32(Int32 int32) {
        this.value = int32.value;
    }

    public Int32(Integer n) {
        this.value = n;
    }

    public Int32(String string) throws NumberFormatException {
        this.value = Int32.parseInt(string);
    }

    public Int32(String16 string16) throws NumberFormatException {
        this.value = Int32.parseInt(string16);
    }

    public Int32(String32 string32) throws NumberFormatException {
        this.value = Int32.parseInt(string32);
    }

    public void setValue(int n) {
        this.value = n;
    }

    public void setValue(Int32 int32) {
        this.value = int32.value;
    }

    public void setValue(Integer n) {
        this.value = n;
    }

    public void setValue(String string) throws NumberFormatException {
        this.value = Int32.parseInt(string);
    }

    public void setValue(String16 string16) throws NumberFormatException {
        this.value = Int32.parseInt(string16);
    }

    public void setValue(String32 string32) throws NumberFormatException {
        this.value = Int32.parseInt(string32);
    }

    public static String toString(int n) {
        return Integer.toString(n);
    }

    public static String16 toString16(int n) {
        return new String16(Integer.toString(n));
    }

    public static String32 toString32(int n) {
        return new String32(Integer.toString(n));
    }

    public static int parseInt(String string) throws NumberFormatException {
        return Integer.parseInt(string);
    }

    public static int parseInt(String16 string16) throws NumberFormatException {
        return Integer.parseInt(string16.toString());
    }

    public static int parseInt(String32 string32) throws NumberFormatException {
        return Integer.parseInt(string32.toString());
    }

    public static int parseInt(String string, int n) throws NumberFormatException {
        return Integer.parseInt(string, n);
    }

    public static int parseInt(String16 string16, int n) throws NumberFormatException {
        return Integer.parseInt(string16.toString(), n);
    }

    public static int parseInt(String32 string32, int n) throws NumberFormatException {
        return Integer.parseInt(string32.toString(), n);
    }

    public static Int32 valueOf(String string, int n) throws NumberFormatException {
        return new Int32(Integer.parseInt(string, n));
    }

    public static Int32 valueOf(String16 string16, int n) throws NumberFormatException {
        return new Int32(Integer.parseInt(string16.toString(), n));
    }

    public static Int32 valueOf(String32 string32, int n) throws NumberFormatException {
        return new Int32(Integer.parseInt(string32.toString(), n));
    }

    public static Int32 valueOf(String string) throws NumberFormatException {
        return new Int32(Integer.parseInt(string));
    }

    public static Int32 valueOf(String16 string16) throws NumberFormatException {
        return new Int32(Integer.parseInt(string16.toString()));
    }

    public static Int32 valueOf(String32 string32) throws NumberFormatException {
        return new Int32(Integer.parseInt(string32.toString()));
    }

    public static Int32 decode(String string) throws NumberFormatException {
        if (string.startsWith("0x")) {
            return Int32.valueOf(string.substring(2), 16);
        }
        if (string.startsWith("#")) {
            return Int32.valueOf(string.substring(1), 16);
        }
        if (string.startsWith("0") && string.length() > 1) {
            return Int32.valueOf(string.substring(1), 8);
        }
        return Int32.valueOf(string, 10);
    }

    public static Int32 decode(String16 string16) throws NumberFormatException {
        if (string16.startsWith("0x")) {
            return Int32.valueOf(string16.substring(2), 16);
        }
        if (string16.startsWith("#")) {
            return Int32.valueOf(string16.substring(1), 16);
        }
        if (string16.startsWith("0") && string16.length() > 1) {
            return Int32.valueOf(string16.substring(1), 8);
        }
        return Int32.valueOf(string16, 10);
    }

    public static Int32 decode(String32 string32) throws NumberFormatException {
        if (string32.startsWith("0x")) {
            return Int32.valueOf(string32.substring(2), 16);
        }
        if (string32.startsWith("#")) {
            return Int32.valueOf(string32.substring(1), 16);
        }
        if (string32.startsWith("0") && string32.length() > 1) {
            return Int32.valueOf(string32.substring(1), 8);
        }
        return Int32.valueOf(string32, 10);
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public int hashCode() {
        return this.value ^ this.value >>> 32;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Int32 && this.value == ((Int32)object).value;
    }

    public int compareTo(Int32 int32) {
        return this.value < int32.value ? -1 : (this.value > int32.value ? 1 : 0);
    }

    public int compareTo(Integer n) {
        return this.value < n ? -1 : (this.value > n ? 1 : 0);
    }

    public int compareTo(Object object) {
        return this.compareTo((Int32)object);
    }

    public void print(PrintWriter printWriter, String string, String string2, String string3, int n) {
        printWriter.println(string + string2 + this.toString() + string3);
    }

    public String16 toString16() {
        return new String16(this.toString());
    }

    public String32 toString32() {
        return new String32(this.toString());
    }
}

