/*
 * Decompiled with CFR 0.152.
 */
package com.asn1c.core;

import com.asn1c.core.ASN1Object;
import com.asn1c.core.String16;
import com.asn1c.core.String32;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;

public class ObjectIdentifier
implements ASN1Object,
Serializable,
Cloneable {
    protected long[] value;
    protected int size;

    public ObjectIdentifier() {
        this.size = 0;
        this.value = new long[4];
    }

    public ObjectIdentifier(long[] lArray) {
        this.size = lArray.length;
        this.value = new long[this.size];
        System.arraycopy(lArray, 0, this.value, 0, this.size);
    }

    public ObjectIdentifier(long[] lArray, int n, int n2) {
        this.size = n2;
        this.value = new long[this.size];
        System.arraycopy(lArray, n, this.value, 0, this.size);
    }

    public ObjectIdentifier(ObjectIdentifier objectIdentifier) {
        this(objectIdentifier.value, 0, objectIdentifier.size);
    }

    public long get(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        return this.value[n];
    }

    public void get(int n, long[] lArray, int n2, int n3) {
        System.arraycopy(this.value, n, lArray, n2, n3);
    }

    public void set(int n, long l) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        if (n == this.size) {
            this.setLength(n + 1);
        }
        this.value[n] = l;
    }

    public void set(long[] lArray, int n, int n2, int n3) {
        if (this.size < n2 + n3) {
            throw new IndexOutOfBoundsException(Integer.toString(n2 + n3 - 1));
        }
        System.arraycopy(lArray, n, this.value, n2, n3);
    }

    public int length() {
        return this.size;
    }

    public void setLength(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        if (n != this.size) {
            if (n > this.value.length) {
                long[] lArray = new long[n + 4];
                System.arraycopy(this.value, 0, lArray, 0, this.size);
                this.value = lArray;
            }
            int n2 = this.size;
            while (n2 < n) {
                this.value[n2] = 0L;
                ++n2;
            }
            this.size = n;
        }
    }

    public void setValue(long[] lArray) {
        this.size = lArray.length;
        if (this.size > this.value.length) {
            this.value = new long[this.size];
        }
        System.arraycopy(lArray, 0, this.value, 0, this.size);
    }

    public void setValue(long[] lArray, int n, int n2) {
        this.size = n2;
        if (this.size > this.value.length) {
            this.value = new long[this.size];
        }
        System.arraycopy(lArray, n, this.value, 0, this.size);
    }

    public void setValue(ObjectIdentifier objectIdentifier) {
        this.setValue(objectIdentifier.value, 0, objectIdentifier.size);
    }

    public int capacity() {
        return this.value.length;
    }

    public void ensureCapacity(int n) {
        if (n > this.value.length) {
            long[] lArray = new long[n];
            System.arraycopy(this.value, 0, lArray, 0, this.size);
            this.value = lArray;
        }
    }

    public void shrinkCapacity() {
        if (this.value.length > this.size) {
            long[] lArray = new long[this.size];
            System.arraycopy(this.value, 0, lArray, 0, this.size);
            this.value = lArray;
        }
    }

    public int compareTo(Object object) {
        ObjectIdentifier objectIdentifier = (ObjectIdentifier)object;
        int n = Math.min(this.size, objectIdentifier.size);
        int n2 = 0;
        while (n2 < n) {
            if (this.value[n2] != objectIdentifier.value[n2]) {
                return this.value[n2] < objectIdentifier.value[n2] ? -1 : 1;
            }
            ++n2;
        }
        if (this.size != objectIdentifier.size) {
            return this.size < objectIdentifier.size ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.shrinkCapacity();
        objectOutputStream.defaultWriteObject();
    }

    public Object clone() {
        ObjectIdentifier objectIdentifier = null;
        try {
            objectIdentifier = (ObjectIdentifier)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        objectIdentifier.value = new long[this.size + 4];
        objectIdentifier.size = this.size;
        System.arraycopy(this.value, 0, objectIdentifier.value, 0, this.size);
        return objectIdentifier;
    }

    public void print(PrintWriter printWriter, String string, String string2, String string3, int n) {
        printWriter.println(string + string2 + this.toString() + string3);
    }

    public long[] toLongArray() {
        long[] lArray = new long[this.size];
        System.arraycopy(this.value, 0, lArray, 0, this.size);
        return lArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        int n = 0;
        while (n < this.size) {
            stringBuffer.append(' ');
            stringBuffer.append(this.value[n]);
            ++n;
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    public String16 toString16() {
        return new String16(this.toString());
    }

    public String32 toString32() {
        return new String32(this.toString());
    }
}

