/*
 * Decompiled with CFR 0.152.
 */
package com.asn1c.core;

import com.asn1c.core.String16;
import com.asn1c.core.String32;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class String32Buffer
implements Serializable,
Cloneable {
    private int[] value;
    private int count;

    public String32Buffer() {
        this(16);
    }

    public String32Buffer(int n) {
        this.value = new int[n];
        this.count = 0;
    }

    public String32Buffer(String32 string32) {
        this(string32.length() + 16);
        this.append(string32);
    }

    public String32Buffer(String16 string16) {
        this(string16.length() + 16);
        this.append(string16);
    }

    public String32Buffer(String string) {
        this(string.length() + 16);
        this.append(string);
    }

    public String32Buffer(StringBuffer stringBuffer) {
        this(stringBuffer.length() + 16);
        this.append(stringBuffer);
    }

    public String32Buffer(String32Buffer string32Buffer) {
        this(string32Buffer.length() + 16);
        this.append(string32Buffer);
    }

    public String32Buffer append(Object object) {
        return this.append(String32.valueOf(object));
    }

    public String32Buffer append(String32 string32) {
        if (string32 == null) {
            string32 = String32.valueOf(string32);
        }
        int n = string32.length();
        this.ensureCapacity(this.count + n);
        string32.getChars(0, n, this.value, this.count);
        this.count += n;
        return this;
    }

    public String32Buffer append(String16 string16) {
        return this.append(new String32(string16));
    }

    public String32Buffer append(String string) {
        return this.append(new String32(string));
    }

    public String32Buffer append(StringBuffer stringBuffer) {
        return this.append(new String32(stringBuffer));
    }

    public String32Buffer append(String32Buffer string32Buffer) {
        return this.append(new String32(string32Buffer));
    }

    public String32Buffer append(int[] nArray) {
        int n = nArray.length;
        this.ensureCapacity(this.count + n);
        System.arraycopy(nArray, 0, this.value, this.count, n);
        this.count += n;
        return this;
    }

    public String32Buffer append(int[] nArray, int n, int n2) {
        this.ensureCapacity(this.count + n2);
        System.arraycopy(nArray, n, this.value, this.count, n2);
        this.count += n2;
        return this;
    }

    public String32Buffer append(boolean bl) {
        return this.append(String32.valueOf(bl));
    }

    public String32Buffer append(char c) {
        return this.append(String32.valueOf(c));
    }

    public String32Buffer append(int n) {
        return this.append(String32.valueOf(n));
    }

    public String32Buffer append(long l) {
        return this.append(String32.valueOf(l));
    }

    public String32Buffer append(float f) {
        return this.append(String32.valueOf(f));
    }

    public String32Buffer append(double d) {
        return this.append(String32.valueOf(d));
    }

    public String32Buffer appendChar(int n) {
        this.ensureCapacity(this.count + 1);
        this.value[this.count++] = n;
        return this;
    }

    public int capacity() {
        return this.value.length;
    }

    public int charAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.value[n];
    }

    public void ensureCapacity(int n) {
        int n2 = this.value.length;
        if (n > n2) {
            int n3 = (n2 + 1) * 2;
            if (n > n3) {
                n3 = n + 16;
            }
            int[] nArray = new int[n3];
            System.arraycopy(this.value, 0, nArray, 0, this.count);
            this.value = nArray;
        }
    }

    public void shrinkCapacity() {
        int n = this.value.length;
        if (n > this.count) {
            int[] nArray = new int[this.count];
            System.arraycopy(this.value, 0, nArray, 0, this.count);
            this.value = nArray;
        }
    }

    public void getChars(int n, int n2, int[] nArray, int n3) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n < n2) {
            System.arraycopy(this.value, n, nArray, n3, n2 - n);
        }
    }

    public String32Buffer insert(int n, Object object) {
        return this.insert(n, String32.valueOf(object));
    }

    public String32Buffer insert(int n, String32 string32) {
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int n2 = string32.length();
        this.ensureCapacity(this.count + n2);
        System.arraycopy(this.value, n, this.value, n + n2, this.count - n);
        string32.getChars(0, n2, this.value, n);
        this.count += n2;
        return this;
    }

    public String32Buffer insert(int n, String16 string16) {
        return this.insert(n, new String32(string16));
    }

    public String32Buffer insert(int n, String string) {
        return this.insert(n, new String32(string));
    }

    public String32Buffer insert(int n, int[] nArray) {
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int n2 = nArray.length;
        this.ensureCapacity(this.count + n2);
        System.arraycopy(this.value, n, this.value, n + n2, this.count - n);
        System.arraycopy(nArray, 0, this.value, n, n2);
        this.count += n2;
        return this;
    }

    public String32Buffer insert(int n, boolean bl) {
        return this.insert(n, String32.valueOf(bl));
    }

    public String32Buffer insert(int n, char c) {
        return this.insert(n, String32.valueOf(c));
    }

    public String32Buffer insert(int n, int n2) {
        return this.insert(n, String32.valueOf(n2));
    }

    public String32Buffer insert(int n, long l) {
        return this.insert(n, String32.valueOf(l));
    }

    public String32Buffer insert(int n, float f) {
        return this.insert(n, String32.valueOf(f));
    }

    public String32Buffer insert(int n, double d) {
        return this.insert(n, String32.valueOf(d));
    }

    public int length() {
        return this.count;
    }

    public String32Buffer reverse() {
        int n = this.count - 1;
        int n2 = n - 1 >> 1;
        while (n2 >= 0) {
            int n3 = this.value[n2];
            this.value[n2] = this.value[n - n2];
            this.value[n - n2] = n3;
            --n2;
        }
        return this;
    }

    public void setCharAt(int n, int n2) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.value[n] = n2;
    }

    public void setLength(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.ensureCapacity(n);
        if (this.count < n) {
            while (this.count < n) {
                this.value[this.count] = 0;
                ++this.count;
            }
        }
        this.count = n;
    }

    public Object clone() {
        String32Buffer string32Buffer;
        try {
            string32Buffer = (String32Buffer)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        string32Buffer.value = (int[])this.value.clone();
        return string32Buffer;
    }

    public String toString() {
        char[] cArray = new char[this.count];
        int n = 0;
        while (n < this.count) {
            cArray[n] = (char)this.value[n];
            ++n;
        }
        return new String(cArray);
    }

    public String16 toString16() {
        return new String16(this.toString());
    }

    public String32 toString32() {
        return new String32(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.shrinkCapacity();
        objectOutputStream.defaultWriteObject();
    }
}

