/*
 * Decompiled with CFR 0.152.
 */
package com.asn1c.core;

import com.asn1c.core.BitString;
import com.asn1c.core.UnitString;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class TrimmedBitString
extends BitString {
    protected void checkBitIndex(int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        this.ensureBitCapacity(n2);
    }

    protected void checkBitRange(int n, int n2, int n3) {
        if (n2 < 0) {
            throw new NegativeArraySizeException(Integer.toString(n2));
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        this.ensureBitCapacity(n + n2);
    }

    public TrimmedBitString() {
    }

    public TrimmedBitString(int n) {
        this.ensureBitCapacity(n);
    }

    public TrimmedBitString(UnitString unitString) {
        super(unitString);
    }

    public TrimmedBitString(byte[] byArray) {
        super(byArray);
    }

    public TrimmedBitString(byte[] byArray, int n, int n2) {
        super(byArray, n, n2);
    }

    public void setBit(int n) {
        UnitString.checkSize(n);
        this.ensureBitLength(n + 1);
        super.setBit(n);
    }

    public void clearBit(int n) {
        UnitString.checkSize(n);
        if (this.bitsize > n) {
            super.clearBit(n);
        }
    }

    public void setBit(int n, boolean bl) {
        UnitString.checkSize(n);
        if (bl) {
            this.ensureBitLength(n + 1);
            super.setBit(n);
        } else if (this.bitsize > n) {
            super.clearBit(n);
        }
    }

    public boolean getBit(int n) {
        UnitString.checkSize(n);
        boolean bl = this.bitsize > n ? super.getBit(n) : false;
        return bl;
    }

    public int bitLength() {
        this.trimLength();
        return this.bitsize;
    }

    public int octetLength() {
        this.trimLength();
        return (this.bitsize + 7) / 8;
    }

    public int length() {
        this.trimLength();
        return this.bitsize;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.trimLength();
        this.shrinkCapacity();
        objectOutputStream.defaultWriteObject();
    }
}

