/*
 * Decompiled with CFR 0.152.
 */
package com.asn1c.core;

import com.asn1c.core.ASN1Object;
import com.asn1c.core.BadDataException;
import com.asn1c.core.BitString;
import com.asn1c.core.OctetString;
import com.asn1c.core.String16;
import com.asn1c.core.String32;
import com.asn1c.core.String32Buffer;
import com.asn1c.core.ValueTooLargeException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.math.BigInteger;

public class UnitString
implements ASN1Object,
Cloneable,
Serializable,
Comparable {
    protected static final int SHIFT = 3;
    protected static final int BITS = 8;
    protected static final int MASK = 7;
    protected static final byte[] leftmask = new byte[]{0, -128, -64, -32, -16, -8, -4, -2, -1};
    protected static final byte[] rightmask = new byte[]{0, 1, 3, 7, 15, 31, 63, 127, -1};
    protected static final byte[] bitmask = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
    protected int bitsize;
    protected byte[] bits;
    protected int unitsize;
    static final long serialVersionUID = -6981081567680739289L;

    protected UnitString(int n) {
        UnitString.checkUnitSize(n);
        this.unitsize = n;
        this.bitsize = 0;
        this.bits = new byte[16];
    }

    protected UnitString(int n, UnitString unitString) {
        UnitString.checkUnitSize(n);
        this.unitsize = n;
        this.checkBitLength(unitString.bitsize);
        this.bitsize = unitString.bitsize;
        this.bits = new byte[UnitString.sublength(this.bitsize)];
        System.arraycopy(unitString.bits, 0, this.bits, 0, this.bits.length);
    }

    protected UnitString(int n, int n2) {
        UnitString.checkUnitSize(n);
        this.unitsize = n;
        UnitString.checkSize(n2);
        if ((long)n2 * (long)n > 0x7FFFFFF8L) {
            n2 = 0x7FFFFFF8 / n;
        }
        this.bitsize = n2 * n;
        this.bits = new byte[UnitString.sublength(n2 * n)];
    }

    protected UnitString(int n, byte[] byArray) {
        UnitString.checkUnitSize(n);
        this.unitsize = n;
        this.bitsize = byArray.length * 8;
        this.bits = (byte[])byArray.clone();
    }

    protected UnitString(int n, byte[] byArray, int n2, int n3) {
        UnitString.checkUnitSize(n);
        this.unitsize = n;
        UnitString.checkSize(n3);
        if ((long)n3 * (long)n > 0x7FFFFFF8L) {
            n3 = 0x7FFFFFF8 / n;
        }
        this.bitsize = n3 * n;
        this.bits = new byte[UnitString.sublength(n3 * n)];
        UnitString.bitcpy(this.bits, 0, byArray, n2 * n, n3 * n);
    }

    public void setValue(UnitString unitString) {
        this.checkBitLength(unitString.bitsize);
        this.bitsize = unitString.bitsize;
        this.bits = new byte[UnitString.sublength(this.bitsize)];
        System.arraycopy(unitString.bits, 0, this.bits, 0, this.bits.length);
    }

    public void setValue(byte[] byArray) {
        this.bitsize = byArray.length * 8;
        this.bits = (byte[])byArray.clone();
    }

    public void setValue(byte[] byArray, int n, int n2) {
        UnitString.checkSize(n2);
        if ((long)n2 * (long)this.unitsize > 0x7FFFFFF8L) {
            n2 = 0x7FFFFFF8 / this.unitsize;
        }
        this.bitsize = n2 * this.unitsize;
        this.bits = new byte[UnitString.sublength(n2 * this.unitsize)];
        UnitString.bitcpy(this.bits, 0, byArray, n * this.unitsize, n2 * this.unitsize);
    }

    public void ensureBitCapacity(int n) {
        UnitString.checkSize(n);
        int n2 = UnitString.sublength(n);
        if (n2 > this.bits.length) {
            int n3 = Math.max(2 * this.bits.length, n2);
            byte[] byArray = new byte[n3];
            System.arraycopy(this.bits, 0, byArray, 0, UnitString.sublength(this.bitsize));
            this.bits = byArray;
        }
    }

    public void ensureOctetCapacity(int n) {
        this.ensureBitCapacity(n * 8);
    }

    public void ensureCapacity(int n) {
        this.ensureBitCapacity(n * this.unitsize);
    }

    public void ensureBitLength(int n) {
        this.checkBitLength(n);
        int n2 = UnitString.sublength(n);
        this.ensureBitCapacity(n);
        if (n > this.bitsize) {
            this.bitsize = n;
        }
    }

    public void ensureOctetLength(int n) {
        this.ensureBitLength(n * 8);
    }

    public void ensureLength(int n) {
        this.ensureBitLength(n * this.unitsize);
    }

    public int unit() {
        return this.unitsize;
    }

    public int bitLength() {
        return this.bitsize;
    }

    public int octetLength() {
        return (this.bitsize + 7) / 8;
    }

    public int length() {
        return this.bitsize / this.unitsize;
    }

    public int trimmedBitLength() {
        int n = UnitString.subscript(this.bitsize - 1);
        while (n >= 0 && this.bits[n] == 0) {
            --n;
        }
        if (n >= 0) {
            byte by = this.bits[n];
            int n2 = 7;
            while (n2 >= 0) {
                if ((by & bitmask[n2]) != 0) break;
                --n2;
            }
            return n * 8 + n2 + 1;
        }
        return 0;
    }

    public int bitCapacity() {
        return this.bits.length << 3;
    }

    public int octetCapacity() {
        return this.bits.length;
    }

    public int capacity() {
        return (this.bits.length << 3) / this.unitsize;
    }

    public void setBitLength(int n) {
        this.checkBitLength(n);
        if (n < this.bitsize) {
            UnitString.bitclr(this.bits, n, this.bitsize - n);
            this.bitsize = n;
        } else {
            this.ensureBitLength(n);
        }
    }

    public void setOctetLength(int n) {
        this.setBitLength(n * 8);
    }

    public void setLength(int n) {
        this.setBitLength(n * this.unitsize);
    }

    public void shrinkCapacity() {
        int n = UnitString.sublength(this.bitsize);
        if (this.bits.length > n) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.bits, 0, byArray, 0, n);
            this.bits = byArray;
        }
    }

    public void trimLength() {
        int n = this.trimmedBitLength();
        this.bitsize = (n + this.unitsize - 1) / this.unitsize * this.unitsize;
    }

    public int get(int n) {
        int n2;
        this.checkBitIndex(n * this.unitsize);
        switch (this.unitsize) {
            case 1: {
                n2 = (this.bits[UnitString.subscript(n)] & bitmask[n & 7]) != 0 ? 1 : 0;
                break;
            }
            case 8: {
                n2 = this.bits[n] & 0xFF;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        return n2;
    }

    public void set(int n, int n2) {
        this.checkBitIndex(n * this.unitsize);
        switch (this.unitsize) {
            case 1: {
                if (n2 != 0) {
                    int n3 = UnitString.subscript(n);
                    this.bits[n3] = (byte)(this.bits[n3] | bitmask[n & 7]);
                    break;
                }
                int n4 = UnitString.subscript(n);
                this.bits[n4] = (byte)(this.bits[n4] & ~bitmask[n & 7]);
                break;
            }
            case 8: {
                this.bits[n] = (byte)n2;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
    }

    public UnitString get(int n, int n2) {
        UnitString unitString;
        this.checkBitRange(n * this.unitsize, n2 * this.unitsize);
        switch (this.unitsize) {
            case 1: {
                unitString = new BitString(n2);
                break;
            }
            case 8: {
                unitString = new OctetString(n2);
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        UnitString.bitcpy(unitString.bits, 0, this.bits, n * this.unitsize, n2 * this.unitsize);
        return unitString;
    }

    public void set(UnitString unitString, int n, int n2, int n3) {
        this.checkBitRange(n2 * this.unitsize, n3 * this.unitsize);
        unitString.checkBitRange(n * unitString.unitsize, n3 * unitString.unitsize);
        UnitString.bitmove(this.bits, n2 * this.unitsize, unitString.bits, n * unitString.unitsize, n3 * this.unitsize);
    }

    public void append(int n) {
        switch (this.unitsize) {
            case 1: {
                this.appendBit(n != 0);
                break;
            }
            case 8: {
                this.appendByte((byte)n);
                break;
            }
            default: {
                throw new InternalError();
            }
        }
    }

    public boolean getBit(int n) {
        this.checkBitIndex(n);
        boolean bl = (this.bits[UnitString.subscript(n)] & bitmask[n & 7]) != 0;
        return bl;
    }

    public void setBit(int n) {
        this.checkBitIndex(n);
        int n2 = UnitString.subscript(n);
        this.bits[n2] = (byte)(this.bits[n2] | bitmask[n & 7]);
    }

    public void clearBit(int n) {
        this.checkBitIndex(n);
        int n2 = UnitString.subscript(n);
        this.bits[n2] = (byte)(this.bits[n2] & ~bitmask[n & 7]);
    }

    public void setBit(int n, boolean bl) {
        this.checkBitIndex(n);
        if (bl) {
            int n2 = UnitString.subscript(n);
            this.bits[n2] = (byte)(this.bits[n2] | bitmask[n & 7]);
        } else {
            int n3 = UnitString.subscript(n);
            this.bits[n3] = (byte)(this.bits[n3] & ~bitmask[n & 7]);
        }
    }

    public void appendBit(boolean bl) {
        this.ensureBitCapacity(this.bitsize + 1);
        if (bl) {
            int n = UnitString.subscript(this.bitsize);
            this.bits[n] = (byte)(this.bits[n] | bitmask[this.bitsize & 7]);
        }
        ++this.bitsize;
    }

    public BitString getBits(int n, int n2) {
        BitString bitString = new BitString(n2);
        this.checkBitRange(n, n2);
        UnitString.bitcpy(bitString.bits, 0, this.bits, n, n2);
        return bitString;
    }

    public void setBits(UnitString unitString, int n, int n2, int n3) {
        this.checkBitRange(n2, n3);
        unitString.checkBitRange(n, n3);
        UnitString.bitmove(this.bits, n2, unitString.bits, n, n3);
    }

    public byte getOctet(int n) {
        return this.getOctetAtBitPosition(n * 8);
    }

    public void setOctet(int n, byte by) {
        this.setOctetAtBitPosition(n * 8, by);
    }

    public void appendOctet(byte by) {
        this.appendByte(by);
    }

    public OctetString getOctets(int n, int n2) {
        return this.getOctetsAtBitPosition(n * 8, n2);
    }

    public void setOctets(UnitString unitString, int n, int n2, int n3) {
        this.setOctetsAtBitPosition(unitString, n * 8, n2 * 8, n3);
    }

    public byte getOctetAtBitPosition(int n) {
        this.checkBitRange(n, 8);
        byte by = this.extractByte(n);
        return by;
    }

    public void setOctetAtBitPosition(int n, byte by) {
        this.checkBitRange(n, 8);
        this.putByte(n, by);
    }

    public OctetString getOctetsAtBitPosition(int n, int n2) {
        UnitString.checkSize(n2);
        OctetString octetString = new OctetString(n2);
        UnitString.bitcpy(octetString.bits, 0, this.bits, n, n2 * 8);
        return octetString;
    }

    public void setOctetsAtBitPosition(UnitString unitString, int n, int n2, int n3) {
        this.checkBitRange(n2, n3 * 8);
        unitString.checkBitRange(n * 8, n3 * 8);
        UnitString.bitcpy(this.bits, n2, unitString.bits, n * 8, n3 * 8);
    }

    public void append(UnitString unitString) {
        this.appendBits(unitString, 0, unitString.bitsize);
    }

    public void append(UnitString unitString, int n, int n2) {
        this.appendBits(unitString, n * unitString.unitsize, n2 * this.unitsize);
    }

    public void appendBits(UnitString unitString, int n, int n2) {
        UnitString.checkSize(n2);
        unitString.checkBitRange(n, n2);
        this.checkBitLength(this.bitsize + n2);
        this.ensureBitCapacity(this.bitsize + n2);
        UnitString.bitcpy(this.bits, this.bitsize, unitString.bits, n, Math.min(n2, unitString.bitsize));
        this.bitsize += n2;
    }

    public void appendOctets(UnitString unitString, int n, int n2) {
        this.appendBits(unitString, n * 8, n2 * 8);
    }

    public void appendByteArray(byte[] byArray) {
        this.appendOctetsFromByteArray(byArray, 0, byArray.length);
    }

    public void appendByteArray(byte[] byArray, int n, int n2) {
        UnitString.checkSize(n2);
        this.checkBitRange(n * this.unitsize, n2 * this.unitsize, byArray.length * 8);
        this.checkBitLength(this.bitsize + n2 * this.unitsize);
        this.ensureBitCapacity(this.bitsize + n2 * this.unitsize);
        UnitString.bitcpy(this.bits, this.bitsize, byArray, n * this.unitsize, n2 * this.unitsize);
        this.bitsize += n2 * this.unitsize;
    }

    public void appendBitsFromByteArray(byte[] byArray, int n, int n2) {
        UnitString.checkSize(n2);
        this.checkBitRange(n, n2, byArray.length * 8);
        this.checkBitLength(this.bitsize + n2);
        this.ensureBitCapacity(this.bitsize + n2);
        UnitString.bitcpy(this.bits, this.bitsize, byArray, n, n2);
        this.bitsize += n2;
    }

    public void appendOctetsFromByteArray(byte[] byArray, int n, int n2) {
        UnitString.checkSize(n2);
        Object object = this;
        Object object2 = byArray;
        if (System.identityHashCode(object) > System.identityHashCode(object2)) {
            object = byArray;
            object2 = this;
        }
        this.checkBitRange(n * 8, n2 * 8, byArray.length * 8);
        this.ensureBitCapacity(this.bitsize + n2 * 8);
        UnitString.bitcpy(this.bits, this.bitsize, byArray, n * 8, n2 * 8);
        this.bitsize += n2 * 8;
    }

    public void appendZeros(int n) {
        UnitString.checkSize(n);
        this.ensureBitLength(this.bitsize + n * this.unitsize);
    }

    public void appendZeroBits(int n) {
        UnitString.checkSize(n);
        this.checkBitLength(this.bitsize + n);
        this.ensureBitLength(this.bitsize + n);
    }

    public void appendZeroOctets(int n) {
        UnitString.checkSize(n);
        this.ensureBitLength(this.bitsize + n * 8);
    }

    public int hashCode() {
        long l = 1234L;
        int n = UnitString.sublength(this.bitsize);
        while (--n >= 0) {
            l ^= (long)(this.bits[n] * (n + 1));
        }
        return (int)(l >>> 32 ^ l);
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int compareTo(Object object) {
        if (this == object) {
            return 0;
        }
        UnitString unitString = (UnitString)object;
        int n = Math.min(this.bitLength(), unitString.bitLength());
        int n2 = UnitString.sublength(n);
        int n3 = 0;
        while (n3 < n2) {
            if (this.bits[n3] != unitString.bits[n3]) {
                if (this.bits[n3] < 0 && unitString.bits[n3] >= 0) {
                    return 1;
                }
                if (this.bits[n3] >= 0 && unitString.bits[n3] < 0) {
                    return -1;
                }
                if (this.bits[n3] > unitString.bits[n3]) {
                    return 1;
                }
                return -1;
            }
            ++n3;
        }
        return 0;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.shrinkCapacity();
        objectOutputStream.defaultWriteObject();
    }

    public Object clone() {
        UnitString unitString;
        try {
            unitString = (UnitString)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        unitString.bits = new byte[this.bits.length];
        System.arraycopy(this.bits, 0, unitString.bits, 0, this.bits.length);
        return unitString;
    }

    public String toString() {
        StringBuffer stringBuffer;
        switch (this.unitsize) {
            case 1: {
                int n = this.bitLength();
                stringBuffer = new StringBuffer(3 + n);
                stringBuffer.append("'");
                int n2 = 0;
                while (n2 < n) {
                    stringBuffer.append(this.getBit(n2) ? (char)'1' : '0');
                    ++n2;
                }
                stringBuffer.append("'B");
                break;
            }
            case 8: {
                stringBuffer = new StringBuffer(3 + 2 * this.octetLength());
                stringBuffer.append("'");
                int n = 0;
                while (n < this.octetLength()) {
                    if ((this.bits[n] & 0xF0) >= 160) {
                        stringBuffer.append((char)(((this.bits[n] & 0xF0) >> 4) + 65 - 10));
                    } else {
                        stringBuffer.append((char)(((this.bits[n] & 0xF0) >> 4) + 48));
                    }
                    if ((this.bits[n] & 0xF) >= 10) {
                        stringBuffer.append((char)((this.bits[n] & 0xF) + 65 - 10));
                    } else {
                        stringBuffer.append((char)((this.bits[n] & 0xF) + 48));
                    }
                    ++n;
                }
                stringBuffer.append("'H");
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        return stringBuffer.toString();
    }

    public void print(PrintWriter printWriter, String string, String string2, String string3, int n) {
        switch (this.unitsize) {
            case 1: {
                printWriter.print(string + string2 + "'");
                int n2 = this.bitLength();
                int n3 = 0;
                while (n3 < n2) {
                    printWriter.print(this.getBit(n3) ? (char)'1' : '0');
                    ++n3;
                }
                printWriter.println("'B" + string3);
                break;
            }
            case 8: {
                printWriter.print(string + string2 + "'");
                int n4 = 0;
                while (n4 < this.octetLength()) {
                    if ((this.bits[n4] & 0xF0) >= 160) {
                        printWriter.print((char)(((this.bits[n4] & 0xF0) >> 4) + 65 - 10));
                    } else {
                        printWriter.print((char)(((this.bits[n4] & 0xF0) >> 4) + 48));
                    }
                    if ((this.bits[n4] & 0xF) >= 10) {
                        printWriter.print((char)((this.bits[n4] & 0xF) + 65 - 10));
                    } else {
                        printWriter.print((char)((this.bits[n4] & 0xF) + 48));
                    }
                    ++n4;
                }
                printWriter.println("'H" + string3);
                break;
            }
            default: {
                throw new InternalError();
            }
        }
    }

    public String16 toString16() {
        return new String16(this.toString());
    }

    public String32 toString32() {
        return new String32(this.toString());
    }

    public static UnitString toUnitString(String16 string16) {
        if (string16 == null) {
            throw new NumberFormatException();
        }
        if (string16.startsWith("'") && string16.endsWith("'B")) {
            return UnitString.toBitString(string16);
        }
        if (string16.startsWith("'") && string16.endsWith("'H")) {
            return UnitString.toOctetString(string16);
        }
        throw new NumberFormatException(string16.toString());
    }

    public static BitString toBitString(String16 string16) {
        if (string16 == null) {
            throw new NumberFormatException();
        }
        if (!string16.startsWith("'") || !string16.endsWith("'B")) {
            throw new NumberFormatException(string16.toString());
        }
        BitString bitString = new BitString(string16.length() - 3);
        int n = string16.length() - 3;
        while (n-- > 0) {
            char c = string16.charAt(1 + n);
            if (c == '1') {
                bitString.setBit(n);
                continue;
            }
            if (c == '0') continue;
            throw new NumberFormatException(string16.toString());
        }
        return bitString;
    }

    public static OctetString toOctetString(String16 string16) {
        if (string16 == null) {
            throw new NumberFormatException();
        }
        if (!string16.startsWith("'") || !string16.endsWith("'H")) {
            throw new NumberFormatException(string16.toString());
        }
        OctetString octetString = new OctetString((string16.length() - 3) / 2);
        int n = string16.length() - 3 + 1 & 0xFFFFFFFE;
        while (n > 0) {
            byte by;
            int n2;
            char c = string16.charAt(1 + (n -= 2));
            int n3 = n2 = string16.length() - 2 >= 1 + n + 1 ? (int)string16.charAt(1 + n + 1) : 48;
            if (c >= '0' && c <= '9') {
                by = (byte)(c - 48 << 4);
            } else if (c >= 'a' && c <= 'f') {
                by = (byte)(c - 97 + 10 << 4);
            } else if (c >= 'A' && c <= 'F') {
                by = (byte)(c - 65 + 10 << 4);
            } else {
                throw new NumberFormatException(string16.toString());
            }
            if (n2 >= 48 && n2 <= 57) {
                by = (byte)(by | (byte)(n2 - 48));
            } else if (n2 >= 97 && n2 <= 102) {
                by = (byte)(by | (byte)(n2 - 97 + 10));
            } else if (n2 >= 65 && n2 <= 70) {
                by = (byte)(by | (byte)(n2 - 65 + 10));
            } else {
                throw new NumberFormatException(string16.toString());
            }
            octetString.setOctet(n, by);
        }
        return octetString;
    }

    public static UnitString toUnitString(String32 string32) {
        if (string32 == null) {
            throw new NumberFormatException();
        }
        if (string32.startsWith("'") && string32.endsWith("'B")) {
            return UnitString.toBitString(string32);
        }
        if (string32.startsWith("'") && string32.endsWith("'H")) {
            return UnitString.toOctetString(string32);
        }
        throw new NumberFormatException(string32.toString());
    }

    public static BitString toBitString(String32 string32) {
        if (string32 == null) {
            throw new NumberFormatException();
        }
        if (!string32.startsWith("'") || !string32.endsWith("'B")) {
            throw new NumberFormatException(string32.toString());
        }
        BitString bitString = new BitString(string32.length() - 3);
        int n = string32.length() - 3;
        while (n-- > 0) {
            int n2 = string32.charAt(1 + n);
            if (n2 == 49) {
                bitString.setBit(n);
                continue;
            }
            if (n2 == 48) continue;
            throw new NumberFormatException(string32.toString());
        }
        return bitString;
    }

    public static OctetString toOctetString(String32 string32) {
        if (string32 == null) {
            throw new NumberFormatException();
        }
        if (!string32.startsWith("'") || !string32.endsWith("'H")) {
            throw new NumberFormatException(string32.toString());
        }
        OctetString octetString = new OctetString((string32.length() - 3) / 2);
        int n = string32.length() - 3 + 1 & 0xFFFFFFFE;
        while (n > 0) {
            byte by;
            int n2;
            int n3 = string32.charAt(1 + (n -= 2));
            int n4 = n2 = string32.length() - 2 >= 1 + n + 1 ? string32.charAt(1 + n + 1) : 48;
            if (n3 >= 48 && n3 <= 57) {
                by = (byte)(n3 - 48 << 4);
            } else if (n3 >= 97 && n3 <= 102) {
                by = (byte)(n3 - 97 + 10 << 4);
            } else if (n3 >= 65 && n3 <= 70) {
                by = (byte)(n3 - 65 + 10 << 4);
            } else {
                throw new NumberFormatException(string32.toString());
            }
            if (n2 >= 48 && n2 <= 57) {
                by = (byte)(by | (byte)(n2 - 48));
            } else if (n2 >= 97 && n2 <= 102) {
                by = (byte)(by | (byte)(n2 - 97 + 10));
            } else if (n2 >= 65 && n2 <= 70) {
                by = (byte)(by | (byte)(n2 - 65 + 10));
            } else {
                throw new NumberFormatException(string32.toString());
            }
            octetString.setOctet(n, by);
        }
        return octetString;
    }

    public static UnitString toUnitString(String string) {
        if (string == null) {
            throw new NumberFormatException();
        }
        if (string.startsWith("'") && string.endsWith("'B")) {
            return UnitString.toBitString(string);
        }
        if (string.startsWith("'") && string.endsWith("'H")) {
            return UnitString.toOctetString(string);
        }
        throw new NumberFormatException(string.toString());
    }

    public static BitString toBitString(String string) {
        if (string == null) {
            throw new NumberFormatException();
        }
        if (string.startsWith("'") && string.endsWith("'B")) {
            BitString bitString = new BitString(string.length() - 3);
            int n = string.length() - 3;
            while (n-- > 0) {
                char c = string.charAt(1 + n);
                if (c == '1') {
                    bitString.setBit(n);
                    continue;
                }
                if (c == '0') continue;
                throw new NumberFormatException(string.toString());
            }
            return bitString;
        }
        if (string.startsWith("'") && string.endsWith("'H")) {
            BitString bitString = new BitString((string.length() - 3) * 4);
            int n = string.length() - 3 + 1 & 0xFFFFFFFE;
            while (n > 0) {
                byte by;
                int n2;
                char c = string.charAt(1 + (n -= 2));
                int n3 = n2 = string.length() - 2 >= 1 + n + 1 ? (int)string.charAt(1 + n + 1) : 48;
                if (c >= '0' && c <= '9') {
                    by = (byte)(c - 48 << 4);
                } else if (c >= 'a' && c <= 'f') {
                    by = (byte)(c - 97 + 10 << 4);
                } else if (c >= 'A' && c <= 'F') {
                    by = (byte)(c - 65 + 10 << 4);
                } else {
                    throw new NumberFormatException(string.toString());
                }
                if (n2 >= 48 && n2 <= 57) {
                    by = (byte)(by | (byte)(n2 - 48));
                } else if (n2 >= 97 && n2 <= 102) {
                    by = (byte)(by | (byte)(n2 - 97 + 10));
                } else if (n2 >= 65 && n2 <= 70) {
                    by = (byte)(by | (byte)(n2 - 65 + 10));
                } else {
                    throw new NumberFormatException(string.toString());
                }
                bitString.setOctet(n, by);
            }
            return bitString;
        }
        throw new NumberFormatException(string.toString());
    }

    public static OctetString toOctetString(String string) {
        if (string == null) {
            throw new NumberFormatException();
        }
        if (string.startsWith("'") && string.endsWith("'B'")) {
            OctetString octetString = new OctetString((string.length() - 3 + 7) / 8);
            int n = string.length() - 3;
            while (n-- > 0) {
                char c = string.charAt(1 + n);
                if (c == '1') {
                    octetString.setBit(n);
                    continue;
                }
                if (c == '0') continue;
                throw new NumberFormatException(string.toString());
            }
            return octetString;
        }
        if (string.startsWith("'") && string.endsWith("'H")) {
            OctetString octetString = new OctetString((string.length() - 3) / 2);
            int n = string.length() - 3 + 1 & 0xFFFFFFFE;
            while (n > 0) {
                byte by;
                int n2;
                char c = string.charAt(1 + (n -= 2));
                int n3 = n2 = string.length() - 2 >= 1 + n + 1 ? (int)string.charAt(1 + n + 1) : 48;
                if (c >= '0' && c <= '9') {
                    by = (byte)(c - 48 << 4);
                } else if (c >= 'a' && c <= 'f') {
                    by = (byte)(c - 97 + 10 << 4);
                } else if (c >= 'A' && c <= 'F') {
                    by = (byte)(c - 65 + 10 << 4);
                } else {
                    throw new NumberFormatException(string.toString());
                }
                if (n2 >= 48 && n2 <= 57) {
                    by = (byte)(by | (byte)(n2 - 48));
                } else if (n2 >= 97 && n2 <= 102) {
                    by = (byte)(by | (byte)(n2 - 97 + 10));
                } else if (n2 >= 65 && n2 <= 70) {
                    by = (byte)(by | (byte)(n2 - 65 + 10));
                } else {
                    throw new NumberFormatException(string.toString());
                }
                octetString.setOctet(n, by);
            }
            return octetString;
        }
        throw new NumberFormatException(string.toString());
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[(this.bitsize + 7) / 8];
        System.arraycopy(this.bits, 0, byArray, 0, (this.bitsize + 7) / 8);
        return byArray;
    }

    private byte extractByte(int n) {
        int n2 = UnitString.subscript(n);
        int n3 = n & 7;
        if (n3 == 0) {
            return this.bits[n2];
        }
        int n4 = 8 - n3;
        return (byte)(this.bits[n2] << 8 - n4 | this.bits[n2 + 1] >>> 0 + n4);
    }

    public void appendByte(byte by) {
        int n = UnitString.subscript(this.bitsize);
        int n2 = this.bitsize & 7;
        this.ensureBitCapacity(this.bitsize + 8);
        if (n2 == 0) {
            this.bits[n] = by;
        } else {
            int n3 = 8 - n2;
            int n4 = n;
            this.bits[n4] = (byte)(this.bits[n4] | by >>> n2);
            this.bits[n + 1] = (byte)(by << n3);
        }
        this.bitsize += 8;
    }

    private void putByte(int n, byte by) {
        int n2 = UnitString.subscript(n);
        int n3 = n & 7;
        if (n3 == 0) {
            this.bits[n2] = by;
        } else {
            int n4 = 8 - n3;
            this.bits[n2] = (byte)(this.bits[n2] & leftmask[n3] | by >>> n3);
            this.bits[n2 + 1] = (byte)(this.bits[n2] & rightmask[n4] | by << n4);
        }
    }

    private byte extractSByte(int n, int n2) {
        int n3 = UnitString.subscript(n);
        int n4 = n & 7;
        int n5 = 8 - n4;
        if (n5 >= n2) {
            return (byte)(this.bits[n3] << n4 >> 8 - n2);
        }
        return (byte)(this.bits[n3] << n4 >> 8 - n2 | this.bits[n3 + 1] >>> 8 - n2 + n5);
    }

    private byte extractUByte(int n, int n2) {
        int n3 = UnitString.subscript(n);
        int n4 = n & 7;
        int n5 = 8 - n4;
        if (n5 >= n2) {
            return (byte)(this.bits[n3] << n4 >>> 8 - n2);
        }
        return (byte)(this.bits[n3] << n4 >>> 8 - n2 | this.bits[n3 + 1] >>> 8 - n2 + n5);
    }

    public void appendSInteger(int n, int n2) {
        this.ensureBitCapacity(this.bitsize + n2);
        if (n2 > 32) {
            UnitString.bitfill(this.bits, this.bitsize, n2 - 32, n < 0);
            this.bitsize += n2 - 32;
            n2 = 32;
        }
        int n3 = UnitString.subscript(this.bitsize);
        int n4 = this.bitsize & 7;
        int n5 = 8 - n4;
        if (n5 >= n2) {
            int n6 = n3;
            this.bits[n6] = (byte)(this.bits[n6] | (byte)((n & rightmask[n2]) << n5 - n2));
        } else if (n5 + 8 >= n2) {
            int n7 = n3;
            this.bits[n7] = (byte)(this.bits[n7] | (byte)(n >>> n2 - n5 & rightmask[n5]));
            this.bits[n3 + 1] = (byte)(n << 8 + n5 - n2);
        } else if (n5 + 16 >= n2) {
            int n8 = n3;
            this.bits[n8] = (byte)(this.bits[n8] | (byte)(n >>> n2 - n5 & rightmask[n5]));
            this.bits[n3 + 1] = (byte)(n >>> n2 - n5 - 8);
            this.bits[n3 + 2] = (byte)(n << 16 + n5 - n2);
        } else if (n5 + 24 >= n2) {
            int n9 = n3;
            this.bits[n9] = (byte)(this.bits[n9] | (byte)(n >>> n2 - n5 & rightmask[n5]));
            this.bits[n3 + 1] = (byte)(n >>> n2 - n5 - 8);
            this.bits[n3 + 2] = (byte)(n >>> n2 - n5 - 16);
            this.bits[n3 + 3] = (byte)(n << 24 + n5 - n2);
        } else {
            int n10 = n3;
            this.bits[n10] = (byte)(this.bits[n10] | (byte)(n >>> n2 - n5 & rightmask[n5]));
            this.bits[n3 + 1] = (byte)(n >>> n2 - n5 - 8);
            this.bits[n3 + 2] = (byte)(n >>> n2 - n5 - 16);
            this.bits[n3 + 3] = (byte)(n >>> n2 - n5 - 24);
            this.bits[n3 + 4] = (byte)(n << 32 + n5 - n2);
        }
        this.bitsize += n2;
    }

    public void appendUInteger(int n, int n2) {
        this.ensureBitCapacity(this.bitsize + n2);
        if (n2 > 32) {
            this.bitsize += n2 - 32;
            n2 = 32;
        }
        int n3 = UnitString.subscript(this.bitsize);
        int n4 = this.bitsize & 7;
        int n5 = 8 - n4;
        if (n5 >= n2) {
            int n6 = n3;
            this.bits[n6] = (byte)(this.bits[n6] | (byte)((n & rightmask[n2]) << n5 - n2));
        } else if (n5 + 8 >= n2) {
            int n7 = n3;
            this.bits[n7] = (byte)(this.bits[n7] | (byte)(n >>> n2 - n5 & rightmask[n5]));
            this.bits[n3 + 1] = (byte)(n << 8 + n5 - n2);
        } else if (n5 + 16 >= n2) {
            int n8 = n3;
            this.bits[n8] = (byte)(this.bits[n8] | (byte)(n >>> n2 - n5 & rightmask[n5]));
            this.bits[n3 + 1] = (byte)(n >>> n2 - n5 - 8);
            this.bits[n3 + 2] = (byte)(n << 16 + n5 - n2);
        } else if (n5 + 24 >= n2) {
            int n9 = n3;
            this.bits[n9] = (byte)(this.bits[n9] | (byte)(n >>> n2 - n5 & rightmask[n5]));
            this.bits[n3 + 1] = (byte)(n >>> n2 - n5 - 8);
            this.bits[n3 + 2] = (byte)(n >>> n2 - n5 - 16);
            this.bits[n3 + 3] = (byte)(n << 24 + n5 - n2);
        } else {
            int n10 = n3;
            this.bits[n10] = (byte)(this.bits[n10] | (byte)(n >>> n2 - n5 & rightmask[n5]));
            this.bits[n3 + 1] = (byte)(n >>> n2 - n5 - 8);
            this.bits[n3 + 2] = (byte)(n >>> n2 - n5 - 16);
            this.bits[n3 + 3] = (byte)(n >>> n2 - n5 - 24);
            this.bits[n3 + 4] = (byte)(n << 32 + n5 - n2);
        }
        this.bitsize += n2;
    }

    public void appendSLong(long l, int n) {
        this.ensureBitCapacity(this.bitsize + n);
        if (n > 64) {
            UnitString.bitfill(this.bits, this.bitsize, n - 64, l < 0L);
            this.bitsize += n - 64;
            n = 64;
        }
        int n2 = UnitString.subscript(this.bitsize);
        int n3 = this.bitsize & 7;
        int n4 = 8 - n3;
        if (n4 >= n) {
            int n5 = n2;
            this.bits[n5] = (byte)(this.bits[n5] | (byte)((l & (long)rightmask[n]) << n4 - n));
        } else if (n4 + 8 >= n) {
            int n6 = n2;
            this.bits[n6] = (byte)(this.bits[n6] | (byte)(l >>> n - n4 & (long)rightmask[n4]));
            this.bits[n2 + 1] = (byte)(l << 8 + n4 - n);
        } else if (n4 + 16 >= n) {
            int n7 = n2;
            this.bits[n7] = (byte)(this.bits[n7] | (byte)(l >>> n - n4 & (long)rightmask[n4]));
            this.bits[n2 + 1] = (byte)(l >>> n - n4 - 8);
            this.bits[n2 + 2] = (byte)(l << 16 + n4 - n);
        } else if (n4 + 24 >= n) {
            int n8 = n2;
            this.bits[n8] = (byte)(this.bits[n8] | (byte)(l >>> n - n4 & (long)rightmask[n4]));
            this.bits[n2 + 1] = (byte)(l >>> n - n4 - 8);
            this.bits[n2 + 2] = (byte)(l >>> n - n4 - 16);
            this.bits[n2 + 3] = (byte)(l << 24 + n4 - n);
        } else if (n4 + 32 >= n) {
            int n9 = n2;
            this.bits[n9] = (byte)(this.bits[n9] | (byte)(l >>> n - n4 & (long)rightmask[n4]));
            this.bits[n2 + 1] = (byte)(l >>> n - n4 - 8);
            this.bits[n2 + 2] = (byte)(l >>> n - n4 - 16);
            this.bits[n2 + 3] = (byte)(l >>> n - n4 - 24);
            this.bits[n2 + 4] = (byte)(l << 32 + n4 - n);
        } else if (n4 + 40 >= n) {
            int n10 = n2;
            this.bits[n10] = (byte)(this.bits[n10] | (byte)(l >>> n - n4 & (long)rightmask[n4]));
            this.bits[n2 + 1] = (byte)(l >>> n - n4 - 8);
            this.bits[n2 + 2] = (byte)(l >>> n - n4 - 16);
            this.bits[n2 + 3] = (byte)(l >>> n - n4 - 24);
            this.bits[n2 + 4] = (byte)(l >>> n - n4 - 32);
            this.bits[n2 + 5] = (byte)(l << 40 + n4 - n);
        } else if (n4 + 48 >= n) {
            int n11 = n2;
            this.bits[n11] = (byte)(this.bits[n11] | (byte)(l >>> n - n4 & (long)rightmask[n4]));
            this.bits[n2 + 1] = (byte)(l >>> n - n4 - 8);
            this.bits[n2 + 2] = (byte)(l >>> n - n4 - 16);
            this.bits[n2 + 3] = (byte)(l >>> n - n4 - 24);
            this.bits[n2 + 4] = (byte)(l >>> n - n4 - 32);
            this.bits[n2 + 5] = (byte)(l >>> n - n4 - 40);
            this.bits[n2 + 6] = (byte)(l << 48 + n4 - n);
        } else if (n4 + 56 >= n) {
            int n12 = n2;
            this.bits[n12] = (byte)(this.bits[n12] | (byte)(l >>> n - n4 & (long)rightmask[n4]));
            this.bits[n2 + 1] = (byte)(l >>> n - n4 - 8);
            this.bits[n2 + 2] = (byte)(l >>> n - n4 - 16);
            this.bits[n2 + 3] = (byte)(l >>> n - n4 - 24);
            this.bits[n2 + 4] = (byte)(l >>> n - n4 - 32);
            this.bits[n2 + 5] = (byte)(l >>> n - n4 - 40);
            this.bits[n2 + 6] = (byte)(l >>> n - n4 - 48);
            this.bits[n2 + 7] = (byte)(l << 56 + n4 - n);
        } else {
            int n13 = n2;
            this.bits[n13] = (byte)(this.bits[n13] | (byte)(l >>> n - n4 & (long)rightmask[n4]));
            this.bits[n2 + 1] = (byte)(l >>> n - n4 - 8);
            this.bits[n2 + 2] = (byte)(l >>> n - n4 - 16);
            this.bits[n2 + 3] = (byte)(l >>> n - n4 - 24);
            this.bits[n2 + 4] = (byte)(l >>> n - n4 - 32);
            this.bits[n2 + 5] = (byte)(l >>> n - n4 - 40);
            this.bits[n2 + 6] = (byte)(l >>> n - n4 - 48);
            this.bits[n2 + 7] = (byte)(l >>> n - n4 - 56);
            this.bits[n2 + 8] = (byte)(l << 64 + n4 - n);
        }
        this.bitsize += n;
    }

    public void appendULong(long l, int n) {
        this.ensureBitCapacity(this.bitsize + n);
        if (n > 64) {
            this.bitsize += n - 64;
            n = 64;
        }
        int n2 = UnitString.subscript(this.bitsize);
        int n3 = this.bitsize & 7;
        int n4 = 8 - n3;
        if (n4 >= n) {
            int n5 = n2;
            this.bits[n5] = (byte)(this.bits[n5] | (byte)((l & (long)rightmask[n]) << n4 - n));
        } else if (n4 + 8 >= n) {
            int n6 = n2;
            this.bits[n6] = (byte)(this.bits[n6] | (byte)(l >>> n - n4 & (long)rightmask[n4]));
            this.bits[n2 + 1] = (byte)(l << 8 + n4 - n);
        } else if (n4 + 16 >= n) {
            int n7 = n2;
            this.bits[n7] = (byte)(this.bits[n7] | (byte)(l >>> n - n4 & (long)rightmask[n4]));
            this.bits[n2 + 1] = (byte)(l >>> n - n4 - 8);
            this.bits[n2 + 2] = (byte)(l << 16 + n4 - n);
        } else if (n4 + 24 >= n) {
            int n8 = n2;
            this.bits[n8] = (byte)(this.bits[n8] | (byte)(l >>> n - n4 & (long)rightmask[n4]));
            this.bits[n2 + 1] = (byte)(l >>> n - n4 - 8);
            this.bits[n2 + 2] = (byte)(l >>> n - n4 - 16);
            this.bits[n2 + 3] = (byte)(l << 24 + n4 - n);
        } else if (n4 + 32 >= n) {
            int n9 = n2;
            this.bits[n9] = (byte)(this.bits[n9] | (byte)(l >>> n - n4 & (long)rightmask[n4]));
            this.bits[n2 + 1] = (byte)(l >>> n - n4 - 8);
            this.bits[n2 + 2] = (byte)(l >>> n - n4 - 16);
            this.bits[n2 + 3] = (byte)(l >>> n - n4 - 24);
            this.bits[n2 + 4] = (byte)(l << 32 + n4 - n);
        } else if (n4 + 40 >= n) {
            int n10 = n2;
            this.bits[n10] = (byte)(this.bits[n10] | (byte)(l >>> n - n4 & (long)rightmask[n4]));
            this.bits[n2 + 1] = (byte)(l >>> n - n4 - 8);
            this.bits[n2 + 2] = (byte)(l >>> n - n4 - 16);
            this.bits[n2 + 3] = (byte)(l >>> n - n4 - 24);
            this.bits[n2 + 4] = (byte)(l >>> n - n4 - 32);
            this.bits[n2 + 5] = (byte)(l << 40 + n4 - n);
        } else if (n4 + 48 >= n) {
            int n11 = n2;
            this.bits[n11] = (byte)(this.bits[n11] | (byte)(l >>> n - n4 & (long)rightmask[n4]));
            this.bits[n2 + 1] = (byte)(l >>> n - n4 - 8);
            this.bits[n2 + 2] = (byte)(l >>> n - n4 - 16);
            this.bits[n2 + 3] = (byte)(l >>> n - n4 - 24);
            this.bits[n2 + 4] = (byte)(l >>> n - n4 - 32);
            this.bits[n2 + 5] = (byte)(l >>> n - n4 - 40);
            this.bits[n2 + 6] = (byte)(l << 48 + n4 - n);
        } else if (n4 + 56 >= n) {
            int n12 = n2;
            this.bits[n12] = (byte)(this.bits[n12] | (byte)(l >>> n - n4 & (long)rightmask[n4]));
            this.bits[n2 + 1] = (byte)(l >>> n - n4 - 8);
            this.bits[n2 + 2] = (byte)(l >>> n - n4 - 16);
            this.bits[n2 + 3] = (byte)(l >>> n - n4 - 24);
            this.bits[n2 + 4] = (byte)(l >>> n - n4 - 32);
            this.bits[n2 + 5] = (byte)(l >>> n - n4 - 40);
            this.bits[n2 + 6] = (byte)(l >>> n - n4 - 48);
            this.bits[n2 + 7] = (byte)(l << 56 + n4 - n);
        } else {
            int n13 = n2;
            this.bits[n13] = (byte)(this.bits[n13] | (byte)(l >>> n - n4 & (long)rightmask[n4]));
            this.bits[n2 + 1] = (byte)(l >>> n - n4 - 8);
            this.bits[n2 + 2] = (byte)(l >>> n - n4 - 16);
            this.bits[n2 + 3] = (byte)(l >>> n - n4 - 24);
            this.bits[n2 + 4] = (byte)(l >>> n - n4 - 32);
            this.bits[n2 + 5] = (byte)(l >>> n - n4 - 40);
            this.bits[n2 + 6] = (byte)(l >>> n - n4 - 48);
            this.bits[n2 + 7] = (byte)(l >>> n - n4 - 56);
            this.bits[n2 + 8] = (byte)(l << 64 + n4 - n);
        }
        this.bitsize += n;
    }

    public void appendSBigInteger(BigInteger bigInteger, int n) {
        byte[] byArray = bigInteger.toByteArray();
        int n2 = byArray.length << 3;
        this.ensureBitCapacity(this.bitsize + n);
        if (n > n2) {
            UnitString.bitfill(this.bits, this.bitsize, n - n2, byArray[0] < 0);
            this.bitsize += n - n2;
            n = n2;
        }
        UnitString.bitcpy(this.bits, this.bitsize, byArray, n2 - n, n);
        this.bitsize += n;
    }

    public void appendUBigInteger(BigInteger bigInteger, int n) {
        byte[] byArray = bigInteger.toByteArray();
        int n2 = byArray.length << 3;
        this.ensureBitCapacity(this.bitsize + n);
        if (n > n2) {
            this.bitsize += n - n2;
            n = n2;
        }
        UnitString.bitcpy(this.bits, this.bitsize, byArray, n2 - n, n);
        this.bitsize += n;
    }

    public void appendString16(String16 string16, int n, int n2) {
        int n3;
        this.ensureBitCapacity(this.bitsize + n * n2);
        if (n2 > 16) {
            n3 = n2 - 16;
            n2 = 16;
        } else {
            n3 = 0;
        }
        int n4 = 0;
        while (n4 < n) {
            this.bitsize += n3;
            int n5 = UnitString.subscript(this.bitsize);
            int n6 = this.bitsize & 7;
            int n7 = 8 - n6;
            short s = (short)string16.charAt(n4);
            if (n7 >= n2) {
                int n8 = n5;
                this.bits[n8] = (byte)(this.bits[n8] | (byte)((s & rightmask[n2]) << n7 - n2));
            } else if (n7 + 8 >= n2) {
                int n9 = n5;
                this.bits[n9] = (byte)(this.bits[n9] | (byte)(s >>> n2 - n7 & rightmask[n7]));
                this.bits[n5 + 1] = (byte)(s << 8 + n7 - n2);
            } else {
                int n10 = n5;
                this.bits[n10] = (byte)(this.bits[n10] | (byte)(s >>> n2 - n7 & rightmask[n7]));
                this.bits[n5 + 1] = (byte)(s >>> n2 - n7 - 8);
                this.bits[n5 + 2] = (byte)(s << 16 + n7 - n2);
            }
            this.bitsize += n2;
            ++n4;
        }
    }

    public void appendString32(String32 string32, int n, int n2) {
        int n3;
        this.ensureBitCapacity(this.bitsize + n * n2);
        if (n2 > 32) {
            n3 = n2 - 32;
            n2 = 32;
        } else {
            n3 = 0;
        }
        int n4 = 0;
        while (n4 < n) {
            this.bitsize += n3;
            int n5 = UnitString.subscript(this.bitsize);
            int n6 = this.bitsize & 7;
            int n7 = 8 - n6;
            int n8 = string32.charAt(n4);
            if (n7 >= n2) {
                int n9 = n5;
                this.bits[n9] = (byte)(this.bits[n9] | (byte)((n8 & rightmask[n2]) << n7 - n2));
            } else if (n7 + 8 >= n2) {
                int n10 = n5;
                this.bits[n10] = (byte)(this.bits[n10] | (byte)(n8 >>> n2 - n7 & rightmask[n7]));
                this.bits[n5 + 1] = (byte)(n8 << 8 + n7 - n2);
            } else if (n7 + 16 >= n2) {
                int n11 = n5;
                this.bits[n11] = (byte)(this.bits[n11] | (byte)(n8 >>> n2 - n7 & rightmask[n7]));
                this.bits[n5 + 1] = (byte)(n8 >>> n2 - n7 - 8);
                this.bits[n5 + 2] = (byte)(n8 << 16 + n7 - n2);
            } else if (n7 + 24 >= n2) {
                int n12 = n5;
                this.bits[n12] = (byte)(this.bits[n12] | (byte)(n8 >>> n2 - n7 & rightmask[n7]));
                this.bits[n5 + 1] = (byte)(n8 >>> n2 - n7 - 8);
                this.bits[n5 + 2] = (byte)(n8 >>> n2 - n7 - 16);
                this.bits[n5 + 3] = (byte)(n8 << 24 + n7 - n2);
            } else {
                int n13 = n5;
                this.bits[n13] = (byte)(this.bits[n13] | (byte)(n8 >>> n2 - n7 & rightmask[n7]));
                this.bits[n5 + 1] = (byte)(n8 >>> n2 - n7 - 8);
                this.bits[n5 + 2] = (byte)(n8 >>> n2 - n7 - 16);
                this.bits[n5 + 3] = (byte)(n8 >>> n2 - n7 - 24);
                this.bits[n5 + 4] = (byte)(n8 << 32 + n7 - n2);
            }
            this.bitsize += n2;
            ++n4;
        }
    }

    public int getSInteger(int n, int n2) throws ValueTooLargeException {
        this.checkBitRange(n, n2);
        if (n2 > 32) {
            try {
                if (this.getBit(n)) {
                    this.getOnes(n + 1, n2 - 32);
                } else {
                    this.getZeros(n + 1, n2 - 32);
                }
            }
            catch (BadDataException badDataException) {
                throw new ValueTooLargeException();
            }
            n += n2 - 32;
            n2 = 32;
        }
        int n3 = UnitString.subscript(n);
        int n4 = n & 7;
        int n5 = 8 - n4;
        int n6 = n5 >= n2 ? this.bits[n3] << n4 + 24 >> 32 - n2 : (n5 + 8 >= n2 ? (this.bits[n3] << n4 + 24 | (this.bits[n3 + 1] & 0xFF) << n4 + 16) >> 32 - n2 : (n5 + 16 >= n2 ? (this.bits[n3] << n4 + 24 | (this.bits[n3 + 1] & 0xFF) << n4 + 16 | (this.bits[n3 + 2] & 0xFF) << n4 + 8) >> 32 - n2 : (n5 + 24 >= n2 ? (this.bits[n3] << n4 + 24 | (this.bits[n3 + 1] & 0xFF) << n4 + 16 | (this.bits[n3 + 2] & 0xFF) << n4 + 8 | (this.bits[n3 + 3] & 0xFF) << n4) >> 32 - n2 : (this.bits[n3] << n4 + 24 | (this.bits[n3 + 1] & 0xFF) << n4 + 16 | (this.bits[n3 + 2] & 0xFF) << n4 + 8 | (this.bits[n3 + 3] & 0xFF) << n4 | (this.bits[n3 + 4] & 0xFF) >> n5) >> 32 - n2)));
        return n6;
    }

    public int getUInteger(int n, int n2) throws ValueTooLargeException {
        this.checkBitRange(n, n2);
        if (n2 > 32) {
            try {
                if (this.getBit(n)) {
                    this.getOnes(n + 1, n2 - 32);
                } else {
                    this.getZeros(n + 1, n2 - 32);
                }
            }
            catch (BadDataException badDataException) {
                throw new ValueTooLargeException();
            }
            n += n2 - 32;
            n2 = 32;
        }
        int n3 = UnitString.subscript(n);
        int n4 = n & 7;
        int n5 = 8 - n4;
        int n6 = n5 >= n2 ? this.bits[n3] << n4 + 24 >>> 32 - n2 : (n5 + 8 >= n2 ? (this.bits[n3] << n4 + 24 | (this.bits[n3 + 1] & 0xFF) << n4 + 16) >>> 32 - n2 : (n5 + 16 >= n2 ? (this.bits[n3] << n4 + 24 | (this.bits[n3 + 1] & 0xFF) << n4 + 16 | (this.bits[n3 + 2] & 0xFF) << n4 + 8) >>> 32 - n2 : (n5 + 24 >= n2 ? (this.bits[n3] << n4 + 24 | (this.bits[n3 + 1] & 0xFF) << n4 + 16 | (this.bits[n3 + 2] & 0xFF) << n4 + 8 | (this.bits[n3 + 3] & 0xFF) << n4) >>> 32 - n2 : (this.bits[n3] << n4 + 24 | (this.bits[n3 + 1] & 0xFF) << n4 + 16 | (this.bits[n3 + 2] & 0xFF) << n4 + 8 | (this.bits[n3 + 3] & 0xFF) << n4 | (this.bits[n3 + 4] & 0xFF) >> n5) >>> 32 - n2)));
        return n6;
    }

    public long getSLong(int n, int n2) throws ValueTooLargeException {
        this.checkBitRange(n, n2);
        if (n2 > 64) {
            try {
                if (this.getBit(n)) {
                    this.getOnes(n + 1, n2 - 64);
                } else {
                    this.getZeros(n + 1, n2 - 64);
                }
            }
            catch (BadDataException badDataException) {
                throw new ValueTooLargeException();
            }
            n += n2 - 64;
            n2 = 64;
        }
        int n3 = UnitString.subscript(n);
        int n4 = n & 7;
        int n5 = 8 - n4;
        long l = n5 >= n2 ? (long)(this.bits[n3] << n4 + 24 >> 32 - n2) : (n5 + 8 >= n2 ? (long)((this.bits[n3] << n4 + 24 | (this.bits[n3 + 1] & 0xFF) << n4 + 16) >> 32 - n2) : (n5 + 16 >= n2 ? (long)((this.bits[n3] << n4 + 24 | (this.bits[n3 + 1] & 0xFF) << n4 + 16 | (this.bits[n3 + 2] & 0xFF) << n4 + 8) >> 32 - n2) : (n5 + 24 >= n2 ? (long)((this.bits[n3] << n4 + 24 | (this.bits[n3 + 1] & 0xFF) << n4 + 16 | (this.bits[n3 + 2] & 0xFF) << n4 + 8 | (this.bits[n3 + 3] & 0xFF) << n4) >> 32 - n2) : (n5 + 32 >= n2 ? ((long)this.bits[n3] << n4 + 56 | ((long)this.bits[n3 + 1] & 0xFFL) << n4 + 48 | ((long)this.bits[n3 + 2] & 0xFFL) << n4 + 40 | ((long)this.bits[n3 + 3] & 0xFFL) << n4 + 32 | ((long)this.bits[n3 + 4] & 0xFFL) << n4 + 24) >> 64 - n2 : (n5 + 40 >= n2 ? ((long)this.bits[n3] << n4 + 56 | ((long)this.bits[n3 + 1] & 0xFFL) << n4 + 48 | ((long)this.bits[n3 + 2] & 0xFFL) << n4 + 40 | ((long)this.bits[n3 + 3] & 0xFFL) << n4 + 32 | ((long)this.bits[n3 + 4] & 0xFFL) << n4 + 24 | ((long)this.bits[n3 + 5] & 0xFFL) << n4 + 16) >> 64 - n2 : (n5 + 48 >= n2 ? ((long)this.bits[n3] << n4 + 56 | ((long)this.bits[n3 + 1] & 0xFFL) << n4 + 48 | ((long)this.bits[n3 + 2] & 0xFFL) << n4 + 40 | ((long)this.bits[n3 + 3] & 0xFFL) << n4 + 32 | ((long)this.bits[n3 + 4] & 0xFFL) << n4 + 24 | ((long)this.bits[n3 + 5] & 0xFFL) << n4 + 16 | ((long)this.bits[n3 + 6] & 0xFFL) << n4 + 8) >> 64 - n2 : (n5 + 56 >= n2 ? ((long)this.bits[n3] << n4 + 56 | ((long)this.bits[n3 + 1] & 0xFFL) << n4 + 48 | ((long)this.bits[n3 + 2] & 0xFFL) << n4 + 40 | ((long)this.bits[n3 + 3] & 0xFFL) << n4 + 32 | ((long)this.bits[n3 + 4] & 0xFFL) << n4 + 24 | ((long)this.bits[n3 + 5] & 0xFFL) << n4 + 16 | ((long)this.bits[n3 + 6] & 0xFFL) << n4 + 8 | ((long)this.bits[n3 + 7] & 0xFFL) << n4) >> 64 - n2 : ((long)this.bits[n3] << n4 + 56 | ((long)this.bits[n3 + 1] & 0xFFL) << n4 + 48 | ((long)this.bits[n3 + 2] & 0xFFL) << n4 + 40 | ((long)this.bits[n3 + 3] & 0xFFL) << n4 + 32 | ((long)this.bits[n3 + 4] & 0xFFL) << n4 + 24 | ((long)this.bits[n3 + 5] & 0xFFL) << n4 + 16 | ((long)this.bits[n3 + 6] & 0xFFL) << n4 + 8 | ((long)this.bits[n3 + 7] & 0xFFL) << n4 | ((long)this.bits[n3 + 8] & 0xFFL) >> n5) >> 64 - n2)))))));
        return l;
    }

    public long getULong(int n, int n2) throws ValueTooLargeException {
        this.checkBitRange(n, n2);
        if (n2 > 64) {
            try {
                if (this.getBit(n)) {
                    this.getOnes(n + 1, n2 - 64);
                } else {
                    this.getZeros(n + 1, n2 - 64);
                }
            }
            catch (BadDataException badDataException) {
                throw new ValueTooLargeException();
            }
            n += n2 - 64;
            n2 = 64;
        }
        int n3 = UnitString.subscript(n);
        int n4 = n & 7;
        int n5 = 8 - n4;
        long l = n5 >= n2 ? (long)this.bits[n3] << n4 + 56 >>> 64 - n2 : (n5 + 8 >= n2 ? ((long)this.bits[n3] << n4 + 56 | ((long)this.bits[n3 + 1] & 0xFFL) << n4 + 48) >>> 64 - n2 : (n5 + 16 >= n2 ? ((long)this.bits[n3] << n4 + 56 | ((long)this.bits[n3 + 1] & 0xFFL) << n4 + 48 | ((long)this.bits[n3 + 2] & 0xFFL) << n4 + 40) >>> 64 - n2 : (n5 + 24 >= n2 ? ((long)this.bits[n3] << n4 + 56 | ((long)this.bits[n3 + 1] & 0xFFL) << n4 + 48 | ((long)this.bits[n3 + 2] & 0xFFL) << n4 + 40 | ((long)this.bits[n3 + 3] & 0xFFL) << n4 + 32) >>> 64 - n2 : (n5 + 32 >= n2 ? ((long)this.bits[n3] << n4 + 56 | ((long)this.bits[n3 + 1] & 0xFFL) << n4 + 48 | ((long)this.bits[n3 + 2] & 0xFFL) << n4 + 40 | ((long)this.bits[n3 + 3] & 0xFFL) << n4 + 32 | ((long)this.bits[n3 + 4] & 0xFFL) << n4 + 24) >>> 64 - n2 : (n5 + 40 >= n2 ? ((long)this.bits[n3] << n4 + 56 | ((long)this.bits[n3 + 1] & 0xFFL) << n4 + 48 | ((long)this.bits[n3 + 2] & 0xFFL) << n4 + 40 | ((long)this.bits[n3 + 3] & 0xFFL) << n4 + 32 | ((long)this.bits[n3 + 4] & 0xFFL) << n4 + 24 | ((long)this.bits[n3 + 5] & 0xFFL) << n4 + 16) >>> 64 - n2 : (n5 + 48 >= n2 ? ((long)this.bits[n3] << n4 + 56 | ((long)this.bits[n3 + 1] & 0xFFL) << n4 + 48 | ((long)this.bits[n3 + 2] & 0xFFL) << n4 + 40 | ((long)this.bits[n3 + 3] & 0xFFL) << n4 + 32 | ((long)this.bits[n3 + 4] & 0xFFL) << n4 + 24 | ((long)this.bits[n3 + 5] & 0xFFL) << n4 + 16 | ((long)this.bits[n3 + 6] & 0xFFL) << n4 + 8) >>> 64 - n2 : (n5 + 56 >= n2 ? ((long)this.bits[n3] << n4 + 56 | ((long)this.bits[n3 + 1] & 0xFFL) << n4 + 48 | ((long)this.bits[n3 + 2] & 0xFFL) << n4 + 40 | ((long)this.bits[n3 + 3] & 0xFFL) << n4 + 32 | ((long)this.bits[n3 + 4] & 0xFFL) << n4 + 24 | ((long)this.bits[n3 + 5] & 0xFFL) << n4 + 16 | ((long)this.bits[n3 + 6] & 0xFFL) << n4 + 8 | ((long)this.bits[n3 + 7] & 0xFFL) << n4) >>> 64 - n2 : ((long)this.bits[n3] << n4 + 56 | ((long)this.bits[n3 + 1] & 0xFFL) << n4 + 48 | ((long)this.bits[n3 + 2] & 0xFFL) << n4 + 40 | ((long)this.bits[n3 + 3] & 0xFFL) << n4 + 32 | ((long)this.bits[n3 + 4] & 0xFFL) << n4 + 24 | ((long)this.bits[n3 + 5] & 0xFFL) << n4 + 16 | ((long)this.bits[n3 + 6] & 0xFFL) << n4 + 8 | ((long)this.bits[n3 + 7] & 0xFFL) << n4 | ((long)this.bits[n3 + 8] & 0xFFL) >> n5) >>> 64 - n2)))))));
        return l;
    }

    public BigInteger getSBigInteger(int n, int n2) {
        this.checkBitRange(n, n2);
        int n3 = n2 + 7 >> 3;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        if ((n2 & 7) != 0) {
            byArray[n4++] = this.extractSByte(n, n2 & 7);
            n += n2 & 7;
        }
        while (n4 < n3) {
            byArray[n4++] = this.extractByte(n);
            n += 8;
        }
        return new BigInteger(byArray);
    }

    public BigInteger getUBigInteger(int n, int n2) {
        this.checkBitRange(n, n2);
        int n3 = n2 + 15 >> 3;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        byArray[n4++] = 0;
        if ((n2 & 7) != 0) {
            byArray[n4++] = this.extractUByte(n, n2 & 7);
            n += n2 & 7;
        }
        while (n4 < n3) {
            byArray[n4++] = this.extractByte(n);
            n += 8;
        }
        return new BigInteger(byArray);
    }

    public String getString(int n, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer(n2);
        stringBuffer.setLength(n2);
        UnitString.checkSize(n3);
        if (n3 > 16) {
            throw new IndexOutOfBoundsException(Integer.toString(n3));
        }
        this.checkBitRange(n, n2 * n3);
        try {
            int n4 = 0;
            while (n4 < n2) {
                stringBuffer.setCharAt(n4, (char)this.getUInteger(n, n3));
                n += n3;
                ++n4;
            }
        }
        catch (ValueTooLargeException valueTooLargeException) {
            throw new InternalError();
        }
        return stringBuffer.toString();
    }

    public String32 getString32(int n, int n2, int n3) {
        String32Buffer string32Buffer = new String32Buffer(n2);
        string32Buffer.setLength(n2);
        UnitString.checkSize(n3);
        if (n3 > 32) {
            throw new IndexOutOfBoundsException(Integer.toString(n3));
        }
        this.checkBitRange(n, n2 * n3);
        try {
            int n4 = 0;
            while (n4 < n2) {
                string32Buffer.setCharAt(n4, this.getUInteger(n, n3));
                n += n3;
                ++n4;
            }
        }
        catch (ValueTooLargeException valueTooLargeException) {
            throw new InternalError();
        }
        return string32Buffer.toString32();
    }

    /*
     * Unable to fully structure code
     */
    public void getByteArray(byte[] var1_1, int var2_2, int var3_3, int var4_4) {
        this.checkBitRange(var3_3, var4_4);
        this.checkBitRange(var2_2 * 8, var4_4, var1_1.length * 8);
        if ((var4_4 & 7) == 0) ** GOTO lbl8
        throw new IllegalArgumentException(Integer.toString(var4_4));
lbl-1000:
        // 1 sources

        {
            var1_1[var2_2++] = this.extractByte(var3_3);
            var3_3 += 8;
            var4_4 -= 8;
lbl8:
            // 2 sources

            ** while (var4_4 >= 8)
        }
lbl9:
        // 1 sources

    }

    public byte[] getInternalByteArray() {
        return this.bits;
    }

    public void getZeros(int n, int n2) throws BadDataException {
        this.checkBitRange(n, n2);
        if (UnitString.bitscan(this.bits, n, n2) < n + n2) {
            throw new BadDataException();
        }
    }

    public void getOnes(int n, int n2) throws BadDataException {
        this.checkBitRange(n, n2);
        if (UnitString.bitcscan(this.bits, n, n2) < n + n2) {
            throw new BadDataException();
        }
    }

    protected static final int subscript(int n) {
        return n >> 3;
    }

    protected static final int sublength(int n) {
        return n + 7 >> 3;
    }

    protected final void checkBitIndex(int n) {
        this.checkBitIndex(n, this.bitsize);
    }

    protected void checkBitIndex(int n, int n2) {
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
    }

    protected final void checkBitRange(int n, int n2) {
        this.checkBitRange(n, n2, this.bitsize);
    }

    protected void checkBitRange(int n, int n2, int n3) {
        if (n2 < 0) {
            throw new NegativeArraySizeException(Integer.toString(n2));
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        if (n > n3 - n2) {
            throw new IndexOutOfBoundsException(Integer.toString(n + n2 - 1));
        }
    }

    protected static final void checkSize(int n) {
        if (n < 0) {
            throw new NegativeArraySizeException(Integer.toString(n));
        }
    }

    protected static final void checkUnitSize(int n) {
        if (n != 1 && n != 8) {
            throw new IllegalArgumentException(Integer.toString(n));
        }
    }

    protected void checkBitLength(int n) {
        if (n < 0) {
            throw new NegativeArraySizeException(Integer.toString(n));
        }
        if (n % this.unitsize != 0) {
            throw new IllegalArgumentException(Integer.toString(n));
        }
    }

    protected static final void bitclr(byte[] byArray, int n, int n2) {
        int n3 = UnitString.subscript(n);
        int n4 = n & 7;
        int n5 = 8 - n4;
        if (n2 >= n5) {
            int n6 = n3++;
            byArray[n6] = (byte)(byArray[n6] & leftmask[n4]);
            n2 -= n5;
            while (n2 >= 8) {
                byArray[n3++] = 0;
                n2 -= 8;
            }
            if (n2 > 0) {
                int n7 = n3;
                byArray[n7] = (byte)(byArray[n7] & rightmask[8 - n2]);
            }
        } else {
            int n8 = n3;
            byArray[n8] = (byte)(byArray[n8] & ~(leftmask[n2] >>> n4));
        }
    }

    protected static final void bitset(byte[] byArray, int n, int n2) {
        int n3 = UnitString.subscript(n);
        int n4 = n & 7;
        int n5 = 8 - n4;
        if (n2 >= n5) {
            int n6 = n3++;
            byArray[n6] = (byte)(byArray[n6] | rightmask[n5]);
            n2 -= n5;
            while (n2 >= 8) {
                byArray[n3++] = -1;
                n2 -= 8;
            }
            if (n2 > 0) {
                int n7 = n3;
                byArray[n7] = (byte)(byArray[n7] | leftmask[n2]);
            }
        } else {
            int n8 = n3;
            byArray[n8] = (byte)(byArray[n8] | leftmask[n2] >>> n4);
        }
    }

    protected static final void bitfill(byte[] byArray, int n, int n2, boolean bl) {
        if (bl) {
            UnitString.bitset(byArray, n, n2);
        } else {
            UnitString.bitclr(byArray, n, n2);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected static final void bitcpy(byte[] var0, int var1_1, byte[] var2_2, int var3_3, int var4_4) {
        block6: {
            block4: {
                block5: {
                    if (var4_4 == 0) {
                        return;
                    }
                    var5_5 = UnitString.subscript(var1_1);
                    var6_6 = UnitString.subscript(var3_3);
                    var7_7 = var1_1 & 7;
                    var8_8 = var3_3 & 7;
                    var9_9 = 8 - var7_7;
                    var10_10 = 8 - var8_8;
                    if (var4_4 < var9_9) break block4;
                    var11_11 = var10_10 >= var9_9 ? (byte)(var2_2[var6_6] << var8_8) : (byte)(var2_2[var6_6] << var8_8 | (var2_2[var6_6 + 1] & 255) >>> var10_10);
                    var0[var5_5] = (byte)(var0[var5_5] & UnitString.leftmask[var7_7] | (var11_11 & 255) >>> var7_7);
                    var4_4 -= var9_9;
                    if ((var8_8 += var9_9) >= 8) {
                        var8_8 -= 8;
                        ++var6_6;
                    }
                    var10_10 = 8 - var8_8;
                    ++var5_5;
                    if (var4_4 < 8) break block5;
                    if (var8_8 != 0) ** GOTO lbl30
                    var12_13 = UnitString.subscript(var4_4);
                    System.arraycopy(var2_2, var6_6, var0, var5_5, var12_13);
                    var6_6 += var12_13;
                    var5_5 += var12_13;
                    var4_4 &= 7;
                    break block5;
lbl-1000:
                    // 1 sources

                    {
                        var11_11 = (byte)(var2_2[var6_6] << var8_8 | (var2_2[var6_6 + 1] & 255) >>> var10_10);
                        var0[var5_5++] = var11_11;
                        ++var6_6;
                        var4_4 -= 8;
lbl30:
                        // 2 sources

                        ** while (var4_4 >= 8)
                    }
                }
                if (var4_4 > 0) {
                    var11_11 = var10_10 >= var4_4 ? (byte)(var2_2[var6_6] << var8_8) : (byte)(var2_2[var6_6] << var8_8 | (var2_2[var6_6 + 1] & 255) >>> var10_10);
                    var0[var5_5] = (byte)(var11_11 & UnitString.leftmask[var4_4] | var0[var5_5] & UnitString.rightmask[8 - var4_4]);
                }
                break block6;
            }
            var11_12 = var10_10 >= var4_4 ? (byte)(var2_2[var6_6] << var8_8) : (byte)(var2_2[var6_6] << var8_8 | (var2_2[var6_6 + 1] & 255) >>> var10_10);
            var0[var5_5] = (byte)(var0[var5_5] & UnitString.leftmask[var7_7] | (var11_12 & 255 & UnitString.leftmask[var4_4]) >>> var7_7 | var0[var5_5] & UnitString.rightmask[var9_9 - var4_4]);
        }
    }

    protected static final void bitmove(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (byArray != byArray2 || n <= n2 || n >= n2 + n3) {
            UnitString.bitcpy(byArray, n, byArray2, n2, n3);
        } else {
            UnitString.bitcpy(byArray, n, (byte[])byArray2.clone(), n2, n3);
        }
    }

    protected static final int bitscan(byte[] byArray, int n, int n2) {
        int n3 = UnitString.subscript(n);
        int n4 = n & 7;
        if (n4 != 0) {
            while (n4 < 8 && n2 > 0) {
                if ((byArray[n3] & bitmask[n4]) != 0) {
                    return n;
                }
                ++n;
                ++n4;
                --n2;
            }
            ++n3;
        }
        while (n2 >= 8) {
            if (byArray[n3] != 0) {
                n4 = 0;
                while (n4 < 8) {
                    if ((byArray[n3] & bitmask[n4]) != 0) {
                        return n;
                    }
                    ++n;
                    ++n4;
                }
            }
            n += 8;
            ++n3;
            n2 -= 8;
        }
        if (n2 > 0) {
            n4 = 0;
            while (n4 < n2) {
                if ((byArray[n3] & bitmask[n4]) != 0) {
                    return n;
                }
                ++n;
                ++n4;
            }
        }
        return n;
    }

    protected static final int bitcscan(byte[] byArray, int n, int n2) {
        int n3 = UnitString.subscript(n);
        int n4 = n & 7;
        if (n4 != 0) {
            while (n4 < 8 && n2 > 0) {
                if ((byArray[n3] & bitmask[n4]) == 0) {
                    return n;
                }
                ++n;
                ++n4;
                --n2;
            }
            ++n3;
        }
        while (n2 >= 8) {
            if (byArray[n3] != -1) {
                n4 = 0;
                while (n4 < 8) {
                    if ((byArray[n3] & bitmask[n4]) == 0) {
                        return n;
                    }
                    ++n;
                    ++n4;
                }
            }
            n += 8;
            ++n3;
            n2 -= 8;
        }
        if (n2 > 0) {
            n4 = 0;
            while (n4 < n2) {
                if ((byArray[n3] & bitmask[n4]) == 0) {
                    return n;
                }
                ++n;
                ++n4;
            }
        }
        return n;
    }
}

