/*
 * Decompiled with CFR 0.152.
 */
package com.bea.sslplus;

import com.certicom.net.ssl.SSLContext;
import com.certicom.security.cert.internal.x509.SSLPlusSupport;
import com.certicom.tls.ciphersuite.CipherSuiteSupport;
import com.certicom.tls.interfaceimpl.TLSSystem;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import weblogic.security.utils.BasicConstraintsSSLContextDelegate;
import weblogic.security.utils.SSLHostnameVerifier;
import weblogic.security.utils.SSLTruster;

public class CerticomSSLContext
implements BasicConstraintsSSLContextDelegate {
    private SSLContext sslCtx = new SSLContext();

    public void addTrustedCA(X509Certificate x509Certificate) throws CertificateException {
        this.sslCtx.addTrustedCertificate(x509Certificate);
    }

    public X509Certificate[] getTrustedCAs() {
        return this.sslCtx.getCertificateSupport().getTrustedCertificates();
    }

    public PrivateKey inputPrivateKey(InputStream inputStream, char[] cArray) throws KeyManagementException {
        return SSLPlusSupport.getLocalIdentityPrivateKey(inputStream, cArray);
    }

    public X509Certificate[] inputCertChain(InputStream inputStream) throws KeyManagementException {
        return SSLPlusSupport.getLocalIdentityCertChain(inputStream);
    }

    public void loadLocalIdentity(InputStream inputStream, char[] cArray) throws KeyManagementException {
        this.sslCtx.loadLocalIdentity(inputStream, cArray);
    }

    public void loadTrustedCerts(InputStream inputStream) throws CertificateException, KeyManagementException {
        this.sslCtx.loadTrustedCertificates(inputStream);
    }

    public void addIdentity(X509Certificate[] x509CertificateArray, PrivateKey privateKey) {
        this.sslCtx.addAuthChain(x509CertificateArray, privateKey);
    }

    public boolean doKeysMatch(PublicKey publicKey, PrivateKey privateKey) throws KeyManagementException {
        return this.sslCtx.getCertificateSupport().CheckIfKeyMatch(publicKey, privateKey);
    }

    public void setExportRefreshCount(int n) {
        this.sslCtx.getCertificateSupport().setExportKeyRefreshCountLimit(n);
    }

    public void setProtocolVersion(int n) throws IllegalArgumentException {
        String string = null;
        switch (n) {
            case 0: {
                string = "TLS1-ONLY";
                break;
            }
            case 1: {
                string = "SSL3-ONLY";
                break;
            }
            case 2: {
                string = "TLS";
                break;
            }
            case 3: {
                string = "TLS1/2HI";
                break;
            }
            case 4: {
                string = "SSL3/2HI";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.sslCtx.setHelloProtocol(string);
    }

    public SSLServerSocketFactory getSSLServerSocketFactory() {
        return this.sslCtx.getServerSocketFactory();
    }

    public SSLServerSocketFactory getSSLNioServerSocketFactory() {
        return this.sslCtx.getNioServerSocketFactory();
    }

    public SSLSocketFactory getSSLNioSocketFactory() {
        return this.sslCtx.getNioSocketFactory();
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.sslCtx.getSocketFactory();
    }

    public void setTrustManager(SSLTruster sSLTruster) {
        this.sslCtx.getCertificateSupport().setWLSTruster(sSLTruster);
    }

    public SSLTruster getTrustManager() {
        return this.sslCtx.getCertificateSupport().getWLSTruster();
    }

    public void setHostnameVerifier(SSLHostnameVerifier sSLHostnameVerifier) {
        this.sslCtx.getCertificateSupport().setWLSVerifier(sSLHostnameVerifier);
    }

    public SSLHostnameVerifier getHostnameVerifier() {
        return this.sslCtx.getCertificateSupport().getWLSVerifier();
    }

    public void forceHandshakeOnAcceptedSocket(SSLSocket sSLSocket) throws IOException {
        sSLSocket.startHandshake();
    }

    public void enforceConstraints(int n) {
        TLSSystem.setX509BasicConstraintBug(n == 0);
        TLSSystem.setX509StrictConstraints(n == 2 || n == 3);
        TLSSystem.setX509NoV1CAs(n == 4 || n == 3);
    }

    public void enableUnencryptedNullCipher(boolean bl) {
        CipherSuiteSupport.enableUnencryptedNullCipher(bl);
    }

    public boolean isUnencryptedNullCipherEnabled() {
        return CipherSuiteSupport.isUnEncrytedNullCipherAllowed();
    }
}

