/*
 * Decompiled with CFR 0.152.
 */
package com.bea.sslplus;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.nio.InputSSLIOChannelWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;
import java.util.Set;

public class Channel2StreamUtil {

    public static class ChanOutputStream
    extends OutputStream {
        private final WritableByteChannel sc;
        private ByteBuffer lastByteBuffer;
        private byte[] lastByteArray;

        public ChanOutputStream(WritableByteChannel writableByteChannel) {
            this.sc = writableByteChannel;
            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "ChanOutputStream created for " + writableByteChannel, null);
            }
        }

        private ByteBuffer getByteBuffer(byte[] byArray, int n, int n2) {
            if (byArray != this.lastByteArray) {
                this.lastByteArray = byArray;
                this.lastByteBuffer = ByteBuffer.wrap(byArray);
            }
            return (ByteBuffer)this.lastByteBuffer.position(n).limit(n + n2);
        }

        public void write(int n) throws IOException {
            this.write(new byte[]{(byte)n}, 0, 1);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            ByteBuffer byteBuffer = this.getByteBuffer(byArray, n, n2);
            while (byteBuffer.hasRemaining()) {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "ChanOutputStream.write: (((((( nbytes= " + n3 + ", position= " + byteBuffer.position() + ", remaining= " + byteBuffer.remaining() + ", limit= " + byteBuffer.limit(), null);
                }
                n3 += this.sc.write(byteBuffer);
                if (!WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) continue;
                WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "ChanOutputStream.write: )))))) position= " + byteBuffer.position() + ", remaining= " + byteBuffer.remaining() + ", limit= " + byteBuffer.limit() + ", writen bytes=" + n3, null);
            }
            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "ChanOutputStream.write: expected to write " + n2 + " bytes, actually write " + n3 + "bytes", null);
            }
        }

        public void close() throws IOException {
            this.sc.close();
            super.close();
        }
    }

    public static class ChanInputStream
    extends InputStream {
        private final ReadableByteChannel sc;
        private ByteBuffer lastByteBuffer;
        private byte[] lastByteArray;
        private Selector selector;

        public ChanInputStream(ReadableByteChannel readableByteChannel) {
            this.sc = readableByteChannel;
            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "ReadableByteChannel created for " + readableByteChannel, null);
            }
        }

        private ByteBuffer getByteBuffer(byte[] byArray, int n, int n2) {
            if (byArray != this.lastByteArray) {
                this.lastByteArray = byArray;
                this.lastByteBuffer = ByteBuffer.wrap(byArray);
            }
            return (ByteBuffer)this.lastByteBuffer.position(n).limit(n + n2);
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            int n = this.read(byArray, 0, 1);
            return n == 1 ? byArray[0] : n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (n2 == 0) {
                return 0;
            }
            ByteBuffer byteBuffer = this.getByteBuffer(byArray, n, n2);
            int n3 = this.sc.read(byteBuffer);
            if (n3 == 0 && this.sc instanceof InputSSLIOChannelWrapper) {
                ReadableByteChannel readableByteChannel = ((InputSSLIOChannelWrapper)this.sc).getRawChannel();
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "The Channel type: " + this.sc.getClass().getCanonicalName(), null);
                }
                if (!((SocketChannel)readableByteChannel).isBlocking()) {
                    if (this.selector == null) {
                        this.selector = Selector.open();
                    }
                    ((SocketChannel)readableByteChannel).register(this.selector, 1);
                    boolean bl = false;
                    while (!bl && this.selector.select() > 0) {
                        Set<SelectionKey> set = this.selector.selectedKeys();
                        Iterator<SelectionKey> iterator = set.iterator();
                        while (iterator.hasNext() && !bl) {
                            SelectionKey selectionKey = iterator.next();
                            iterator.remove();
                            if (!selectionKey.isReadable() || (n3 = this.sc.read(byteBuffer)) == 0) continue;
                            bl = true;
                        }
                    }
                }
            }
            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "ReadableByteChannel.read: expected to read " + n2 + " bytes, actually read " + n3 + "bytes", null);
            }
            return n3;
        }

        public void close() throws IOException {
            this.sc.close();
            super.close();
            if (this.selector != null) {
                this.selector.close();
            }
        }
    }
}

