/*
 * Decompiled with CFR 0.152.
 */
package com.bea.sslplus;

import com.bea.sslplus.WeblogicHandler;
import com.ncipher.nfast.connect.NFConnection;
import com.ncipher.nfast.marshall.M_ByteBlock;
import com.ncipher.nfast.marshall.M_Cmd_Args_Sign;
import com.ncipher.nfast.marshall.M_Cmd_Reply_Sign;
import com.ncipher.nfast.marshall.M_Command;
import com.ncipher.nfast.marshall.M_Mech_Cipher_RSApPKCS1;
import com.ncipher.nfast.marshall.M_PlainText;
import com.ncipher.nfast.marshall.M_PlainTextType_Data;
import com.ncipher.nfast.marshall.M_PlainTextType_Data_Bytes;
import com.ncipher.nfast.marshall.M_Reply;
import com.ncipher.nfast.marshall.M_Status;
import com.ncipher.nfast.marshall.M_Tag;
import com.ncipher.provider.Utils;
import com.ncipher.provider.km.KMKey;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;

public class NCipherAPI {
    private NCipherAPI() {
    }

    public static byte[] rsaNCipherSignHandshakeMessageHashes(PrivateKey privateKey, byte[] byArray, byte[] byArray2, PublicKey publicKey) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        int n = (((RSAPublicKey)publicKey).getModulus().bitLength() + 7) / 8;
        if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
            WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Public key modulus size: " + n, null);
        }
        byte[] byArray4 = null;
        try {
            NFConnection nFConnection = Utils.getConnection();
            M_Command m_Command = new M_Command();
            m_Command.tag = new M_Tag(0L);
            m_Command.cmd = 55L;
            m_Command.args = new M_Cmd_Args_Sign(0L, ((KMKey)privateKey).getKeyID(), 2L, new M_PlainText(1L, (M_PlainTextType_Data)new M_PlainTextType_Data_Bytes(new M_ByteBlock(byArray3))));
            M_Reply m_Reply = nFConnection.transact(m_Command);
            if (m_Reply == null || m_Reply.reply == null || m_Reply.errorinfo != null || m_Reply.status != 0L) {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Failure processing Signature using nCipher", null);
                }
                if (m_Reply != null) {
                    if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                        WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Reply status from ncipher is: " + M_Status.toString((long)m_Reply.status), null);
                    }
                    if (m_Reply.errorinfo != null && WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                        WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Reply errorinfo from ncipher is: " + m_Reply.errorinfo, null);
                    }
                }
                throw new SignatureException();
            }
            M_Cmd_Reply_Sign m_Cmd_Reply_Sign = (M_Cmd_Reply_Sign)m_Reply.reply;
            if (m_Cmd_Reply_Sign.sig == null || m_Cmd_Reply_Sign.sig.data == null) {
                if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                    WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "No signature data was returned, but no errors seemed to be specified", null);
                }
                throw new SignatureException();
            }
            M_Mech_Cipher_RSApPKCS1 m_Mech_Cipher_RSApPKCS1 = (M_Mech_Cipher_RSApPKCS1)m_Cmd_Reply_Sign.sig.data;
            byArray4 = NCipherAPI.fixupBigIntegerPadding(m_Mech_Cipher_RSApPKCS1.m.value.toByteArray(), n);
        }
        catch (Exception exception) {
            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Exception during direct communication with nCipher: ", exception);
            }
            throw new SignatureException();
        }
        return byArray4;
    }

    private static byte[] fixupBigIntegerPadding(byte[] byArray, int n) {
        if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
            WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "modulusSize: " + n + "  value length: " + byArray.length, null);
        }
        if (byArray.length == n) {
            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "No padding adjustment needed", null);
            }
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        if (byArray.length > n) {
            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Need to trim off " + (byArray.length - n) + " extra bytes", null);
            }
            System.arraycopy(byArray, byArray.length - n, byArray2, 0, n);
        } else {
            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Need to add " + (n - byArray.length) + " padding bytes", null);
            }
            System.arraycopy(byArray, 0, byArray2, n - byArray.length, byArray.length);
        }
        return byArray2;
    }
}

