/*
 * Decompiled with CFR 0.152.
 */
package com.bea.sslplus;

import com.bea.sslplus.Channel2StreamUtil;
import com.bea.sslplus.WLS_SSLIOChannel;
import com.certicom.nio.InputSSLIOChannel;
import com.certicom.nio.OutputSSLIOChannel;
import com.certicom.tls.TLSConnection;
import com.certicom.tls.interfaceimpl.TLSConnectionImpl;
import com.certicom.tls.interfaceimpl.TLSSessionImpl;
import com.certicom.tls.interfaceimpl.TLSSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.impl.HandshakeListenerShunt;
import javax.net.ssl.impl.SSLSessionImpl;
import javax.net.ssl.impl.StringID;
import weblogic.security.SSL.WLSSSLNioSocket;

public final class SSLNioSocket
extends SSLSocket
implements WLSSSLNioSocket {
    private TLSSystem system;
    private Socket socket;
    private boolean autoClose;
    private TLSConnectionImpl connection = null;
    private WLS_SSLIOChannel ioChannel;
    private OutputStream outs;
    private InputStream ins;

    public SSLNioSocket(Socket socket, TLSSystem tLSSystem, String string, int n, boolean bl, boolean bl2) throws IOException {
        this.socket = socket;
        this.autoClose = bl;
        String string2 = socket.getInetAddress().getHostAddress() + ":" + socket.getPort();
        SocketChannel socketChannel = socket.getChannel();
        InputSSLIOChannel inputSSLIOChannel = new InputSSLIOChannel(socketChannel);
        OutputSSLIOChannel outputSSLIOChannel = new OutputSSLIOChannel(socketChannel);
        try {
            socket.setTcpNoDelay(true);
        }
        catch (SocketException socketException) {
            throw new ProtocolException(socketException.getMessage());
        }
        this.connection = bl2 ? (TLSConnectionImpl)tLSSystem.createServer((SSLSocket)this, inputSSLIOChannel, outputSSLIOChannel, (Serializable)new StringID(string2)) : (TLSConnectionImpl)tLSSystem.createClient((SSLSocket)this, inputSSLIOChannel, outputSSLIOChannel, (Serializable)new StringID(string2));
        this.ioChannel = new WLS_SSLIOChannel(this);
        this.ins = new Channel2StreamUtil.ChanInputStream(this.getReadableByteChannel());
        this.outs = new Channel2StreamUtil.ChanOutputStream(this.getWritableByteChannel());
    }

    public TLSConnection getConnection() {
        return this.connection;
    }

    public WLS_SSLIOChannel getSSLIOChannel() {
        return this.ioChannel;
    }

    public SocketChannel getChannel() {
        return this.socket.getChannel();
    }

    public SelectableChannel getSelectableChannel() {
        return this.socket.getChannel();
    }

    public ReadableByteChannel getReadableByteChannel() {
        return this.ioChannel.getReadableByteChannel();
    }

    public WritableByteChannel getWritableByteChannel() {
        return this.ioChannel.getWritableByteChannel();
    }

    public void setEnabledProtocols(String[] stringArray) {
        this.connection.setEnabledProtocols(stringArray);
    }

    public String[] getEnabledProtocols() {
        return this.connection.getEnabledProtocols();
    }

    public String[] getSupportedProtocols() {
        return this.connection.getSupportedProtocols();
    }

    public boolean getWantClientAuth() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".getWantClientAuth()");
    }

    public void setWantClientAuth(boolean bl) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".setWantClientAuth(boolean)");
    }

    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    public int getPort() {
        return this.socket.getPort();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
        this.socket.setTcpNoDelay(bl);
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.socket.getTcpNoDelay();
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
        this.socket.setSoLinger(bl, n);
    }

    public int getSoLinger() throws SocketException {
        return this.socket.getSoLinger();
    }

    public synchronized void setSoTimeout(int n) throws SocketException {
        this.socket.setSoTimeout(n);
    }

    public synchronized int getSoTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.connection.close();
        }
        finally {
            if (this.autoClose) {
                this.socket.close();
            }
            super.close();
        }
    }

    public String[] getSupportedCipherSuites() {
        SSLNioSocket sSLNioSocket = this;
        return sSLNioSocket.system.getSupportedCipherSuites();
    }

    public String[] getEnabledCipherSuites() {
        return this.connection.getEnabledCipherSuites();
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        this.connection.setEnabledCipherSuites(stringArray);
    }

    public SSLSession getSession() {
        return new SSLSessionImpl((TLSSessionImpl)this.connection.getSession());
    }

    public void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        HandshakeListenerShunt handshakeListenerShunt = new HandshakeListenerShunt(handshakeCompletedListener, this);
        this.connection.addHandshakeCompletedListener(handshakeListenerShunt);
    }

    public void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        HandshakeListenerShunt handshakeListenerShunt = new HandshakeListenerShunt(handshakeCompletedListener, this);
        this.connection.removeHandshakeCompletedListener(handshakeListenerShunt);
    }

    public void startHandshake() throws IOException {
        this.connection.completeHandshake();
    }

    public void setUseClientMode(boolean bl) {
        this.connection.setClient(bl);
    }

    public boolean getUseClientMode() {
        return this.connection.isClient();
    }

    public void setNeedClientAuth(boolean bl) {
        this.connection.setNeedClientAuth(bl);
    }

    public boolean getNeedClientAuth() {
        return this.connection.getNeedClientAuth();
    }

    public void setEnableSessionCreation(boolean bl) {
        this.connection.setEnableSessionCreation(bl);
    }

    public boolean getEnableSessionCreation() {
        return this.connection.getEnableSessionCreation();
    }

    public InputStream getInputStream() throws IOException {
        return this.ins;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.outs;
    }
}

