/*
 * Decompiled with CFR 0.152.
 */
package com.bea.sslplus;

import com.bea.sslplus.SSLNioSocket;
import com.certicom.tls.interfaceimpl.TLSSystem;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLSocketFactory;

public final class SSLNioSocketFactory
extends SSLSocketFactory {
    private TLSSystem system;
    private String[] defaultSuites;

    public SSLNioSocketFactory() {
        this.system = new TLSSystem();
        this.defaultSuites = this.system.getEnabledCipherSuites();
    }

    public SSLNioSocketFactory(TLSSystem tLSSystem) {
        this.system = tLSSystem;
        this.defaultSuites = tLSSystem.getEnabledCipherSuites();
    }

    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.configureBlocking(true);
        socketChannel.connect(new InetSocketAddress(string, n));
        return new SSLNioSocket(socketChannel.socket(), this.system, string, n, true, false);
    }

    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.configureBlocking(true);
        socketChannel.connect(new InetSocketAddress(inetAddress, n));
        return new SSLNioSocket(socketChannel.socket(), this.system, inetAddress.getHostName(), n, true, false);
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.configureBlocking(true);
        socketChannel.socket().bind(new InetSocketAddress(inetAddress, n2));
        socketChannel.connect(new InetSocketAddress(string, n));
        return new SSLNioSocket(socketChannel.socket(), this.system, string, n, true, false);
    }

    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.configureBlocking(true);
        socketChannel.socket().bind(new InetSocketAddress(inetAddress2, n2));
        socketChannel.connect(new InetSocketAddress(inetAddress.getHostAddress(), n));
        return new SSLNioSocket(socketChannel.socket(), this.system, inetAddress.getHostName(), n, true, false);
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException, UnknownHostException {
        if (socket.getChannel() == null) {
            throw new IllegalArgumentException("The Socket argument is not created by SocketChannel.open() :" + socket.toString());
        }
        socket.getChannel().configureBlocking(true);
        return new SSLNioSocket(socket, this.system, string, n, bl, false);
    }

    public String[] getDefaultCipherSuites() {
        return this.defaultSuites;
    }

    public String[] getSupportedCipherSuites() {
        SSLNioSocketFactory sSLNioSocketFactory = this;
        return sSLNioSocketFactory.system.getSupportedCipherSuites();
    }
}

