/*
 * Decompiled with CFR 0.152.
 */
package com.bea.sslplus;

import com.bea.sslplus.Channel2StreamUtil;
import com.certicom.io.InputSSLIO;
import com.certicom.io.OutputSSLIO;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.Signature;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import weblogic.kernel.Kernel;
import weblogic.kernel.KernelStatus;
import weblogic.security.utils.SSLIOContext;
import weblogic.security.utils.SSLIOContextTable;
import weblogic.security.utils.SSLSetup;

public final class WeblogicHandler {
    public static final String ALLOW_SMALL_RSA_EXPONENT_PROPERTY = "weblogic.security.SSL.allowSmallRSAExponent";
    public static final String SESSION_TTL_PROPERTY = "weblogic.security.SSL.sessionCache.ttl";
    public static final String NO_JCE_PROPERTY = "weblogic.security.SSL.nojce";
    public static final String DISABLE_EMPTY_SSL_RECORDS = "weblogic.security.SSL.DisableSSLEmptyRecords";
    public static final String NO_STRING_EXTENSIONS = "weblogic.security.SSL.noStringExtensions";
    public static final int UNKNOWN_PROTOCOL = -1;
    public static final int HTTP_PROTOCOL = 0;
    public static final int T3_PROTOCOL = 1;
    public static final int GIOP_PROTOCOL = 2;
    public static final int MAX_PROTOCOL_INDEX = 2;
    public static final int DEBUG_FATAL;
    public static final int DEBUG_ERROR;
    public static final int DEBUG_WARN;
    public static final int DEBUG_INFO;
    private static final String FAILURE_DETAILS;
    private static boolean debug;
    private static boolean debugEaten;
    private static boolean useJCEProvider;
    private static boolean disableEmptySSLRecords;
    private static ArrayList allowedPolicyIds;
    private static boolean allowSmallRSAExponent;
    private static final BigInteger THREE;
    private static boolean _noStringExtensions;
    private static final String NOT_SUPPORTED_MAC_PROVIDER = "SunPKCS11";
    private static final String[] NOT_SUPPORTED_MAC_PROVIDERS;
    private static final String NOT_SUPPORTED_CIPHER_PROVIDER = "SunPKCS11";
    private static final String[] NOT_SUPPORTED_CIPHER_PROVIDERS;
    private static final String[] NOT_SUPPORTED_KEYFACTORY_PROVIDERS;
    private static final String[] NOT_SUPPORTED_SIGNATURE_PROVIDERS;
    private static final String[] NOT_SUPPORTED_MESSAGEDIGEST_PROVIDERS;
    private static final String[] NOT_SUPPORTED_KEYPAIRGENERATOR_PROVIDERS;
    private static final String[] NOT_SUPPORTED_KEYAGREEMENT_PROVIDERS;
    private static boolean checkedLicense;
    private static int overrideSSLFragmentSize;

    public static void setFailureDetails(SSLSession sSLSession, String string) {
        sSLSession.putValue(FAILURE_DETAILS, string);
    }

    public static String getFailureDetails(SSLSession sSLSession) {
        return (String)sSLSession.getValue(FAILURE_DETAILS);
    }

    public static boolean isSupported(Mac mac) {
        String string = mac.getProvider().getName();
        return !WeblogicHandler.contains(NOT_SUPPORTED_MAC_PROVIDERS, string) && !string.startsWith("SunPKCS11");
    }

    public static boolean isSupportedCipher(String string) {
        return !WeblogicHandler.contains(NOT_SUPPORTED_CIPHER_PROVIDERS, string) && !string.startsWith("SunPKCS11");
    }

    public static boolean isSupported(KeyFactory keyFactory, String string) {
        String string2 = keyFactory.getProvider().getName();
        return !WeblogicHandler.contains(NOT_SUPPORTED_KEYFACTORY_PROVIDERS, string2) && (!string2.startsWith("SunRsaSign") || !string.equalsIgnoreCase("RSA"));
    }

    public static boolean isSupported(Signature signature) {
        String string = signature.getProvider().getName();
        return !WeblogicHandler.contains(NOT_SUPPORTED_SIGNATURE_PROVIDERS, string);
    }

    public static boolean isSupported(MessageDigest messageDigest) {
        String string = messageDigest.getProvider().getName();
        return !WeblogicHandler.contains(NOT_SUPPORTED_MESSAGEDIGEST_PROVIDERS, string);
    }

    public static boolean isSupported(KeyPairGenerator keyPairGenerator) {
        String string = keyPairGenerator.getProvider().getName();
        return !WeblogicHandler.contains(NOT_SUPPORTED_KEYPAIRGENERATOR_PROVIDERS, string);
    }

    public static boolean isSupported(KeyAgreement keyAgreement, String string) {
        String string2 = keyAgreement.getProvider().getName();
        return !string.equalsIgnoreCase("DH") && !string.equalsIgnoreCase("DiffieHellman") && !WeblogicHandler.contains(NOT_SUPPORTED_KEYAGREEMENT_PROVIDERS, string2);
    }

    private static boolean contains(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public static String matchPlainText(int n, int n2, int n3) {
        if (!((n != 71 && n != 103 || n2 != 69 && n2 != 101 || n3 != 84 && n3 != 116) && (n != 80 && n != 112 || n2 != 85 && n2 != 117 || n3 != 84 && n3 != 116))) {
            return "HTTP";
        }
        if (!(n != 71 && n != 103 || n2 != 73 && n2 != 105 || n3 != 79 && n3 != 111)) {
            return "GIOP";
        }
        if ((n == 116 || n == 84) && n2 == 51) {
            if (n3 == 117 && WeblogicHandler.isDebugEnabled(DEBUG_WARN)) {
                WeblogicHandler.debug(DEBUG_WARN, "Appears to be using an incompatable version of the T3 protocol", null);
            }
            return "T3";
        }
        return null;
    }

    public static int getOverrideSSLFragmentSize() {
        block9: {
            if (overrideSSLFragmentSize == 0) {
                overrideSSLFragmentSize = 4080;
                try {
                    int n;
                    String string = System.getProperty("weblogic.security.SSL.overrideFragmentSize");
                    if (string != null && (n = Integer.parseInt(string)) != -1) {
                        if (n < 512) {
                            n = 512;
                        } else if (n > 16384) {
                            n = 16384;
                        }
                        overrideSSLFragmentSize = n;
                    }
                }
                catch (SecurityException securityException) {
                    if (WeblogicHandler.isDebugEnabled(DEBUG_INFO)) {
                        WeblogicHandler.debug(DEBUG_INFO, "Ignoring security exception while initializing overrideSSLFragmentSize", securityException);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (!WeblogicHandler.isDebugEnabled(DEBUG_INFO)) break block9;
                    WeblogicHandler.debug(DEBUG_INFO, "Ignoring invalid value for system property weblogic.security.SSL.overrideFragmentSize", numberFormatException);
                }
            }
        }
        return overrideSSLFragmentSize;
    }

    public static boolean useJCEProvider() {
        return useJCEProvider;
    }

    public static boolean disableEmptySSLRecrods() {
        return disableEmptySSLRecords;
    }

    public static boolean isValidRSAPublicExponent(BigInteger bigInteger) {
        return allowSmallRSAExponent || !bigInteger.equals(THREE);
    }

    public static boolean noStringExtensions() {
        return _noStringExtensions;
    }

    public static String getErrorName(int n) {
        if (n == 0) {
            return "NONE";
        }
        String string = "";
        if ((n & 1) != 0) {
            string = string + " CERT_CHAIN_INVALID";
        }
        if ((n & 2) != 0) {
            string = string + " CERT_CHAIN_INVALID";
        }
        if ((n & 4) != 0) {
            string = string + " CERT_CHAIN_INCOMPLETE";
        }
        if ((n & 8) != 0) {
            string = string + " SIGNATURE_INVALID";
        }
        if ((n & 0x10) != 0) {
            string = string + " CERT_CHAIN_UNTRUSTED";
        }
        if ((n & 0x20) != 0) {
            string = string + " VALIDATION_FAILED";
        }
        return string;
    }

    public static SSLIOContext addSSLIOContext(InputStream inputStream, OutputStream outputStream, SSLSocket sSLSocket) throws IOException {
        SSLIOContext sSLIOContext = new SSLIOContext(inputStream, outputStream, sSLSocket);
        SSLIOContextTable.addContext(sSLIOContext);
        if (WeblogicHandler.isDebugEnabled(DEBUG_INFO)) {
            WeblogicHandler.debug(DEBUG_INFO, "SSLSocket will " + (SSLSetup.getIOModel() == 1 ? "" : "NOT") + " be Muxing", null);
        }
        return sSLIOContext;
    }

    public static SSLIOContext addSSLIOContext(InputSSLIO inputSSLIO, OutputSSLIO outputSSLIO, SSLSocket sSLSocket) throws IOException {
        Channel2StreamUtil.ChanInputStream chanInputStream = new Channel2StreamUtil.ChanInputStream(sSLSocket.getChannel());
        Channel2StreamUtil.ChanOutputStream chanOutputStream = new Channel2StreamUtil.ChanOutputStream(sSLSocket.getChannel());
        if (WeblogicHandler.isDebugEnabled(DEBUG_INFO)) {
            WeblogicHandler.debug(DEBUG_INFO, "Nio collection from client: " + sSLSocket.getInetAddress().getHostAddress(), null);
        }
        return WeblogicHandler.addSSLIOContext(chanInputStream, chanOutputStream, sSLSocket);
    }

    public static void removeSSLIOContext(SSLIOContext sSLIOContext) {
        SSLIOContextTable.removeContext(sSLIOContext);
    }

    public static void checkLicense() {
        if (!checkedLicense) {
            SSLSetup.getLicenseLevel();
            checkedLicense = true;
        }
    }

    public static boolean isDebugEnabled(int n) {
        return SSLSetup.isDebugEnabled(n);
    }

    public static void debug(int n, String string, Exception exception) {
        SSLSetup.debug(n, exception, string);
    }

    public static void debugEaten(Throwable throwable) {
        if (debugEaten) {
            SSLSetup.debug(DEBUG_INFO, throwable, "........... Eating Exception ..........");
        }
    }

    public static void logSSLUsingNullCipher() {
        SSLSetup.logSSLUsingNullCipher();
    }

    public static void loadAllowedCertIds() {
        String string;
        block5: {
            try {
                if (KernelStatus.isApplet()) {
                    return;
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                if (!Kernel.isApplet()) break block5;
                return;
            }
        }
        if ((string = System.getProperty("weblogic.security.SSL.allowedcertificatepolicyids")) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                allowedPolicyIds.add(stringTokenizer.nextToken());
            }
        }
    }

    public static boolean isPolicyAllowed(String string) {
        return allowedPolicyIds.contains(string);
    }

    static {
        debug = false;
        debugEaten = false;
        useJCEProvider = true;
        disableEmptySSLRecords = false;
        allowedPolicyIds = new ArrayList();
        allowSmallRSAExponent = false;
        THREE = BigInteger.valueOf(3L);
        _noStringExtensions = false;
        DEBUG_FATAL = 0;
        DEBUG_ERROR = 1;
        DEBUG_WARN = 2;
        DEBUG_INFO = 3;
        FAILURE_DETAILS = "weblogic.security.ssl.failureDetails";
        debugEaten = SSLSetup.getDebugEaten();
        WeblogicHandler.loadAllowedCertIds();
        try {
            useJCEProvider = !Boolean.getBoolean(NO_JCE_PROPERTY);
            disableEmptySSLRecords = Boolean.getBoolean(DISABLE_EMPTY_SSL_RECORDS);
            allowSmallRSAExponent = Boolean.getBoolean(ALLOW_SMALL_RSA_EXPONENT_PROPERTY);
            _noStringExtensions = Boolean.getBoolean(NO_STRING_EXTENSIONS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        NOT_SUPPORTED_MAC_PROVIDERS = new String[]{"SunJCE", "IAIK", "JsafeJCE", "nCipherKM", "ERACOM", "IBMJCE", "Entrust", "BC"};
        NOT_SUPPORTED_CIPHER_PROVIDERS = new String[]{"BC", "IBMJCE", "ERACOM", "Entrust", "IAIK"};
        NOT_SUPPORTED_KEYFACTORY_PROVIDERS = new String[]{"ERACOM", "Entrust"};
        NOT_SUPPORTED_SIGNATURE_PROVIDERS = new String[]{"BC", "IBMJCE", "IAIK"};
        NOT_SUPPORTED_MESSAGEDIGEST_PROVIDERS = new String[]{"BC", "IBMJCE"};
        NOT_SUPPORTED_KEYPAIRGENERATOR_PROVIDERS = new String[]{"IBMJCE"};
        NOT_SUPPORTED_KEYAGREEMENT_PROVIDERS = new String[]{"BC", "IBMJCE", "ERACOM", "Entrust"};
        checkedLicense = false;
        overrideSSLFragmentSize = 0;
    }
}

