/*
 * Decompiled with CFR 0.152.
 */
package com.bea.sslplus.extensions;

import com.bea.sslplus.extensions.CertificatePolicyImpl;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1SequenceOf;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import weblogic.security.CertificatePolicy;

public class CertificatePoliciesImpl
extends ASN1SequenceOf {
    public CertificatePoliciesImpl() {
        super(new CertificatePolicyImpl());
    }

    public CertificatePolicy[] getPolicies() {
        CertificatePolicy[] certificatePolicyArray = new CertificatePolicyImpl[this.size()];
        for (int i = 0; i < certificatePolicyArray.length; ++i) {
            certificatePolicyArray[i] = (CertificatePolicyImpl)this.getItem(i);
        }
        return certificatePolicyArray;
    }

    public static CertificatePolicy[] getPolicies(X509Certificate x509Certificate) throws CertificateParsingException {
        byte[] byArray = x509Certificate.getExtensionValue("2.5.29.32");
        if (byArray == null) {
            return null;
        }
        CertificatePoliciesImpl certificatePoliciesImpl = new CertificatePoliciesImpl();
        try {
            byte[] byArray2 = CertificatePoliciesImpl.stripDERPrefix(byArray);
            certificatePoliciesImpl.decode(byArray2);
            return certificatePoliciesImpl.getPolicies();
        }
        catch (ASN1ParsingException aSN1ParsingException) {
            CertificateParsingException certificateParsingException = new CertificateParsingException(aSN1ParsingException.getMessage());
            throw certificateParsingException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            CertificateParsingException certificateParsingException = new CertificateParsingException(illegalArgumentException.getMessage());
            throw certificateParsingException;
        }
    }

    private static byte[] stripDERPrefix(byte[] byArray) throws IllegalArgumentException {
        if (byArray.length < 2) {
            throw new IllegalArgumentException("Encoded bytes array length too short");
        }
        if (byArray[0] != 4) {
            throw new IllegalArgumentException("Encoded bytes first byte unexpected");
        }
        int n = 2;
        if (byArray[1] < 0 && byArray.length < (n += byArray[1] & 0x7F)) {
            throw new IllegalArgumentException("Encoded bytes unexpected format");
        }
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        return byArray2;
    }
}

