/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xml.registry;

import com.bea.xml.registry.uddi.ConnectionFactoryImpl;
import java.util.Collection;
import javax.xml.registry.FederatedConnection;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import weblogic.xml.jaxr.registry.AbstractConnectionFactory;
import weblogic.xml.jaxr.registry.provider.ProviderInfo;
import weblogic.xml.jaxr.registry.resource.JAXRMessages;

public class PluggableConnectionFactory
extends AbstractConnectionFactory {
    public static final String PROVIDER_SPECIFIC_FACTORY = "com.bea.xml.registry.connectionFactory";

    public FederatedConnection createFederatedConnection(Collection collection) throws JAXRException {
        return this.getRegistrySpecificConnectionFactory().createFederatedConnection(collection);
    }

    public ProviderInfo getProviderInfo() throws JAXRException {
        return this.getRegistrySpecificConnectionFactory().getProviderInfo();
    }

    private AbstractConnectionFactory getRegistrySpecificConnectionFactory() throws JAXRException {
        AbstractConnectionFactory abstractConnectionFactory;
        String string = this.getProperties().getProperty(PROVIDER_SPECIFIC_FACTORY);
        if (string == null) {
            string = System.getProperty(PROVIDER_SPECIFIC_FACTORY);
        }
        if (string == null) {
            abstractConnectionFactory = new ConnectionFactoryImpl();
        } else {
            try {
                Class<?> clazz = Class.forName(string);
                abstractConnectionFactory = (AbstractConnectionFactory)((Object)clazz.newInstance());
            }
            catch (ClassNotFoundException classNotFoundException) {
                String string2 = JAXRMessages.getMessage("jaxr.provider.connectionFactory.notFound", new Object[]{string});
                throw new InvalidRequestException(string2);
            }
            catch (ClassCastException classCastException) {
                String string3 = JAXRMessages.getMessage("jaxr.provider.connectionFactory.wrongType", new Object[]{string});
                throw new InvalidRequestException(string3);
            }
            catch (InstantiationException instantiationException) {
                String string4 = JAXRMessages.getMessage("jaxr.provider.connectionFactory.instantiationError", new Object[]{string});
                throw new InvalidRequestException(string4);
            }
            catch (IllegalAccessException illegalAccessException) {
                String string5 = JAXRMessages.getMessage("jaxr.provider.connectionFactory.instantiationError", new Object[]{string});
                throw new InvalidRequestException(string5);
            }
        }
        abstractConnectionFactory.setProperties(this.getProperties());
        return abstractConnectionFactory;
    }
}

