/*
 * Decompiled with CFR 0.152.
 */
package com.beasys.CORBA.pool.weblogic;

import com.beasys.CORBA.pool.ConnectionPool;
import com.beasys.CORBA.pool.ConnectionPoolImpl;
import com.beasys.CORBA.pool.ConnectionPoolManager;
import com.beasys.CORBA.pool.PooledConnectionImpl;
import com.beasys.CORBA.pool.SecurityContext;
import com.beasys.CORBA.pool.UserInfo;
import com.beasys.CORBA.pool.weblogic.ConnectionRuntimeMBeanImpl;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import weblogic.management.ManagementException;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.WLECConnectionPoolRuntimeMBean;
import weblogic.management.runtime.WLECConnectionRuntimeMBean;

public class ConnectionPoolRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements WLECConnectionPoolRuntimeMBean {
    private ConnectionPoolImpl s_pool;
    private ConnectionPoolManager s_mgr;
    private HashMap connBeans;
    private int connBeanCount = 0;

    public ConnectionPoolRuntimeMBeanImpl(ConnectionPool connectionPool, ConnectionPoolManager connectionPoolManager) throws ManagementException {
        super(connectionPool.getName());
        this.s_pool = (ConnectionPoolImpl)connectionPool;
        this.s_mgr = connectionPoolManager;
        this.initializeConnectionMBeans();
    }

    public String getPoolName() {
        return this.s_pool.getName();
    }

    public String getWLEDomainName() {
        return this.s_pool.getDomainId();
    }

    public int getMaxCapacity() {
        return this.s_pool.getMaxConn();
    }

    public String getPoolState() {
        if (this.s_pool.isSuspended()) {
            return "Suspended";
        }
        return "Active";
    }

    public boolean isSecurityContextPropagation() {
        return this.s_pool.propagateSecurityContext();
    }

    public boolean isCertificateBasedAuthentication() {
        return this.s_pool.getCertBasedAuth();
    }

    public synchronized WLECConnectionRuntimeMBean[] getConnections() {
        WLECConnectionRuntimeMBean[] wLECConnectionRuntimeMBeanArray = new WLECConnectionRuntimeMBean[this.connBeans.size()];
        Iterator iterator = this.connBeans.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            wLECConnectionRuntimeMBeanArray[n++] = (WLECConnectionRuntimeMBean)iterator.next();
        }
        return wLECConnectionRuntimeMBeanArray;
    }

    public synchronized int resetConnectionPool() {
        String[] stringArray = this.s_pool.getAppAddr();
        String[] stringArray2 = this.s_pool.getFailOverAddr();
        int n = this.s_pool.getMinConn();
        int n2 = this.s_pool.getMaxConn();
        boolean bl = this.s_pool.getCertBasedAuth();
        UserInfo userInfo = this.s_pool.getUser();
        String string = this.s_pool.getName();
        boolean bl2 = this.s_pool.propagateSecurityContext();
        SecurityContext securityContext = this.s_pool.getSecurityContextClass();
        String string2 = this.s_pool.getDomainId();
        this.s_pool.shutdown();
        ConnectionPool connectionPool = this.s_mgr.startPool(stringArray, stringArray2, n, n2, userInfo, string, string2, bl2, securityContext, bl);
        this.s_pool = (ConnectionPoolImpl)connectionPool;
        if (this.s_pool == null) {
            throw new NullPointerException();
        }
        this.initializeConnectionMBeans();
        return 0;
    }

    private void initializeConnectionMBeans() {
        Object object;
        if (this.connBeans == null) {
            this.connBeans = new HashMap();
        } else {
            object = this.connBeans.values().iterator();
            while (object.hasNext()) {
                try {
                    ((ConnectionRuntimeMBeanImpl)object.next()).unregister();
                }
                catch (ManagementException managementException) {
                    managementException.printStackTrace();
                }
            }
            this.connBeans.clear();
            this.connBeanCount = 0;
        }
        object = this.s_pool.getActiveConnections().elements();
        Enumeration enumeration = this.s_pool.getDeadConnections().elements();
        ConnectionRuntimeMBeanImpl connectionRuntimeMBeanImpl = null;
        while (object.hasMoreElements()) {
            ++this.connBeanCount;
            try {
                connectionRuntimeMBeanImpl = new ConnectionRuntimeMBeanImpl((PooledConnectionImpl)object.nextElement(), this, this.connBeanCount);
            }
            catch (ManagementException managementException) {
                managementException.printStackTrace();
            }
            this.connBeans.put(connectionRuntimeMBeanImpl.getName(), connectionRuntimeMBeanImpl);
        }
        while (enumeration.hasMoreElements()) {
            ++this.connBeanCount;
            try {
                connectionRuntimeMBeanImpl = new ConnectionRuntimeMBeanImpl((PooledConnectionImpl)enumeration.nextElement(), this, this.connBeanCount);
            }
            catch (ManagementException managementException) {
                managementException.printStackTrace();
            }
            this.connBeans.put(connectionRuntimeMBeanImpl.getName(), connectionRuntimeMBeanImpl);
        }
    }
}

