/*
 * Decompiled with CFR 0.152.
 */
package com.beasys.CORBA.pool.weblogic;

import com.beasys.CORBA.pool.PooledConnectionImpl;
import com.beasys.CORBA.pool.weblogic.ConnectionPoolRuntimeMBeanImpl;
import java.text.DateFormat;
import java.util.Date;
import weblogic.management.ManagementException;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.WLECConnectionRuntimeMBean;

public class ConnectionRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements WLECConnectionRuntimeMBean {
    private PooledConnectionImpl s_conn;

    public ConnectionRuntimeMBeanImpl(PooledConnectionImpl pooledConnectionImpl, ConnectionPoolRuntimeMBeanImpl connectionPoolRuntimeMBeanImpl, int n) throws ManagementException {
        super(String.valueOf(n), (RuntimeMBean)connectionPoolRuntimeMBeanImpl);
        this.s_conn = pooledConnectionImpl;
    }

    public String getAddress() {
        if (this.isValidConnection()) {
            return this.s_conn.getAddr();
        }
        return "";
    }

    public String getLastAccessTime() {
        if (this.isValidConnection()) {
            Date date = this.s_conn.getAccessTime();
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
            return date.getTime() == 0L ? "" : dateFormat.format(date);
        }
        return "";
    }

    public boolean isAlive() {
        if (this.isValidConnection()) {
            return this.s_conn.isAlive();
        }
        return false;
    }

    public int getRequestCount() {
        if (this.isValidConnection()) {
            int n = this.s_conn.getRequestsDone();
            if (n > 0) {
                n -= 2;
            }
            return n;
        }
        return 0;
    }

    public int getPendingRequestCount() {
        if (this.isValidConnection()) {
            return this.s_conn.getRequestsOutstanding();
        }
        return 0;
    }

    public int getErrorCount() {
        if (this.isValidConnection()) {
            return this.s_conn.getErrorCount();
        }
        return 0;
    }

    public boolean isInTransaction() {
        if (this.isValidConnection()) {
            return this.s_conn.inTransaction();
        }
        return false;
    }

    private boolean isValidConnection() {
        boolean bl = true;
        if (this.s_conn == null) {
            bl = false;
        } else {
            String string = this.s_conn.getAddr();
            if (string == null || string.equals("") || !this.s_conn.isAlive() && this.s_conn.getRestartCount() == 0) {
                bl = false;
            }
        }
        return bl;
    }
}

