/*
 * Decompiled with CFR 0.152.
 */
package com.beasys.CORBA.pool.weblogic;

import com.beasys.CORBA.pool.ConnectionPool;
import com.beasys.CORBA.pool.ConnectionPoolManager;
import com.beasys.CORBA.pool.ConnectionPoolManagerImpl;
import com.beasys.CORBA.pool.SecurityContext;
import com.beasys.CORBA.pool.ServerInfra;
import com.beasys.CORBA.pool.UserInfo;
import com.beasys.CORBA.pool.weblogic.ConnectionPoolRuntimeMBeanImpl;
import com.beasys.CORBA.pool.weblogic.SecurityContextImpl;
import com.beasys.CORBA.pool.weblogic.ServerInfraImpl;
import java.util.HashMap;
import java.util.Iterator;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.WLECConnectionPoolMBean;
import weblogic.management.runtime.WLECConnectionPoolRuntimeMBean;

public class PoolStartUp {
    private static ServerInfraImpl infra;
    private static HashMap connPools;
    private static int connPoolCount;

    public PoolStartUp() {
        connPools = new HashMap();
        connPoolCount = 0;
    }

    public String startup(DeploymentMBean deploymentMBean) throws Exception {
        ConnectionPool connectionPool;
        int n;
        int n2;
        String string;
        infra = new ServerInfraImpl();
        WLECConnectionPoolMBean wLECConnectionPoolMBean = null;
        if (!(deploymentMBean instanceof WLECConnectionPoolMBean)) {
            throw new Exception("Invalid Configuration MBean");
        }
        wLECConnectionPoolMBean = (WLECConnectionPoolMBean)deploymentMBean;
        ConnectionPoolManager connectionPoolManager = ConnectionPoolManager.mgr;
        if (connectionPoolManager == null) {
            ConnectionPoolManager.mgr = connectionPoolManager = new ConnectionPoolManagerImpl((ServerInfra)infra);
        }
        if (connectionPoolManager.get((Object)(string = wLECConnectionPoolMBean.getName())) != null) {
            throw new Exception("Duplicate pool name: " + string);
        }
        String string2 = wLECConnectionPoolMBean.getWLEDomain();
        if (string2 == null) {
            throw new Exception("Domain ID is not defined");
        }
        if (ConnectionPoolManager.getPoolForDomain((String)string2) != null) {
            throw new Exception("More than one pool for domain is not allowed. (" + string2 + ")");
        }
        String[] stringArray = wLECConnectionPoolMBean.getPrimaryAddresses();
        if (stringArray == null) {
            throw new Exception("Application Address List is not defined");
        }
        String[] stringArray2 = wLECConnectionPoolMBean.getFailoverAddresses();
        int n3 = wLECConnectionPoolMBean.getMinimumPoolSize();
        if (n3 <= 0) {
            n3 = 1;
        }
        if ((n2 = wLECConnectionPoolMBean.getMaximumPoolSize()) <= 0) {
            n2 = 1;
        }
        UserInfo userInfo = new UserInfo();
        userInfo.setUserName(this.checkNullString(wLECConnectionPoolMBean.getUserName()));
        userInfo.setUserPassword(this.checkNullString(wLECConnectionPoolMBean.getUserPassword()));
        userInfo.setUserRole(this.checkNullString(wLECConnectionPoolMBean.getUserRole()));
        userInfo.setAppPassword(this.checkNullString(wLECConnectionPoolMBean.getApplicationPassword()));
        boolean bl = wLECConnectionPoolMBean.isCertificateAuthenticationEnabled();
        int n4 = wLECConnectionPoolMBean.getMinimumEncryptionLevel();
        if (n4 != 0) {
            // empty if block
        }
        if ((n = wLECConnectionPoolMBean.getMaximumEncryptionLevel()) != 0) {
            // empty if block
        }
        boolean bl2 = wLECConnectionPoolMBean.isSecurityContextEnabled();
        SecurityContextImpl securityContextImpl = null;
        if (bl2) {
            securityContextImpl = new SecurityContextImpl();
        }
        if (connectionPoolManager.contains((Object)(connectionPool = connectionPoolManager.startPool(stringArray, stringArray2, n3, n2, userInfo, string, string2, bl2, (SecurityContext)securityContextImpl, bl)))) {
            ConnectionPoolRuntimeMBeanImpl connectionPoolRuntimeMBeanImpl = new ConnectionPoolRuntimeMBeanImpl(connectionPool, connectionPoolManager);
            connPools.put(connectionPoolRuntimeMBeanImpl.getName(), connectionPoolRuntimeMBeanImpl);
            ++connPoolCount;
        }
        return "IIOP Connection Pool: " + (string == null ? "Unnamed pool" : string) + " initialization finished";
    }

    public static void shutdown() {
        ConnectionPoolManager connectionPoolManager = ConnectionPoolManager.mgr;
        if (connectionPoolManager == null) {
            return;
        }
        infra.log_info("Starting to shutdown IIOP Connection pools");
        connectionPoolManager.shutdownAllPools();
        infra.log_info("IIOP Connection pools shutdown complete");
    }

    public synchronized WLECConnectionPoolRuntimeMBean[] getConnectionPools() {
        WLECConnectionPoolRuntimeMBean[] wLECConnectionPoolRuntimeMBeanArray = new WLECConnectionPoolRuntimeMBean[connPools.size()];
        Iterator iterator = connPools.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            wLECConnectionPoolRuntimeMBeanArray[n++] = (WLECConnectionPoolRuntimeMBean)iterator.next();
        }
        return wLECConnectionPoolRuntimeMBeanArray;
    }

    public int getConnectionPoolCount() {
        return connPoolCount;
    }

    private String checkNullString(String string) {
        return string == null ? "" : string;
    }
}

