/*
 * Decompiled with CFR 0.152.
 */
package com.beasys.CORBA.pool.weblogic;

import com.beasys.CORBA.pool.weblogic.PoolStartUp;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationFilter;
import weblogic.common.internal.LogOutputStream;
import weblogic.management.AttributeAddNotification;
import weblogic.management.AttributeRemoveNotification;
import weblogic.management.DeploymentException;
import weblogic.management.ManagementException;
import weblogic.management.UndeploymentException;
import weblogic.management.configuration.ConfigurationError;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.WLECConnectionPoolMBean;
import weblogic.management.internal.DeploymentHandler;
import weblogic.management.internal.DeploymentHandlerContext;
import weblogic.management.internal.DeploymentHandlerHome;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.WLECConnectionPoolRuntimeMBean;
import weblogic.management.runtime.WLECConnectionServiceRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.ServerService;
import weblogic.server.ServiceFailureException;

public class WLECService
extends RuntimeMBeanDelegate
implements ServerService,
WLECConnectionServiceRuntimeMBean,
DeploymentHandler {
    private static LogOutputStream log = new LogOutputStream("WLEC");
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
    private boolean initDone = false;
    private List connectionPoolMBeans = null;
    private int poolMBeans = 0;
    PoolStartUp cranker = null;

    public WLECService() throws ManagementException {
        super(runtimeAccess.getServerName() + ".wlec");
        runtimeAccess.getServerRuntime().setWLECConnectionServiceRuntime(this);
    }

    public void prepareDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws DeploymentException {
    }

    public void activateDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws DeploymentException {
        if (deploymentMBean instanceof WLECConnectionPoolMBean) {
            if (this.connectionPoolMBeans == null) {
                this.connectionPoolMBeans = new ArrayList();
            }
            this.connectionPoolMBeans.add(deploymentMBean);
            ++this.poolMBeans;
        }
    }

    public void deactivateDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws UndeploymentException {
        if (deploymentMBean instanceof WLECConnectionPoolMBean) {
            if (this.connectionPoolMBeans == null) {
                return;
            }
            this.connectionPoolMBeans.remove(deploymentMBean);
        }
    }

    public void unprepareDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws UndeploymentException {
    }

    void initialize() throws ServiceFailureException {
        if (this.initDone) {
            return;
        }
        DeploymentHandlerHome.addDeploymentHandler(this);
        this.initializeMBean();
        this.initDone = true;
    }

    private void initializeMBean() {
        if (this.poolMBeans != 0) {
            this.cranker = new PoolStartUp();
            this.createConnectionPool();
            this.initDone = true;
        }
    }

    public void stop() throws ServiceFailureException {
        this.halt();
    }

    public String getVersion() {
        return null;
    }

    public void start() throws ServiceFailureException {
        this.initialize();
        if (this.isEnabled()) {
            this.callPoolMethod("startup");
        }
    }

    public void halt() {
        if (this.isEnabled()) {
            this.callPoolMethod("shutdown");
        }
    }

    private final boolean isEnabled() {
        Map map = ManagementService.getRuntimeAccess(kernelId).getServer().getIIOPConnectionPools();
        return map != null && map.size() > 0;
    }

    private void callPoolMethod(String string) {
        Class[] classArray = new Class[]{};
        try {
            Class<?> clazz = null;
            ClassLoader classLoader = this.getClass().getClassLoader();
            String string2 = "com.beasys.CORBA.pool.weblogic.PoolStartUp";
            clazz = classLoader == null ? Class.forName(string2) : classLoader.loadClass(string2);
            Object[] objectArray = new Object[]{};
            Method method = null;
            method = clazz.getMethod(string, classArray);
            try {
                method.invoke(null, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getTargetException();
            }
        }
        catch (Throwable throwable) {
            log.error("Failed " + string + " on com.beasys.CORBA.pool.weblogic.PoolStartUp", throwable);
        }
    }

    private void createConnectionPool() {
        Iterator iterator = this.connectionPoolMBeans.iterator();
        while (iterator.hasNext()) {
            try {
                this.cranker.startup((DeploymentMBean)iterator.next());
            }
            catch (Exception exception) {
                throw new ConfigurationError("error starting connection pool", exception);
            }
        }
    }

    public WLECConnectionPoolRuntimeMBean[] getConnectionPools() {
        return this.cranker == null ? null : this.cranker.getConnectionPools();
    }

    public int getConnectionPoolCount() {
        return this.cranker == null ? 0 : this.cranker.getConnectionPoolCount();
    }

    static class WLECNotificationFilter
    implements NotificationFilter,
    Serializable {
        WLECNotificationFilter() {
        }

        public boolean isNotificationEnabled(Notification notification) {
            DeploymentMBean deploymentMBean;
            AttributeRemoveNotification attributeRemoveNotification;
            DeploymentMBean deploymentMBean2;
            AttributeAddNotification attributeAddNotification;
            return notification instanceof AttributeAddNotification ? "Deployments".equals((attributeAddNotification = (AttributeAddNotification)notification).getAttributeName()) && (deploymentMBean2 = (DeploymentMBean)attributeAddNotification.getAddedValue()) instanceof WLECConnectionPoolMBean : notification instanceof AttributeRemoveNotification && "Deployments".equals((attributeRemoveNotification = (AttributeRemoveNotification)notification).getAttributeName()) && (deploymentMBean = (DeploymentMBean)attributeRemoveNotification.getRemovedValue()) instanceof WLECConnectionPoolMBean;
        }
    }
}

