/*
 * Decompiled with CFR 0.152.
 */
package com.bluecast.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class XMLDefaultStream
extends InputStream {
    private InputStream stream;
    private InputStream current;
    private boolean bytesExhausted = false;

    public XMLDefaultStream(byte[] bytes, InputStream in) {
        this.stream = in;
        this.current = new ByteArrayInputStream(bytes);
    }

    public int read() throws IOException {
        this.ensureOpen();
        int len = this.current.read();
        if (len == -1 && !this.bytesExhausted) {
            this.bytesExhausted = true;
            this.current = this.stream;
            len = this.current.read();
        }
        return len;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        int count = this.current.read(b, off, len);
        if (count == -1 && !this.bytesExhausted) {
            this.bytesExhausted = true;
            this.current = this.stream;
            count = this.current.read(b, off, len);
        }
        return count;
    }

    public void close() throws IOException {
        this.stream.close();
        this.stream = null;
        this.current = null;
    }

    private void ensureOpen() throws IOException {
        if (this.current == null) {
            throw new IOException("Stream closed");
        }
    }
}

