/*
 * Decompiled with CFR 0.152.
 */
package com.bluecast.xml;

import com.bluecast.io.CharsetDecoder;
import java.io.CharConversionException;

public final class ByteXMLDecoder
implements CharsetDecoder {
    public CharsetDecoder newInstance() {
        return new ByteXMLDecoder();
    }

    public int minBytesPerChar() {
        return 1;
    }

    public int maxBytesPerChar() {
        return 1;
    }

    public void decode(byte[] in_buf, int in_off, int in_len, char[] out_buf, int out_off, int out_len, int[] result) throws CharConversionException {
        boolean sawCR = false;
        int o = 0;
        int i = 0;
        while (i < in_len && o < out_len) {
            char c = (char)(0xFF & in_buf[in_off + i]);
            switch (c) {
                case '\n': {
                    if (sawCR) {
                        sawCR = false;
                        break;
                    }
                    out_buf[out_off + o++] = 10;
                    break;
                }
                case '\r': {
                    sawCR = true;
                    out_buf[out_off + o++] = 10;
                    break;
                }
                case '\t': {
                    out_buf[out_off + o++] = 9;
                    break;
                }
                default: {
                    sawCR = false;
                    out_buf[out_off + o++] = c;
                }
            }
            ++i;
        }
        result[0] = i;
        result[1] = o;
    }
}

