/*
 * Decompiled with CFR 0.152.
 */
package com.bluecast.xml;

import com.bluecast.util.FactoryServiceFinder;
import com.bluecast.xml.Piccolo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class JAXPSAXParserFactory
extends SAXParserFactory {
    private Map featureMap = new HashMap();
    private static Boolean TRUE = new Boolean(true);
    private static Boolean FALSE = new Boolean(false);
    private Piccolo nvParser = new Piccolo();
    private SAXParserFactory validatingFactory;
    private static final String VALIDATING_PROPERTY = "com.bluecast.xml.ValidatingSAXParserFactory";
    private static Class validatingFactoryClass = JAXPSAXParserFactory.findValidatingFactory();
    private ParserConfigurationException pendingValidatingException = null;
    private ParserConfigurationException pendingNonvalidatingException = null;
    private boolean validating = false;
    private boolean namespaceAware = false;

    public JAXPSAXParserFactory() {
        try {
            if (validatingFactoryClass != null) {
                this.validatingFactory = (SAXParserFactory)validatingFactoryClass.newInstance();
                this.validatingFactory.setNamespaceAware(false);
                this.validatingFactory.setValidating(true);
            }
        }
        catch (InstantiationException e) {
            this.validatingFactory = null;
        }
        catch (IllegalAccessException e) {
            this.validatingFactory = null;
        }
        this.setNamespaceAware(false);
    }

    public boolean getFeature(String name) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        if (this.validating && this.validatingFactory != null) {
            return this.validatingFactory.getFeature(name);
        }
        return this.nvParser.getFeature(name);
    }

    public SAXParser newSAXParser() throws ParserConfigurationException, SAXException {
        if (this.validating) {
            if (this.validatingFactory == null) {
                throw new ParserConfigurationException("XML document validation is not supported");
            }
            if (this.pendingValidatingException != null) {
                throw this.pendingValidatingException;
            }
            return this.validatingFactory.newSAXParser();
        }
        if (this.pendingNonvalidatingException != null) {
            throw this.pendingNonvalidatingException;
        }
        return new JAXPSAXParser(new Piccolo(this.nvParser));
    }

    public void setFeature(String name, boolean enabled) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        this.featureMap.put(name, enabled ? TRUE : FALSE);
        if (this.validatingFactory != null) {
            if (this.pendingValidatingException != null) {
                this.reconfigureValidating();
            } else {
                try {
                    this.validatingFactory.setFeature(name, enabled);
                }
                catch (ParserConfigurationException e) {
                    this.pendingValidatingException = e;
                }
            }
        }
        if (this.pendingNonvalidatingException != null) {
            this.reconfigureNonvalidating();
        }
        if (this.validating && this.pendingValidatingException != null) {
            throw this.pendingValidatingException;
        }
        if (!this.validating && this.pendingNonvalidatingException != null) {
            throw this.pendingNonvalidatingException;
        }
    }

    public void setNamespaceAware(boolean awareness) {
        super.setNamespaceAware(awareness);
        this.namespaceAware = awareness;
        try {
            this.nvParser.setFeature("http://xml.org/sax/features/namespaces", awareness);
            this.nvParser.setFeature("http://xml.org/sax/features/namespace-prefixes", !awareness);
        }
        catch (SAXNotSupportedException e) {
            this.pendingNonvalidatingException = new ParserConfigurationException("Error setting namespace feature: " + e.toString());
        }
        catch (SAXNotRecognizedException e) {
            this.pendingNonvalidatingException = new ParserConfigurationException("Error setting namespace feature: " + e.toString());
        }
        if (this.validatingFactory != null) {
            this.validatingFactory.setNamespaceAware(awareness);
        }
    }

    public void setValidating(boolean value) {
        super.setValidating(value);
        this.validating = value;
    }

    private static Class findValidatingFactory() {
        try {
            String validatingClassName = System.getProperty(VALIDATING_PROPERTY);
            if (validatingClassName != null) {
                return Class.forName(validatingClassName);
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            String javah = System.getProperty("java.home");
            String configFile = javah + File.separator + "lib" + File.separator + "jaxp.properties";
            File f = new File(configFile);
            if (f.exists()) {
                Properties props = new Properties();
                props.load(new FileInputStream(f));
                String validatingClassName = props.getProperty(VALIDATING_PROPERTY);
                if (validatingClassName != null) {
                    return Class.forName(validatingClassName);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Enumeration enumeration = FactoryServiceFinder.findServices("javax.xml.parsers.SAXParserFactory");
            while (enumeration.hasMoreElements()) {
                try {
                    String factory = (String)enumeration.nextElement();
                    if (factory.equals("com.bluecast.xml.Piccolo")) continue;
                    return Class.forName(factory);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            return Class.forName("org.apache.crimson.jaxp.SAXParserFactoryImpl");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private void reconfigureValidating() {
        if (this.validatingFactory == null) {
            return;
        }
        try {
            Iterator iter = this.featureMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                this.validatingFactory.setFeature((String)entry.getKey(), (Boolean)entry.getValue());
            }
        }
        catch (ParserConfigurationException e) {
            this.pendingValidatingException = e;
        }
        catch (SAXNotRecognizedException e) {
            this.pendingValidatingException = new ParserConfigurationException(e.toString());
        }
        catch (SAXNotSupportedException e) {
            this.pendingValidatingException = new ParserConfigurationException(e.toString());
        }
    }

    private void reconfigureNonvalidating() {
        try {
            Iterator iter = this.featureMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                this.nvParser.setFeature((String)entry.getKey(), (Boolean)entry.getValue());
            }
        }
        catch (SAXNotRecognizedException e) {
            this.pendingNonvalidatingException = new ParserConfigurationException(e.toString());
        }
        catch (SAXNotSupportedException e) {
            this.pendingNonvalidatingException = new ParserConfigurationException(e.toString());
        }
    }

    static class JAXPSAXParser
    extends SAXParser {
        Piccolo parser;

        JAXPSAXParser(Piccolo parser2) {
            this.parser = parser2;
        }

        public Parser getParser() {
            return this.parser;
        }

        public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            return this.parser.getProperty(name);
        }

        public XMLReader getXMLReader() {
            return this.parser;
        }

        public boolean isNamespaceAware() {
            return this.parser.fNamespaces;
        }

        public boolean isValidating() {
            return false;
        }

        public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
            this.parser.setProperty(name, value);
        }
    }
}

