/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.io;

import com.certicom.io.OutputSSLIO;
import com.certicom.tls.interfaceimpl.TLSConnectionImpl;
import com.certicom.tls.record.WriteHandler;
import java.io.IOException;
import java.io.OutputStream;
import javax.net.ssl.SSLSocket;

public final class OutputSSLIOStreamWrapper
extends OutputStream {
    private OutputSSLIO out;
    private static final String osName = OutputSSLIOStreamWrapper.initOSNameProp();
    private static final boolean isLinux = "linux".equals(osName);
    private static final boolean isAix = "aix".equals(osName);

    private static String initOSNameProp() {
        String string = "UNKNOWN";
        try {
            string = System.getProperty("os.name", "UNKNOWN").toLowerCase();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return string;
    }

    public OutputSSLIOStreamWrapper(OutputSSLIO outputSSLIO) {
        this.out = outputSSLIO;
    }

    public void write(int n) throws IOException {
        this.write(new byte[]{(byte)n});
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this.out instanceof WriteHandler) {
                TLSConnectionImpl tLSConnectionImpl = ((WriteHandler)this.out).getConnection();
                tLSConnectionImpl.closeReadHandler();
                SSLSocket sSLSocket = tLSConnectionImpl.getSSLSocket();
                if (isLinux || isAix) {
                    try {
                        sSLSocket.shutdownInput();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        sSLSocket.shutdownOutput();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (!isAix) {
                    sSLSocket.close();
                }
            }
            this.out.close();
        }
        finally {
            super.close();
        }
    }
}

