/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.net.ssl;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.locale.Resources;
import com.certicom.net.ssl.HttpsURLConnection;
import com.certicom.net.ssl.HttpsURLTrustManager;
import com.certicom.net.ssl.SSLContext;
import com.certicom.net.ssl.internal.HttpClient;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.util.StringTokenizer;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public final class HttpsClient
extends HttpClient
implements HandshakeCompletedListener {
    private SSLContext context = null;
    protected SSLSession session = null;
    private SSLSocketFactory useFactory = null;

    public HttpsClient(URL uRL, SSLContext sSLContext, SSLSocketFactory sSLSocketFactory) throws IOException {
        super(uRL, null, -1, true);
        this.context = sSLContext;
        this.useFactory = sSLSocketFactory;
        super.openServer();
    }

    public HttpsClient(URL uRL, SSLContext sSLContext) throws IOException {
        super(uRL, null, -1, true);
        this.context = sSLContext;
        super.openServer();
    }

    protected int getDefaultPort() {
        return 443;
    }

    protected void setTrustManagerAndInfo(String string) {
        HttpsURLTrustManager httpsURLTrustManager;
        HttpsURLTrustManager httpsURLTrustManager2 = httpsURLTrustManager = new HttpsURLTrustManager();
        httpsURLTrustManager2.getClass();
        HttpsURLTrustManager.TrustManagerInfo trustManagerInfo = httpsURLTrustManager2.new HttpsURLTrustManager.TrustManagerInfo(string, HttpsURLConnection.getDefaultHostnameVerifier());
        this.context.setTrustManager(httpsURLTrustManager, trustManagerInfo);
    }

    protected Socket doConnect(String string, int n) throws IOException, UnknownHostException {
        StringTokenizer stringTokenizer;
        int n2;
        SSLSocketFactory sSLSocketFactory;
        SSLSocket sSLSocket = null;
        Socket socket = null;
        String string2 = System.getProperty("trustedfile");
        if (string2 != null) {
            try {
                this.context.loadTrustedCertificates(new FileInputStream(string2));
            }
            catch (KeyManagementException keyManagementException) {
                WeblogicHandler.debugEaten(keyManagementException);
                System.out.println(Resources.getMessage("139"));
            }
            catch (Exception exception) {
                WeblogicHandler.debugEaten(exception);
                throw new SSLException(Resources.getMessage("13") + string2);
            }
        }
        if ((sSLSocketFactory = this.useFactory) == null) {
            sSLSocketFactory = this.context.getSocketFactory();
        }
        String string3 = null;
        int n3 = 0;
        string3 = System.getProperty("https.proxyHost");
        n3 = Integer.getInteger("https.proxyPort", 0);
        if (string3 != null) {
            socket = new Socket(string3, n3);
            this.doProxyHandshake(socket, string3, n3, string, n);
            sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(socket, string, n, true);
        } else {
            sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(string, n);
        }
        sSLSocket.addHandshakeCompletedListener(this);
        String string4 = System.getProperty("https.cipherSuites");
        if (string4 != null && (n2 = (stringTokenizer = new StringTokenizer(string4, ",")).countTokens()) > 0) {
            String[] stringArray = new String[n2];
            for (int i = 0; i < n2; ++i) {
                stringArray[i] = stringTokenizer.nextToken();
            }
            sSLSocket.setEnabledCipherSuites(stringArray);
        }
        return sSLSocket;
    }

    public void doHandshake() throws IOException {
        this.serverSocket.getOutputStream().write(new byte[0], 0, 0);
    }

    private void doProxyHandshake(Socket socket, String string, int n, String string2, int n2) throws IOException {
        String string3;
        byte[] byArray;
        OutputStream outputStream = socket.getOutputStream();
        String string4 = "CONNECT " + string2 + ":" + n2 + " HTTP/1.0\n" + "User-Agent: " + HttpsURLConnection.userAgent + "\r\n\r\n";
        try {
            byArray = string4.getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            WeblogicHandler.debugEaten(unsupportedEncodingException);
            byArray = string4.getBytes();
        }
        outputStream.write(byArray);
        outputStream.flush();
        byte[] byArray2 = new byte[200];
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        InputStream inputStream = socket.getInputStream();
        boolean bl2 = false;
        while (n4 < 2) {
            int n5 = inputStream.read();
            if (n5 < 0) {
                throw new IOException(Resources.getMessage("136"));
            }
            if (n5 == 10) {
                bl = true;
                ++n4;
                continue;
            }
            if (n5 == 13) continue;
            n4 = 0;
            if (bl || n3 >= byArray2.length) continue;
            byArray2[n3++] = (byte)n5;
        }
        try {
            string3 = new String(byArray2, 0, n3, "ASCII7");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            WeblogicHandler.debugEaten(unsupportedEncodingException);
            string3 = new String(byArray2, 0, n3);
        }
        if (!string3.startsWith("HTTP/1.0 200") && !string3.startsWith("HTTP/1.1 200")) {
            throw new IOException(Resources.getMessage("125") + string + ":" + n + Resources.getMessage("101") + string3);
        }
    }

    public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
        this.session = handshakeCompletedEvent.getSession();
    }

    public SSLSession getSSLSession() {
        return this.session;
    }

    public SSLContext getSSLContext() {
        return this.context;
    }
}

