/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.net.ssl;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.locale.Resources;
import com.certicom.net.ssl.HostnameVerifier;
import com.certicom.net.ssl.HttpsClient;
import com.certicom.net.ssl.HttpsURLHostnameVerifier;
import com.certicom.net.ssl.SSLContext;
import com.certicom.net.ssl.internal.HttpClient;
import com.certicom.net.ssl.internal.HttpURLConnection;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.cert.Certificate;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.impl.SSLSessionImpl;

public class HttpsURLConnection
extends HttpURLConnection {
    protected static HostnameVerifier defaultHostnameVerifier = new HttpsURLHostnameVerifier();
    protected static SSLSocketFactory defaultSslSocketFactory = null;
    private SSLContext context = null;
    protected HostnameVerifier hostnameVerifier = null;
    protected SSLSocketFactory sslSocketFactory = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpsURLConnection(URL uRL) throws IOException {
        super(uRL, null);
        this.context = new SSLContext();
        this.context.setHelloProtocol("SSL3/2HI");
        this.context.setX509BasicConstraintBug(true);
        HttpsURLConnection httpsURLConnection = this;
        synchronized (httpsURLConnection) {
            this.hostnameVerifier = defaultHostnameVerifier;
            this.sslSocketFactory = defaultSslSocketFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpsURLConnection(URL uRL, SSLContext sSLContext) throws IOException {
        super(uRL, null);
        this.context = sSLContext;
        HttpsURLConnection httpsURLConnection = this;
        synchronized (httpsURLConnection) {
            this.hostnameVerifier = defaultHostnameVerifier;
            this.sslSocketFactory = defaultSslSocketFactory;
        }
    }

    protected HttpClient getNewClient(URL uRL) throws IOException {
        if (this.sslSocketFactory != null) {
            return new HttpsClient(uRL, this.context, this.sslSocketFactory);
        }
        if (defaultSslSocketFactory != null) {
            return new HttpsClient(uRL, this.context, defaultSslSocketFactory);
        }
        return new HttpsClient(uRL, this.context);
    }

    public void loadLocalIdentity(InputStream inputStream, char[] cArray) throws KeyManagementException {
        this.context.loadLocalIdentity(inputStream, cArray);
    }

    public void loadTrustedCertificate(String string) throws KeyManagementException, SSLException, IOException {
        try {
            this.loadTrustedCertificates(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            WeblogicHandler.debugEaten(fileNotFoundException);
            throw new SSLException(Resources.getMessage("42") + fileNotFoundException.getMessage());
        }
    }

    public void loadTrustedCertificates(InputStream inputStream) throws KeyManagementException {
        this.context.loadTrustedCertificates(inputStream);
    }

    public static synchronized void setDefaultHostnameVerifier(HostnameVerifier hostnameVerifier) {
        defaultHostnameVerifier = hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public static synchronized void setDefaultSSLSocketFactory(SSLSocketFactory sSLSocketFactory) {
        defaultSslSocketFactory = sSLSocketFactory;
    }

    public void setSSLSocketFactory(SSLSocketFactory sSLSocketFactory) {
        this.sslSocketFactory = sSLSocketFactory;
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        if (this.url.getProtocol().equalsIgnoreCase("https")) {
            if (this.http == null) {
                if (this.sslSocketFactory != null) {
                    this.http = new HttpsClient(this.url, this.context, this.sslSocketFactory);
                } else if (defaultSslSocketFactory != null) {
                    this.http = new HttpsClient(this.url, this.context, defaultSslSocketFactory);
                }
            }
            if (this.http == null) {
                this.http = new HttpsClient(this.url, this.context);
            }
            ((HttpsClient)this.http).setTrustManagerAndInfo(this.url.getHost());
            this.connected = true;
        } else {
            super.connect();
        }
    }

    public String getCipherSuite() {
        if (this.http instanceof HttpsClient) {
            HttpsClient httpsClient = (HttpsClient)this.http;
            if (httpsClient == null) {
                return null;
            }
            SSLSession sSLSession = httpsClient.getSSLSession();
            if (sSLSession == null) {
                return null;
            }
            return sSLSession.getCipherSuite();
        }
        return null;
    }

    public Certificate[] getServerCertificateChain() {
        HttpsClient httpsClient = (HttpsClient)this.http;
        if (httpsClient == null) {
            return null;
        }
        SSLSession sSLSession = httpsClient.getSSLSession();
        if (sSLSession == null) {
            return null;
        }
        try {
            return ((SSLSessionImpl)sSLSession).getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            WeblogicHandler.debugEaten(sSLPeerUnverifiedException);
            return null;
        }
    }

    public static synchronized HostnameVerifier getDefaultHostnameVerifier() {
        return defaultHostnameVerifier;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public static synchronized SSLSocketFactory getDefaultSSLSocketFactory() {
        return defaultSslSocketFactory;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }
}

