/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.net.ssl;

import com.certicom.net.ssl.HostnameVerifier;
import com.certicom.net.ssl.TrustManager;
import java.security.Principal;
import java.security.cert.X509Certificate;

final class HttpsURLTrustManager
implements TrustManager {
    HttpsURLTrustManager() {
    }

    public boolean certificateCallback(X509Certificate[] x509CertificateArray, int n, Object object) {
        TrustManagerInfo trustManagerInfo = (TrustManagerInfo)object;
        if (n != 0) {
            return false;
        }
        String string = this.getSubjectCN(x509CertificateArray[0].getSubjectDN());
        if (trustManagerInfo != null) {
            return trustManagerInfo.verifier.verify(trustManagerInfo.url, string);
        }
        return true;
    }

    private String getSubjectCN(Principal principal) {
        int n = principal.getName().indexOf("CN=");
        String string = principal.getName().substring(n + "CN=".length());
        return string;
    }

    public class TrustManagerInfo {
        public String url;
        public HostnameVerifier verifier;

        public TrustManagerInfo(String string, HostnameVerifier hostnameVerifier) {
            this.url = string;
            this.verifier = hostnameVerifier;
        }
    }
}

