/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.net.ssl;

import com.bea.sslplus.SSLNioSocketFactory;
import com.bea.sslplus.WeblogicHandler;
import com.certicom.net.ssl.SessionDB;
import com.certicom.net.ssl.TrustManager;
import com.certicom.net.ssl.impl.SessionDBWrapper;
import com.certicom.tls.interfaceimpl.CertificateSupport;
import com.certicom.tls.interfaceimpl.TLSSystem;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.impl.SSLServerSocketFactoryImpl;
import javax.net.ssl.impl.SSLSocketFactoryImpl;

public final class SSLContext {
    TLSSystem system;

    public CertificateSupport getCertificateSupport() {
        return this.system.getCertificateSupport();
    }

    public void setX509StrictConstraints(boolean bl) {
        TLSSystem.setX509StrictConstraints(bl);
    }

    public SSLContext() {
        WeblogicHandler.checkLicense();
        this.system = new TLSSystem();
    }

    public static SSLContext getInstance(String string) {
        SSLContext sSLContext = new SSLContext();
        sSLContext.setHelloProtocol(string);
        return sSLContext;
    }

    public void setHelloProtocol(String string) throws IllegalArgumentException {
        this.system.setHelloProtocol(string);
    }

    public void setTrustManager(TrustManager trustManager) {
        this.system.getCertificateSupport().setTrustManager(trustManager);
    }

    public void setTrustManager(TrustManager trustManager, Object object) {
        this.system.getCertificateSupport().setTrustManager(trustManager);
        this.system.getCertificateSupport().setCertificateCallbackRef(object);
    }

    public void disableDefaultTrustedCertificates() {
        this.system.getCertificateSupport().disableDefaultTrustedCertificates();
    }

    public void addRSAExportKey(KeyPair keyPair) throws InvalidKeyException, NoSuchAlgorithmException {
        this.system.getCertificateSupport().addRSAExportKey(keyPair);
        this.system.resetCipherSuiteSupport();
    }

    public KeyPair generateRSAExportKey(int n, SecureRandom secureRandom) throws NoSuchAlgorithmException {
        return this.system.getCertificateSupport().generateRSAExportKey(n, secureRandom);
    }

    public void addAuthChain(X509Certificate[] x509CertificateArray, byte[] byArray) {
        this.system.getCertificateSupport().addAuthChain(x509CertificateArray, byArray);
    }

    public void addAuthChain(X509Certificate[] x509CertificateArray, PrivateKey privateKey) {
        this.system.getCertificateSupport().addAuthChain(x509CertificateArray, privateKey);
        this.system.resetCipherSuiteSupport();
    }

    public void removeAuthChain(X509Certificate x509Certificate) {
        this.system.getCertificateSupport().removeAuthChain(x509Certificate);
        this.system.resetCipherSuiteSupport();
    }

    public void addTrustedCertificate(X509Certificate x509Certificate) throws CertificateException {
        this.system.getCertificateSupport().addTrustedCertificate(x509Certificate);
    }

    public final void loadLocalIdentity(InputStream inputStream, char[] cArray) throws KeyManagementException {
        this.system.getCertificateSupport().loadLocalIdentity(inputStream, cArray);
        this.system.resetCipherSuiteSupport();
    }

    public final void loadTrustedCertificates(InputStream inputStream) throws KeyManagementException {
        this.system.getCertificateSupport().loadTrustedCertificates(inputStream);
    }

    public void setRNG(SecureRandom secureRandom) {
        TLSSystem.setRandomNumberGenerator(secureRandom);
    }

    public void setSessionDB(SessionDB sessionDB) {
        this.system.setSessionDB(new SessionDBWrapper(sessionDB));
    }

    public void setIsExportedLimited(boolean bl) {
        this.system.setIsExportedLimited(bl);
    }

    public void setIsStrongCipherSuiteLimited(boolean bl) {
        this.system.setIsStrongCipherSuiteLimited(bl);
    }

    public void setServerGatedCryptoEnabled(boolean bl) {
        this.system.setServerGatedCryptoEnabled(bl);
    }

    public String getHelloProtocol() {
        return this.system.getHelloProtocol();
    }

    public X509Certificate[] getAuthChain(String string, int n) {
        return this.system.getCertificateSupport().getAuthChain(string, n);
    }

    public final SSLSocketFactory getSocketFactory() {
        return new SSLSocketFactoryImpl(this.system);
    }

    public final SSLServerSocketFactory getServerSocketFactory() {
        return new SSLServerSocketFactoryImpl(this.system);
    }

    public final SSLServerSocketFactory getNioServerSocketFactory() {
        return new SSLServerSocketFactoryImpl(this.system, true);
    }

    public final SSLSocketFactory getNioSocketFactory() {
        return new SSLNioSocketFactory(this.system);
    }

    public void setX509BasicConstraintBug(boolean bl) {
        TLSSystem.setX509BasicConstraintBug(bl);
    }

    public boolean getX509BasicConstraintBug() {
        return TLSSystem.getX509BasicConstraintBug();
    }

    public void setHandshakeRollBackBug(boolean bl) {
        TLSSystem.setHandshakeRollBackBug(bl);
    }

    public boolean getHandshakeRollBackBug() {
        return TLSSystem.getHandshakeRollBackBug();
    }

    public String getLibVersion() {
        String string = "V4.0.2";
        return string;
    }

    public void setDebugFlag() {
        this.system.setDebugFlag();
    }

    public void setWriteFragmentLength(int n) {
        this.system.setWriteFragmentLength(n);
    }

    public void resetEnabledCipherSuites(String[] stringArray) {
        this.system.setEnabledCipherSuites(stringArray);
    }

    public void installMobileTrustCertificates() {
        this.system.getCertificateSupport().installDefaultTrustedCertificates();
    }

    public void setAcceptEmptyCertRequest(boolean bl) {
        TLSSystem.setAcceptEmptyCertRequest(bl);
    }

    public boolean getAcceptEmptyCertRequest() {
        return TLSSystem.getAcceptEmptyCertRequest();
    }

    public void setSendEmptyCertRequest(boolean bl) {
        TLSSystem.setSendEmptyCertRequest(bl);
    }

    public boolean getSendEmptyCertRequest() {
        return TLSSystem.getSendEmptyCertRequest();
    }
}

