/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.net.ssl.internal;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.locale.Resources;
import com.certicom.net.ssl.internal.HeaderParser;
import com.certicom.net.ssl.internal.KeepAliveCache;
import com.certicom.net.ssl.internal.KeepAliveStream;
import com.certicom.net.ssl.internal.MessageHeader;
import com.certicom.net.ssl.internal.MeteredStream;
import com.certicom.net.ssl.internal.NetworkClient;
import com.certicom.net.ssl.internal.ProgressData;
import com.certicom.net.ssl.internal.ProgressEntry;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;

public class HttpClient
extends NetworkClient {
    private String instProxy = null;
    private int instProxyPort = -1;
    MessageHeader requests;
    boolean failedOnce = false;
    public boolean usingProxy = false;
    protected boolean proxyDisabled;
    protected URL url;
    private String host;
    private int port;
    static final int httpPortNumber = 80;
    protected static final KeepAliveCache kac = new KeepAliveCache();
    KeepAliveStream kas;
    boolean keepingAlive = false;
    int keepAliveConnections = -1;
    int keepAliveTimeout = 0;

    protected int getDefaultPort() {
        return 80;
    }

    public boolean getHttpKeepAliveSet() {
        return false;
    }

    public String getURLFile() {
        String string = this.url.getFile();
        if (string == null || string.equals("")) {
            string = "/";
        }
        if (this.usingProxy) {
            String string2 = this.url.getProtocol() + "://" + this.url.getHost();
            if (this.url.getPort() != -1) {
                string2 = string2 + ":" + this.url.getPort();
            }
            return string2 + string;
        }
        return string;
    }

    public HttpClient(URL uRL, String string, int n, boolean bl) throws IOException {
        this.proxyDisabled = bl;
        if (!bl) {
            this.instProxy = string;
            this.instProxyPort = n < 0 ? this.getDefaultPort() : n;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(uRL.getHost());
            this.host = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            WeblogicHandler.debugEaten(unknownHostException);
            this.host = uRL.getHost();
        }
        this.url = uRL;
        this.port = uRL.getPort();
        if (this.port == -1) {
            this.port = this.getDefaultPort();
        }
    }

    public void openServer(String string, int n) throws IOException {
        this.serverSocket = this.doConnect(string, n);
        this.serverOutput = new PrintStream(new BufferedOutputStream(this.serverSocket.getOutputStream()));
        this.serverSocket.setTcpNoDelay(true);
    }

    public synchronized void openServer() throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(this.host, this.port);
        }
        if (this.url.getProtocol().equals("http")) {
            this.openServer(this.host, this.port);
            this.usingProxy = false;
            return;
        }
        super.openServer(this.host, this.port);
        this.usingProxy = false;
    }

    public static HttpClient New(URL uRL) throws IOException {
        HttpClient httpClient = null;
        httpClient = new HttpClient(uRL, null, -1, true);
        httpClient.openServer();
        return httpClient;
    }

    public boolean parseHTTP(MessageHeader messageHeader, ProgressEntry progressEntry) throws IOException {
        int n;
        this.keepAliveConnections = -1;
        this.keepAliveTimeout = 0;
        boolean bl = false;
        byte[] byArray = new byte[7];
        try {
            int n2;
            this.serverInput = this.serverSocket.getInputStream();
            this.serverInput = new BufferedInputStream(this.serverInput);
            this.serverInput = new PushbackInputStream(this.serverInput, 7);
            for (n = 0; n < 7 && (n2 = this.serverInput.read(byArray, n, 7 - n)) >= 0; n += n2) {
            }
            String string = null;
            bl = byArray[0] == 72 && byArray[1] == 84 && byArray[2] == 84 && byArray[3] == 80 && byArray[4] == 47 && byArray[5] == 49 && byArray[6] == 46;
            ((PushbackInputStream)this.serverInput).unread(byArray);
            if (bl) {
                messageHeader.parseHeader(this.serverInput);
                string = this.usingProxy ? messageHeader.findValue("Proxy-Connection") : messageHeader.findValue("Connection");
                if (string != null && string.toLowerCase().equals("keep-alive")) {
                    HeaderParser headerParser = new HeaderParser(messageHeader.findValue("Keep-Alive"));
                    this.keepAliveConnections = headerParser.findInt("max", 5);
                    this.keepAliveTimeout = headerParser.findInt("timeout", 5);
                }
            } else {
                if (n != 7) {
                    if (!this.failedOnce && this.requests != null) {
                        this.failedOnce = true;
                        this.closeServer();
                        this.openServer();
                        this.writeRequests(this.requests);
                        return this.parseHTTP(messageHeader, progressEntry);
                    }
                    throw new SocketException(Resources.getMessage("176"));
                }
                messageHeader.set("Content-type", "unknown/unknown");
            }
        }
        catch (IOException iOException) {
            WeblogicHandler.debugEaten(iOException);
            this.closeServer();
            if (!this.failedOnce && this.requests != null) {
                this.failedOnce = true;
                this.openServer();
                this.writeRequests(this.requests);
                return this.parseHTTP(messageHeader, progressEntry);
            }
            throw iOException;
        }
        n = -1;
        try {
            n = Integer.parseInt(messageHeader.findValue("content-length"));
        }
        catch (Exception exception) {
            WeblogicHandler.debugEaten(exception);
        }
        if (this.keepAliveConnections > 1 && n > 0) {
            this.keepingAlive = true;
        } else if (this.keepingAlive) {
            this.keepingAlive = false;
        }
        if (n > 0) {
            progressEntry.setType(this.url.getFile(), messageHeader.findValue("content-type"));
            progressEntry.update(0, n);
            if (this.keepingAlive) {
                this.kas = new KeepAliveStream(this.serverInput, progressEntry, this);
                this.serverInput = this.kas;
                this.failedOnce = false;
            } else {
                this.serverInput = new MeteredStream(this.serverInput, progressEntry);
            }
        } else {
            ProgressData.pdata.unregister(progressEntry);
        }
        return bl;
    }

    public synchronized InputStream getInputStream() {
        return this.serverInput;
    }

    public OutputStream getOutputStream() {
        return this.serverOutput;
    }

    public void closeServer() {
        try {
            this.serverSocket.close();
        }
        catch (Exception exception) {
            WeblogicHandler.debugEaten(exception);
        }
    }

    public void writeRequests(MessageHeader messageHeader) {
        this.requests = messageHeader;
        this.requests.print(this.serverOutput);
        this.serverOutput.flush();
    }

    public static void finished(HttpClient httpClient) {
        --httpClient.keepAliveConnections;
        if (httpClient.keepAliveConnections > 0 && httpClient.keepingAlive && !httpClient.serverOutput.checkError()) {
            kac.put(httpClient.url, httpClient);
        } else {
            httpClient.closeServer();
        }
    }

    public String getProxyHostUsed() {
        if (!this.usingProxy) {
            return null;
        }
        return this.instProxy;
    }

    public int getProxyPortUsed() {
        return this.instProxyPort;
    }
}

