/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.net.ssl.internal;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.locale.Resources;
import com.certicom.net.ssl.HttpsClient;
import com.certicom.net.ssl.https.Handler;
import com.certicom.net.ssl.internal.AuthenticationInfo;
import com.certicom.net.ssl.internal.BasicAuthentication;
import com.certicom.net.ssl.internal.DigestAuthentication;
import com.certicom.net.ssl.internal.EmptyInputStream;
import com.certicom.net.ssl.internal.GetPropertyAction;
import com.certicom.net.ssl.internal.HeaderParser;
import com.certicom.net.ssl.internal.HttpAuthenticator;
import com.certicom.net.ssl.internal.HttpClient;
import com.certicom.net.ssl.internal.MessageHeader;
import com.certicom.net.ssl.internal.ProgressData;
import com.certicom.net.ssl.internal.ProgressEntry;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class HttpURLConnection
extends java.net.HttpURLConnection {
    static final String version = (String)AccessController.doPrivileged(new GetPropertyAction("java.version"));
    public static final String userAgent = (String)AccessController.doPrivileged(new GetPropertyAction("http.agent", "Java" + version));
    static final String httpVersion = "HTTP/1.0";
    static final String acceptString = "text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2";
    private static HttpAuthenticator defaultAuth;
    static final int maxRedirects = 5;
    private boolean shouldFollowRedirects = true;
    protected HttpClient http;
    protected Handler handler;
    private ByteArrayOutputStream poster = null;
    private boolean setRequests = false;
    private InputStream inputStream = null;
    protected ProgressEntry pe;
    private MessageHeader requests = new MessageHeader();
    private MessageHeader responses = new MessageHeader();
    private boolean failedOnce = false;
    protected PrintStream ps = null;

    private static PasswordAuthentication privilegedRequestPasswordAuthentication(final InetAddress inetAddress, final int n, final String string, final String string2, final String string3) {
        return (PasswordAuthentication)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Authenticator.requestPasswordAuthentication(inetAddress, n, string, string2, string3);
            }
        });
    }

    protected HttpURLConnection(URL uRL, Handler handler) throws IOException {
        super(uRL);
        this.handler = handler;
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        if ("http".equals(this.url.getProtocol()) && !this.failedOnce) {
            this.http = HttpClient.New(this.url);
        } else {
            this.http = new HttpClient(this.url, null, -1, true);
            this.http.openServer();
        }
        this.ps = (PrintStream)this.http.getOutputStream();
        this.connected = true;
    }

    public void disconnect() {
        this.responseCode = -1;
        if (this.http != null) {
            this.http.closeServer();
            this.http = null;
            this.connected = false;
        }
    }

    public boolean usingProxy() {
        if (this.http != null) {
            return this.http.usingProxy;
        }
        return false;
    }

    protected HttpClient getNewClient(URL uRL) throws IOException {
        HttpClient httpClient = new HttpClient(uRL, null, -1, true);
        httpClient.openServer();
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRequests() throws IOException {
        if (!this.setRequests) {
            Object object;
            Object object2;
            long l;
            AuthenticationInfo authenticationInfo;
            this.requests.prepend(this.method + " " + this.http.getURLFile() + " " + httpVersion, null);
            this.requests.setIfNotSet("User-Agent", userAgent);
            int n = this.url.getPort();
            String string = this.url.getHost();
            if (n != -1 && n != 80) {
                string = string + ":" + String.valueOf(n);
            }
            this.requests.setIfNotSet("Host", string);
            this.requests.setIfNotSet("Accept", acceptString);
            if (!this.failedOnce && this.http.getHttpKeepAliveSet()) {
                if (this.http.usingProxy && !this.method.equals("POST") && !this.method.equals("PUT")) {
                    this.requests.set("Proxy-Connection", "keep-alive");
                } else if (!this.http.usingProxy) {
                    this.requests.set("Connection", "keep-alive");
                }
            }
            if (this.http.usingProxy && (authenticationInfo = AuthenticationInfo.getProxyAuth(this.http.getProxyHostUsed(), this.http.getProxyPortUsed())) != null && authenticationInfo.supportsPreemptiveAuthorization()) {
                this.requests.setIfNotSet(authenticationInfo.getHeaderName(), authenticationInfo.getHeaderValue());
            }
            if ((l = this.getIfModifiedSince()) != 0L) {
                object2 = new Date(l);
                object = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'");
                ((DateFormat)object).setTimeZone(TimeZone.getTimeZone("GMT"));
                this.requests.setIfNotSet("If-Modified-Since", ((DateFormat)object).format((Date)object2));
            }
            if ((object2 = AuthenticationInfo.getServerAuth(this.url)) != null && ((AuthenticationInfo)object2).supportsPreemptiveAuthorization()) {
                this.requests.setIfNotSet(((AuthenticationInfo)object2).getHeaderName(), ((AuthenticationInfo)object2).getHeaderValue());
            }
            if (this.poster != null) {
                object = this.poster;
                synchronized (object) {
                    if (!this.method.equals("PUT")) {
                        String string2 = "application/x-www-form-urlencoded";
                        this.requests.setIfNotSet("Content-type", string2);
                    }
                    this.requests.set("Content-length", String.valueOf(this.poster.size()));
                }
            }
            this.setRequests = true;
        }
        this.http.writeRequests(this.requests);
        if (this.poster != null) {
            this.poster.writeTo(System.out);
            this.poster.writeTo(this.ps);
            this.ps.flush();
        }
        if (this.ps.checkError()) {
            this.disconnect();
            if (this.failedOnce) {
                throw new IOException(Resources.getMessage("172"));
            }
            this.failedOnce = true;
            this.http = this.getNewClient(this.url);
            this.ps = (PrintStream)this.http.getOutputStream();
            this.connected = true;
            this.responses = new MessageHeader();
            this.requests = new MessageHeader();
            this.setRequests = false;
            this.writeRequests();
        }
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        try {
            if (!this.doOutput) {
                throw new ProtocolException(Resources.getMessage("190"));
            }
            if (this.method.equals("GET")) {
                this.setRequestMethod("POST");
            }
            if (!"POST".equals(this.method) && !"PUT".equals(this.method) && "https".equals(this.url.getProtocol())) {
                throw new ProtocolException(this.method + Resources.getMessage("191"));
            }
            if (this.inputStream != null) {
                throw new ProtocolException(Resources.getMessage("192"));
            }
            this.connect();
            this.ps = (PrintStream)this.http.getOutputStream();
            if (this.poster == null) {
                this.poster = new ByteArrayOutputStream();
            }
            return this.poster;
        }
        catch (RuntimeException runtimeException) {
            WeblogicHandler.debugEaten(runtimeException);
            this.disconnect();
            throw runtimeException;
        }
        catch (IOException iOException) {
            WeblogicHandler.debugEaten(iOException);
            this.disconnect();
            throw iOException;
        }
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new ProtocolException(Resources.getMessage("169"));
        }
        if (this.inputStream != null) {
            return this.inputStream;
        }
        int n = 0;
        AuthenticationInfo authenticationInfo = null;
        AuthenticationInfo authenticationInfo2 = null;
        try {
            do {
                this.pe = new ProgressEntry(this.url.getFile(), null);
                ProgressData.pdata.register(this.pe);
                this.connect();
                if (this.http instanceof HttpsClient) {
                    ((HttpsClient)this.http).doHandshake();
                }
                this.ps = (PrintStream)this.http.getOutputStream();
                this.writeRequests();
                this.http.parseHTTP(this.responses, this.pe);
                this.inputStream = this.http.getInputStream();
                int n2 = this.getResponseCode();
                if (n2 == 407) {
                    if (authenticationInfo2 != null) {
                        authenticationInfo2.removeFromCache();
                    }
                    if ((authenticationInfo2 = this.getHttpProxyAuthentication()) != null) {
                        this.disconnect();
                        ++n;
                        continue;
                    }
                }
                if (n2 == 401) {
                    if (authenticationInfo != null) {
                        authenticationInfo.removeFromCache();
                    }
                    if ((authenticationInfo = this.getServerAuthentication()) != null) {
                        this.disconnect();
                        ++n;
                        continue;
                    }
                }
                if (n2 == 200 || n2 >= 300 && n2 <= 305) {
                    if (authenticationInfo2 != null) {
                        authenticationInfo2.addToCache();
                    }
                    if (authenticationInfo != null) {
                        authenticationInfo.addToCache();
                    }
                }
                if (this.followRedirect()) {
                    ++n;
                    continue;
                }
                if (this.method.equals("HEAD") || this.method.equals("TRACE")) {
                    this.disconnect();
                    this.inputStream = new EmptyInputStream();
                    return this.inputStream;
                }
                String string = this.url.getFile();
                if (!(n2 < 400 || string == null || string.endsWith(".html") || string.endsWith(".htm") || string.endsWith("/") || string.endsWith(".txt"))) {
                    throw new FileNotFoundException(this.url.toString());
                }
                return this.inputStream;
            } while (n < 5);
            throw new ProtocolException(Resources.getMessage("170") + " (" + n + ")");
        }
        catch (RuntimeException runtimeException) {
            this.disconnect();
            throw runtimeException;
        }
        catch (IOException iOException) {
            this.disconnect();
            throw iOException;
        }
    }

    private AuthenticationInfo getHttpProxyAuthentication() {
        AuthenticationInfo authenticationInfo = null;
        String string = this.getHeaderField("Proxy-authenticate");
        String string2 = this.http.getProxyHostUsed();
        int n = this.http.getProxyPortUsed();
        if (string2 != null && string != null) {
            Object object;
            Serializable serializable;
            HeaderParser headerParser = new HeaderParser(string);
            String string3 = headerParser.findValue("realm");
            String string4 = headerParser.findKey(0);
            authenticationInfo = AuthenticationInfo.getProxyAuth(string2, n, string3);
            if (authenticationInfo == null && "basic".equalsIgnoreCase(string4)) {
                serializable = null;
                try {
                    serializable = InetAddress.getByName(string2);
                }
                catch (UnknownHostException unknownHostException) {
                    WeblogicHandler.debugEaten(unknownHostException);
                }
                object = HttpURLConnection.privilegedRequestPasswordAuthentication(serializable, n, "http", string3, string4);
                if (object != null) {
                    authenticationInfo = new BasicAuthentication(true, string2, n, string3, (PasswordAuthentication)object);
                }
            }
            if (authenticationInfo == null && defaultAuth != null && defaultAuth.schemeSupported(string4)) {
                try {
                    serializable = new URL("http", string2, n, "/");
                    object = defaultAuth.authString((URL)serializable, string4, string3);
                    if (object != null) {
                        authenticationInfo = new BasicAuthentication(true, string2, n, string3, (String)object);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    WeblogicHandler.debugEaten(malformedURLException);
                }
            }
            if (authenticationInfo != null && !authenticationInfo.setHeaders(this, headerParser)) {
                authenticationInfo = null;
            }
        }
        return authenticationInfo;
    }

    private AuthenticationInfo getServerAuthentication() {
        AuthenticationInfo authenticationInfo = null;
        String string = this.getHeaderField("WWW-Authenticate");
        if (string != null) {
            Object object;
            HeaderParser headerParser = new HeaderParser(string);
            String string2 = headerParser.findValue("realm");
            String string3 = headerParser.findKey(0);
            authenticationInfo = AuthenticationInfo.getServerAuth(this.url, string2);
            InetAddress inetAddress = null;
            if (authenticationInfo == null) {
                try {
                    inetAddress = InetAddress.getByName(this.url.getHost());
                }
                catch (UnknownHostException unknownHostException) {
                    WeblogicHandler.debugEaten(unknownHostException);
                }
            }
            if (authenticationInfo == null && "basic".equalsIgnoreCase(string3) && (object = HttpURLConnection.privilegedRequestPasswordAuthentication(inetAddress, this.url.getPort(), this.url.getProtocol(), string2, string3)) != null) {
                authenticationInfo = new BasicAuthentication(false, this.url, string2, (PasswordAuthentication)object);
            }
            if (authenticationInfo == null && "digest".equalsIgnoreCase(string3) && (object = HttpURLConnection.privilegedRequestPasswordAuthentication(inetAddress, this.url.getPort(), this.url.getProtocol(), string2, string3)) != null) {
                authenticationInfo = new DigestAuthentication(this.url, string2, string3, (PasswordAuthentication)object);
            }
            if (authenticationInfo == null && defaultAuth != null && defaultAuth.schemeSupported(string3) && (object = defaultAuth.authString(this.url, string3, string2)) != null) {
                authenticationInfo = new BasicAuthentication(false, this.url, string2, (String)object);
            }
            if (authenticationInfo != null && !authenticationInfo.setHeaders(this, headerParser)) {
                authenticationInfo = null;
            }
        }
        return authenticationInfo;
    }

    private boolean followRedirect() throws IOException {
        if (!this.shouldFollowRedirects) {
            return false;
        }
        if (!HttpURLConnection.getFollowRedirects()) {
            return false;
        }
        int n = this.getResponseCode();
        if (n < 300 || n > 305 || n == 304) {
            return false;
        }
        String string = this.getHeaderField("Location");
        if (string == null) {
            return false;
        }
        this.disconnect();
        this.responses = new MessageHeader();
        if (n == 305) {
            URL uRL = new URL(string);
            this.http = this.getProxiedClient(this.url, uRL.getHost(), uRL.getPort());
            this.requests.set(0, this.method + " " + this.http.getURLFile() + " " + httpVersion, null);
            this.connected = true;
        } else {
            this.url = new URL(this.url, string);
            if (this.method.equals("POST") && !Boolean.getBoolean("http.strictPostRedirect")) {
                this.requests = new MessageHeader();
                this.setRequests = false;
                this.setRequestMethod("GET");
                this.poster = null;
                this.connect();
            } else {
                this.connect();
                this.requests.set(0, this.method + " " + this.http.getURLFile() + " " + httpVersion, null);
                this.requests.set("Host", this.url.getHost() + (this.url.getPort() == -1 || this.url.getPort() == 80 ? "" : ":" + String.valueOf(this.url.getPort())));
            }
        }
        return true;
    }

    void setAuthenticationProperty(String string, String string2) {
        this.requests.set(string, string2);
    }

    protected HttpClient getProxiedClient(URL uRL, String string, int n) throws IOException {
        HttpClient httpClient = new HttpClient(uRL, string, n, false);
        httpClient.openServer();
        return httpClient;
    }

    String getMethod() {
        return this.method;
    }

    public String getHeaderField(String string) {
        this.checkGetConnected();
        if (this.responses != null) {
            return this.responses.findValue(string);
        }
        return null;
    }

    public String getHeaderField(int n) {
        this.checkGetConnected();
        if (this.responses != null) {
            return this.responses.getValue(n);
        }
        return null;
    }

    public String getHeaderFieldKey(int n) {
        this.checkGetConnected();
        if (this.responses != null) {
            return this.responses.getKey(n);
        }
        return null;
    }

    private void checkGetConnected() {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            WeblogicHandler.debugEaten(iOException);
        }
    }

    public void setRequestProperty(String string, String string2) {
        if (this.connected) {
            throw new IllegalAccessError(Resources.getMessage("189"));
        }
        this.requests.set(string, string2);
    }

    public String getRequestProperty(String string) {
        return this.requests.findValue(string);
    }
}

