/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.net.ssl.internal;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.locale.Resources;
import com.certicom.net.ssl.internal.HttpClient;
import com.certicom.net.ssl.internal.MeteredStream;
import com.certicom.net.ssl.internal.ProgressData;
import com.certicom.net.ssl.internal.ProgressEntry;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class KeepAliveStream
extends MeteredStream {
    HttpClient hc;
    boolean hurried;

    public KeepAliveStream(InputStream inputStream, ProgressEntry progressEntry, HttpClient httpClient) {
        super(inputStream, progressEntry);
        this.hc = httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this.expected > this.count) {
                this.skip(this.expected - this.count);
            }
            if (!this.closed && !this.hurried) {
                HttpClient.finished(this.hc);
            }
        }
        finally {
            ProgressData.pdata.unregister(this.te);
            this.closed = true;
            this.in.close();
        }
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int n) {
    }

    public void reset() throws IOException {
        throw new IOException(Resources.getMessage("42"));
    }

    public synchronized boolean hurry() {
        try {
            if (this.closed || this.count >= this.expected) {
                return false;
            }
            if (this.in.available() < this.expected - this.count) {
                return false;
            }
            byte[] byArray = new byte[this.expected - this.count];
            DataInputStream dataInputStream = new DataInputStream(this.in);
            dataInputStream.readFully(byArray);
            this.in = new ByteArrayInputStream(byArray);
            this.hurried = true;
            return true;
        }
        catch (IOException iOException) {
            WeblogicHandler.debugEaten(iOException);
            return false;
        }
    }
}

