/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.nio;

import com.certicom.io.InputSSLIO;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public final class InputSSLIOChannel
implements InputSSLIO {
    private static final int MAX_BUF_SIZE = 2048;
    private ReadableByteChannel in;
    private ByteBuffer bb = null;
    private int bytesAvailable = 0;

    public InputSSLIOChannel(ReadableByteChannel readableByteChannel) {
        this.in = readableByteChannel;
        this.bb = ByteBuffer.allocate(2048);
        this.bb.flip();
    }

    public boolean isOpen() {
        return this.in.isOpen();
    }

    public void close() throws IOException {
        this.in.close();
    }

    public int available() throws IOException {
        this.bytesAvailable = this.in.read(this.bb);
        this.bb.flip();
        return this.bytesAvailable;
    }

    public int read(byte[] byArray) throws IOException {
        if (this.bb.limit() != 0) {
            int n = this.bb.limit();
            this.bb.get(byArray);
            this.bb.clear();
            return n;
        }
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        int n3 = this.in.read(byteBuffer);
        if (n3 != 0 && n3 != -1) {
            byteBuffer.flip();
            byteBuffer.get(byArray, n, n3);
        }
        return n3;
    }

    public ReadableByteChannel getRawChannel() {
        return this.in;
    }
}

