/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.nio;

import com.certicom.io.InputSSLIO;
import com.certicom.nio.InputSSLIOChannel;
import com.certicom.tls.record.ReadHandler;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class InputSSLIOChannelWrapper
implements ReadableByteChannel {
    private InputSSLIO in = null;

    public InputSSLIOChannelWrapper(InputSSLIO inputSSLIO) {
        this.in = inputSSLIO;
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        byte[] byArray = new byte[byteBuffer.remaining()];
        int n = this.in.read(byArray);
        if (n == -1) {
            return -1;
        }
        if (n == 0) {
            return 0;
        }
        if (n > byteBuffer.capacity()) {
            throw new BufferOverflowException();
        }
        byteBuffer.put(byArray, 0, n);
        return n;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public boolean isOpen() {
        return this.in.isOpen();
    }

    public ReadableByteChannel getRawChannel() {
        InputSSLIO inputSSLIO = ((ReadHandler)this.in).getRawInput();
        return ((InputSSLIOChannel)inputSSLIO).getRawChannel();
    }
}

