/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.nio;

import com.bea.sslplus.WeblogicHandler;
import com.certicom.io.OutputSSLIO;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;
import java.util.Vector;

public final class OutputSSLIOChannel
implements OutputSSLIO {
    private WritableByteChannel out;
    private Vector buffers;
    private Selector selector;

    public OutputSSLIOChannel(WritableByteChannel writableByteChannel) {
        this.out = writableByteChannel;
        this.buffers = new Vector(2, 2);
    }

    public boolean isOpen() {
        return this.out.isOpen();
    }

    public void close() throws IOException {
        this.out.close();
        if (this.selector != null) {
            this.selector.close();
        }
    }

    public int write(byte[] byArray) throws IOException {
        return this.write(byArray, 0, byArray.length);
    }

    public int write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 > 0) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
            byteBuffer.put(byArray, n, n2);
            byteBuffer.flip();
            this.buffers.add(byteBuffer);
        }
        this.flush();
        return n2;
    }

    public void flush() throws IOException {
        boolean bl = false;
        while (this.buffers.size() > 0 && !bl) {
            Object object;
            if (!((SocketChannel)this.out).isBlocking()) {
                if (this.selector == null) {
                    this.selector = Selector.open();
                }
                ((SocketChannel)this.out).register(this.selector, 4);
                while (this.selector.select() > 0) {
                    object = this.selector.selectedKeys();
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        SelectionKey selectionKey = (SelectionKey)iterator.next();
                        iterator.remove();
                        if (!selectionKey.isWritable()) continue;
                        if (this.buffers.size() == 0) {
                            return;
                        }
                        ByteBuffer byteBuffer = (ByteBuffer)this.buffers.get(0);
                        if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                            WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Before write - buf=" + byteBuffer.hashCode() + ", Buffer remain byte= " + byteBuffer.remaining() + "; blocking=" + ((SocketChannel)this.out).isBlocking(), null);
                        }
                        int n = this.out.write(byteBuffer);
                        if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                            WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "After write - buf=" + byteBuffer.hashCode() + ", Wrote bytes= " + n + ", remaining bytes= " + byteBuffer.remaining(), null);
                        }
                        if (n == 0 && WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                            WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Wrote Nothing", null);
                        }
                        if (byteBuffer.remaining() == 0) {
                            this.buffers.remove(0);
                        }
                        if (this.buffers.size() != 0) continue;
                        return;
                    }
                }
                continue;
            }
            object = (ByteBuffer)this.buffers.get(0);
            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Before write - buf=" + ((ByteBuffer)object).hashCode() + ", Buffer remain byte= " + ((Buffer)object).remaining() + "; blocking=" + ((SocketChannel)this.out).isBlocking(), null);
            }
            int n = this.out.write((ByteBuffer)object);
            if (WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "After write - buf=" + ((ByteBuffer)object).hashCode() + ", Wrote bytes= " + n + ", remaining byte= " + ((Buffer)object).remaining(), null);
            }
            if (n == 0 && WeblogicHandler.isDebugEnabled(WeblogicHandler.DEBUG_INFO)) {
                WeblogicHandler.debug(WeblogicHandler.DEBUG_INFO, "Wrote Nothing", null);
            }
            if (((Buffer)object).remaining() != 0) continue;
            this.buffers.remove(0);
        }
    }

    public boolean hasPendingBytes() {
        return this.buffers.size() > 0;
    }
}

