/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.asn1;

import com.certicom.security.asn1.ASN1EncodingException;
import com.certicom.security.asn1.ASN1InputStream;
import com.certicom.security.asn1.ASN1OutputStream;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1String;

public final class ASN1BMPString
extends ASN1String {
    private byte[] bytes;

    public ASN1BMPString() {
    }

    public ASN1BMPString(byte[] byArray) {
        this.setValue(byArray);
    }

    public ASN1BMPString(String string) {
        this.setValue(string);
    }

    public void decode(ASN1InputStream aSN1InputStream) throws ASN1ParsingException {
        aSN1InputStream.decodeString(this);
    }

    public void encode(ASN1OutputStream aSN1OutputStream) throws ASN1EncodingException {
        aSN1OutputStream.encodeString(this);
    }

    public int length() {
        return this.bytes.length / 2;
    }

    public String getString() {
        byte[] byArray = new byte[this.bytes.length / 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = this.bytes[i * 2 + 1];
            byArray[i] = this.bytes[i * 2] == 0 && n > 0 && n <= 127 ? n : 63;
        }
        return new String(byArray);
    }

    public void setValue(String string) {
        byte[] byArray = string.getBytes();
        this.bytes = new byte[byArray.length * 2];
        for (int i = 0; i < byArray.length; ++i) {
            this.bytes[i * 2] = 0;
            this.bytes[i * 2 + 1] = byArray[i];
        }
    }

    public void setValue(byte[] byArray) {
        this.bytes = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.bytes, 0, byArray.length);
    }

    public byte[] toByteArray() {
        return this.bytes;
    }

    void setBufferTo(byte[] byArray) {
        this.setValue(byArray);
    }

    public byte typeTag() {
        return 30;
    }
}

