/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.asn1;

import com.certicom.security.asn1.ASN1EncodingException;
import com.certicom.security.asn1.ASN1InputStream;
import com.certicom.security.asn1.ASN1OutputStream;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1Primitive;

public class ASN1BitString
extends ASN1Primitive {
    private byte[] buffer;
    private int unusedBits;

    public ASN1BitString() {
        this.buffer = new byte[0];
        this.unusedBits = 0;
    }

    public ASN1BitString(byte[] byArray) {
        if (byArray == null) {
            this.buffer = null;
        } else {
            this.buffer = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.buffer, 0, byArray.length);
        }
        this.unusedBits = 0;
    }

    public byte typeTag() {
        return 3;
    }

    public void setUnusedBits(int n) {
        this.unusedBits = n;
    }

    public int getUnusedBits() {
        return this.unusedBits;
    }

    public void decode(ASN1InputStream aSN1InputStream) throws ASN1ParsingException {
        aSN1InputStream.decodeBitString(this);
    }

    public void encode(ASN1OutputStream aSN1OutputStream) throws ASN1EncodingException {
        aSN1OutputStream.encodeBitString(this);
    }

    public int bitLength() {
        return 8 * this.buffer.length;
    }

    public byte[] toByteArray() {
        return this.buffer;
    }

    void setBufferTo(byte[] byArray) {
        this.buffer = byArray;
    }
}

