/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.asn1;

import com.certicom.security.asn1.ASN1EncodingException;
import com.certicom.security.asn1.ASN1InputStream;
import com.certicom.security.asn1.ASN1OutputStream;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1Primitive;

public class ASN1Boolean
extends ASN1Primitive {
    boolean value;

    public ASN1Boolean() {
        this.value = false;
    }

    public ASN1Boolean(boolean bl) {
        this.value = bl;
    }

    public ASN1Boolean(ASN1Boolean aSN1Boolean) {
        this.value = aSN1Boolean.value;
    }

    public byte typeTag() {
        return 1;
    }

    public void decode(ASN1InputStream aSN1InputStream) throws ASN1ParsingException {
        aSN1InputStream.decodeBoolean(this);
    }

    public void encode(ASN1OutputStream aSN1OutputStream) throws ASN1EncodingException {
        aSN1OutputStream.encodeBoolean(this);
    }

    public boolean toBoolean() {
        return this.value;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[]{this.value ? (byte)-1 : 0};
        return byArray;
    }

    void setBufferTo(byte[] byArray) throws ASN1ParsingException {
        if (byArray == null || byArray.length != 1) {
            throw new ASN1ParsingException("Wrong boolean size");
        }
        this.value = byArray[0] != 0;
    }
}

