/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.asn1;

import com.certicom.security.asn1.ASN1EncodingException;
import com.certicom.security.asn1.ASN1InputStream;
import com.certicom.security.asn1.ASN1OutputStream;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1Primitive;
import java.math.BigInteger;

public class ASN1Integer
extends ASN1Primitive {
    public static final BigInteger ZERO = BigInteger.valueOf(0L);
    private BigInteger n;

    public ASN1Integer() {
        this.n = null;
    }

    public ASN1Integer(int n) {
        this.n = BigInteger.valueOf(n);
    }

    public ASN1Integer(byte[] byArray) throws ASN1ParsingException {
        if (byArray.length == 0) {
            throw new ASN1ParsingException("Zero size integer");
        }
        this.n = new BigInteger(byArray);
    }

    public ASN1Integer(BigInteger bigInteger) {
        this.n = new BigInteger(bigInteger.toByteArray());
    }

    public byte typeTag() {
        return 2;
    }

    public void encode(ASN1OutputStream aSN1OutputStream) throws ASN1EncodingException {
        aSN1OutputStream.encodeInteger(this);
    }

    public void decode(ASN1InputStream aSN1InputStream) throws ASN1ParsingException {
        aSN1InputStream.decodeInteger(this);
    }

    public byte[] toByteArray() {
        if (this.n == null) {
            byte[] byArray = new byte[]{0};
            return byArray;
        }
        return this.n.toByteArray();
    }

    public BigInteger toBigInteger() {
        if (this.n == null) {
            return ZERO;
        }
        return this.n;
    }

    void setBufferTo(byte[] byArray) throws ASN1ParsingException {
        if (byArray.length == 0) {
            throw new ASN1ParsingException("Zero size integer");
        }
        this.n = new BigInteger(byArray);
    }
}

