/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.asn1;

import com.certicom.security.asn1.ASN1EncodingException;
import com.certicom.security.asn1.ASN1InputStream;
import com.certicom.security.asn1.ASN1OutputStream;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1Primitive;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ASN1OID
extends ASN1Primitive {
    String oid = null;

    public ASN1OID() {
    }

    public ASN1OID(String string) {
        if (ASN1OID.convertToOctets(string) != null) {
            this.oid = string;
        }
    }

    public ASN1OID(byte[] byArray) throws ASN1ParsingException {
        this.oid = ASN1OID.convertToString(byArray);
        if (this.oid == null) {
            throw new ASN1ParsingException("Could not convert OID to string");
        }
    }

    public byte typeTag() {
        return 6;
    }

    public String toString() {
        return this.oid;
    }

    public void decode(ASN1InputStream aSN1InputStream) throws ASN1ParsingException {
        aSN1InputStream.decodeOID(this);
    }

    public void encode(ASN1OutputStream aSN1OutputStream) throws ASN1EncodingException {
        aSN1OutputStream.encodeOID(this);
    }

    public byte[] toByteArray() {
        return ASN1OID.convertToOctets(this.oid);
    }

    public static byte[] convertToOctets(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while ((n2 = string.indexOf(46, n)) != -1) {
            n = n2 + 1;
            ++n3;
        }
        if (n3 < 2) {
            return null;
        }
        int[] nArray = new int[++n3];
        n = 0;
        int n4 = 0;
        String string2 = null;
        while ((n2 = string.indexOf(46, n)) != -1) {
            string2 = string.substring(n, n2);
            nArray[n4++] = Integer.valueOf(string2);
            n = n2 + 1;
        }
        string2 = string.substring(n);
        nArray[n4] = Integer.valueOf(string2);
        if (nArray[0] < 0 || nArray[0] > 2) {
            return null;
        }
        if (nArray[1] < 0 || nArray[1] >= 40) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write((byte)(nArray[0] * 40 + nArray[1]));
        for (n4 = 2; n4 < n3; ++n4) {
            if (ASN1OID.encodeArc(nArray[n4], byteArrayOutputStream)) continue;
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static String convertToString(byte[] byArray) {
        if (byArray.length < 1) {
            return null;
        }
        int n = byArray[0];
        if (n < 0) {
            n = 0x7F & n | 0x80;
        }
        int n2 = n < 40 ? 0 : (n < 80 ? 1 : 2);
        String string = String.valueOf(n2);
        n2 = n - n2 * 40;
        string = string + "." + String.valueOf(n2);
        n2 = 0;
        for (int i = 1; i < byArray.length; ++i) {
            if ((byArray[i] & 0x80) == 0) {
                string = string + "." + String.valueOf(n2 += byArray[i]);
                n2 = 0;
                continue;
            }
            n2 += byArray[i] & 0x7F;
            n2 <<= 7;
        }
        if (byArray.length > 1 && (byArray[byArray.length - 1] & 0x80) != 0) {
            return null;
        }
        if (n2 != 0) {
            return null;
        }
        return string;
    }

    void setBufferTo(byte[] byArray) throws ASN1ParsingException {
        this.oid = ASN1OID.convertToString(byArray);
        if (this.oid == null) {
            throw new ASN1ParsingException("Could not convert OID to string");
        }
    }

    private static boolean encodeArc(int n, OutputStream outputStream) {
        int n2;
        byte[] byArray = new byte[4];
        for (n2 = 0; n2 < 4; ++n2) {
            byArray[n2] = (byte)(n & 0x7F);
            if ((n >>>= 7) == 0) break;
        }
        try {
            while (n2 > 0) {
                outputStream.write((byte)(byArray[n2] | 0x80));
                --n2;
            }
            outputStream.write(byArray[0]);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }
}

