/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.asn1;

import com.certicom.security.asn1.ASN1EncodingException;
import com.certicom.security.asn1.ASN1InputStream;
import com.certicom.security.asn1.ASN1OutputStream;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1Primitive;

public class ASN1OctetString
extends ASN1Primitive {
    private byte[] buffer;
    private int expectedLength = 0;

    public ASN1OctetString() {
        this.buffer = null;
    }

    public ASN1OctetString(int n) {
        this.buffer = null;
        this.expectedLength = n;
    }

    public ASN1OctetString(byte[] byArray) {
        this.buffer = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.buffer, 0, byArray.length);
    }

    public byte typeTag() {
        return 4;
    }

    public void decode(ASN1InputStream aSN1InputStream) throws ASN1ParsingException {
        aSN1InputStream.decodeOctetString(this);
    }

    public void encode(ASN1OutputStream aSN1OutputStream) throws ASN1EncodingException {
        aSN1OutputStream.encodeOctetString(this);
    }

    public int length() {
        return this.expectedLength;
    }

    public int actualLength() {
        if (this.buffer == null) {
            return 0;
        }
        return this.buffer.length;
    }

    public byte[] toByteArray() {
        return this.buffer;
    }

    public void setBufferTo(byte[] byArray) {
        if (this.expectedLength == 0 || byArray == null || byArray.length != this.expectedLength) {
            // empty if block
        }
        this.buffer = byArray;
    }
}

