/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.security.asn1;

import com.certicom.security.asn1.ASN1EncodingException;
import com.certicom.security.asn1.ASN1InputStream;
import com.certicom.security.asn1.ASN1OutputStream;
import com.certicom.security.asn1.ASN1ParsingException;
import com.certicom.security.asn1.ASN1Sequence;
import com.certicom.security.asn1.ASN1Type;
import java.util.Vector;

public abstract class ASN1SequenceOf
extends ASN1Sequence {
    ASN1Type pattern;
    Vector sequence;

    public ASN1SequenceOf(ASN1Type aSN1Type) {
        this.pattern = aSN1Type;
        this.sequence = new Vector();
    }

    public int size() {
        return this.sequence.size();
    }

    public boolean addItem(ASN1Type aSN1Type) {
        if (aSN1Type.tag() == this.pattern.tag()) {
            this.sequence.addElement(aSN1Type);
            return true;
        }
        return false;
    }

    public ASN1Type getItem(int n) {
        if (n >= 0 && n < this.sequence.size()) {
            return (ASN1Type)this.sequence.elementAt(n);
        }
        return null;
    }

    public boolean removeItem(int n) {
        if (n >= 0 && n < this.sequence.size()) {
            this.sequence.removeElementAt(n);
            return true;
        }
        return false;
    }

    protected void decodeContents(ASN1InputStream aSN1InputStream) throws ASN1ParsingException {
        this.sequence = new Vector();
        try {
            while (!aSN1InputStream.eof()) {
                ASN1Type aSN1Type = (ASN1Type)this.pattern.getClass().newInstance();
                aSN1Type.decode(aSN1InputStream);
                this.sequence.addElement(aSN1Type);
            }
        }
        catch (InstantiationException instantiationException) {
            throw new ASN1ParsingException(instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ASN1ParsingException(illegalAccessException.getMessage());
        }
    }

    protected void encodeContents(ASN1OutputStream aSN1OutputStream) throws ASN1EncodingException {
        for (int i = 0; i < this.sequence.size(); ++i) {
            ASN1Type aSN1Type = (ASN1Type)this.sequence.elementAt(i);
            aSN1Type.encode(aSN1OutputStream);
        }
    }
}

